/*****************************************************************************
 *                                  L I N M I N 4
 *****************************************************************************
 *
 *   PROGRAM ID:        LINMIN4.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This routine does line searches, which are an integral part of most
 *      multi-dimensional optimizations.
 *
 *      It has a very simple appearance, and is based on the article:
 *
 *          J Rohn, Computing (1993), p.373
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


/* locally global variables */
static OPTFXN F;



/* local macros & functions */
static float F1dim( int n, float x[], float s[], float t )
{
      int k;
      float a;

      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] +t*s[k];
      a= F( n, x );
      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] -t*s[k];
      return ( a );
}


/* *********** HERE IS THE ENTRY POINT FOR THIS MODULE ************* */

void linmin4( int n, float x[], OPTFXN FXN, float g[], float s[], float *F0 )
/*
   This subroutine starts at the point x[] and moves in the
   search direction s[] so as to minimize the objective function
   F.  g[] is the gradient at x[], F0 is the fxn value at x[]

   On return, x[] is updated to x[]+dx[] which minimizes F,
   s[] is set to the actual step (dx[]), and F0 is F(x+dx).
*/
{
int   i, j;
int   bDone;
float Fvalue, sg, a, b, c, cstop;

    F= FXN;
    cstop= 0.01 * G_EPS;
    for( sg=0, i=1 ; i<=n ; i++ )
        sg += s[i]*g[i];

    if( sg > 0.0 )
    {
        a= -0.01;
        Fvalue= F1dim( n, x, s, a );
        bDone= 1;
    }
    else
    {
        bDone= 0;
    }


    for( a=1, j=0 ; !bDone ; j++ )
    {
        Fvalue= F1dim( n, x, s, a );

        c= Fvalue -F0[0] -a*sg;

        if( c <= cstop )
        {
            bDone= 1;
        }
        else
        {
            b= -sg*(a*a) / (c+c);
            if( a/b < 2.0 )
                bDone= 1;
            else
                a= b;
        }
    }

    for( i=1 ; i<=n ; i++ )
    {
        s[i] *= a;
        x[i] += s[i];
    }
    F0[0]= Fvalue;
}

