/*****************************************************************************
 *                                  N A N D M
 *****************************************************************************
 *
 *   PROGRAM ID:        NANDM.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This is the simplex method of Nelder and Mead (N and M--get it?)
 *      See Comp J (1965) p308 for details.
 *
 *      This method does not use derivative info, the presence of the
 *      derivative in the argument list is purely cosmetic (to make all
 *      of the optimization routines look the same) and is ignored.
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of a subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>

// locally global variables
static OPTFXN F;
static int nLoops;


// local functions and macros
#define TINY   1.0e-10
static void amoeba( int ndim, float **p, float y[], float ftol,
                    float (*funk)(float []), int *nfunk);
static void opt( int n, float pr[], float Ftol, float prr[],
                 float pbar[], float y[], float *p[] );




/*
   ******* HERE IS THE ENTRY POINT INTO THIS MODULE *********
*/
int nandm( int n, float *x, OPTFXN FXN, GRADF DFXN, float tol )
/*
   This subroutine is just a dummy to allocate the 2*n & (n+1)^2
   dimensional workspaces w1 & w2 which are needed by these
   subroutines. This is a holdover from the FORTRAN roots of
   this library. In FORTRAN, you can't dynamically allocate
   an array, so the calling program must create a "work array"
   of a certain size. Then you use clever function parameter
   mapping to divvy up this array into all of the vectors and
   matrices needed in the library module.

   This subroutine also assigns user defined functions to
   (locally) global pointers, so we don't have to keep passing
   them to each lower level.
*/
{
    float **w1, **w2;
    w1= matrix( 1, 2, 1, n );
    w2= matrix( 1, n+1, 1, n+1 );
    F= FXN;

    if ( tol <= 0.0 )  tol= 1.0e-6;
    opt( n, x, tol, w1[1], w1[2], w2[1], &w2[1] );
    free_matrix( w1, 1, 2, 1, n );
    free_matrix( w2, 1, n+1, 1, n+1 );

    return( nLoops );
}






static void opt( int n, float pr[], float Ftol, float prr[],
                 float pbar[], float y[], float *p[] )
{
    float alpha= 1.0, beta= 0.5, gamma= 2.0;
    float ypr, yprr, rtol, diff, dxabs, xabs;
    int   i, j, m, ilo, ihi, inhi, nLoopMax;

    nLoopMax= max(500,5*n*n);
    m= n+1;



/*
   This first section is my auto-start.  x has been mapped to
   pr in the subroutine calls, and this is the only guess
   the user has to make at the soln vector.  The other initial
   vectors are the n-orthonormal coord vectors added to x.
*/
    for ( i=1 ; i<=n ; i++ )
    {
        //rtol= 0;
        for ( j=1 ; j<=n ; j++ )
        {
            p[j][i]= pr[i];
            //rtol= max(rtol,fabs(pr[j]));
        }
        p[m][i]= pr[i];
        //p[i][i]= rtol*0.001 +p[i][i];
        p[i][i]= 1.001 *(p[i][i]+TINY);
        //pbar[i]= pr[i];
    }

    for ( i=1 ; i<=n ; i++ )
    {
        //pbar[i]= rtol*0.001 +pbar[i];
        pbar[i]= 1.001 *(pr[i]+TINY);
        y[i]= F( n, pbar );
        pbar[i]= pr[i];
        //pbar[i]= pbar[i] -rtol*0.001;
    }
    y[m]= F( n, pr );


// ***************************************************************************
// Start of main iteration
// ***************************************************************************
for ( nLoops=0 ; nLoops<nLoopMax ; nLoops++ )
{
    printf( "%5d\r", nLoops );

    ilo= 1;

    if ( y[1] > y[2] )
    {
        ihi= 1;
        inhi= 2;
    }
    else
    {
        ihi= 2;
        inhi= 1;
    }

    for ( i=1 ; i<=m ; i++ )
    {
        if ( y[i] < y[ilo] )  ilo= i;
        if ( y[i] > y[ihi] )
        {
            inhi= ihi;
            ihi= i;
        }
        else if ( y[i] > y[inhi] && i!=ihi )
            inhi= i;
    }

///****/ printf( "nandm: F= %e\n", y[ilo] );
///****/ printf( "\t  x= (%e %e)\n", pr[1], pr[2] );
    rtol= 2.0*fabs(y[ihi]-y[ilo])/(fabs(y[ihi]+y[ilo]));

    for ( xabs=dxabs=0, j=1 ; j<=n ; j++ )
    {
          xabs  += p[ilo][j]*p[ilo][j];
          diff= p[ihi][j]-p[ilo][j];
          dxabs += diff*diff;
    }
    xabs= sqrt( xabs );
    dxabs= sqrt( dxabs );


// exit tests
    if( rtol<Ftol  ||  fabs(y[ihi]-y[ilo]) < Ftol*(1+fabs(y[ilo]))  ||  dxabs < Ftol*(1+xabs) )
         break;



    for ( j=1 ; j<=n ; j++ )
        pbar[j]= 0.0;

    for ( i= 1 ; i<=m ; i++ )
    {
        if ( i != ihi )
            for ( j=1 ; j<=n ; j++ )
                pbar[j]= pbar[j] +p[i][j];
    }

    for ( j=1 ; j<=n ; j++ )
    {
        pbar[j]= pbar[j]/n;
        pr[j]= ( 1.0+alpha )*pbar[j] -alpha*p[ihi][j];
    }

    ypr= F( n, pr );
    if ( ypr <= y[ilo] )
    {
        for ( j=1 ; j<=n ; j++ )
            prr[j]= gamma*pr[j] +( 1.0-gamma )*pbar[j];

        yprr= F( n, prr );
        if ( yprr < y[ilo] )
        {
            for ( j=1 ; j<=n ; j++ )
                p[ihi][j]= prr[j];
            y[ihi]= yprr;
        }
        else
        {
            for ( j=1 ; j<=n ; j++ )
                p[ihi][j]= pr[j];
            y[ihi]= ypr;
        }
    }
    else if ( ypr >= y[inhi] )
    {
        if ( ypr < y[ihi] )
        {
            for ( j=1 ; j<=n ; j++ )
                   p[ihi][j]= pr[j];
            y[ihi]= ypr;
        }

        for ( j=1 ; j<=n ; j++ )
            prr[j]= beta*p[ihi][j] +(1.0-beta)*pbar[j];

        yprr= F( n, prr );
        if ( yprr < y[ihi] )
        {
            for ( j=1 ; j<=n ; j++ )
                p[ihi][j]= prr[j];
            y[ihi]= yprr;
        }
        else
        {
            for ( i=1 ; i<=m ; i++ )
            {
                if ( i != ilo )
                {
                    for ( j=1 ; j<=n ; j++ )
                    {
                        pr[j]= 0.5*(p[i][j]+p[ilo][j]);
                        p[i][j]= pr[j];
                    }
                    y[i]= F( n, pr );
                }
            }
        }
    }
    else
    {
        for ( j=1 ; j<=n ; j++ )
            p[ihi][j]= pr[j];
        y[ihi]= ypr;
    }

}



if ( nLoops >= nLoopMax )
    nLoops= -nLoops;

for ( j=1 ; j<=n ; j++ )
    pr[j]= p[ilo][j];

}
