/*****************************************************************************
 *                                  Q N D A V
 *****************************************************************************
 *
 *   PROGRAM ID:        QNDAV.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This is my interpretation of WC Davidon's 1975 optimization
 *      algorithm.  It was revolutionary because it did away with the
 *      burdensome line searches of earlier quasi-newton methods.
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of a subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>

// locally global variables
static OPTFXN F;
static GRADF grad;
static int nLoops;


// local functions and macros
#define TINY   1.0e-10
static void gradF( int n, float x[], float fo, float g[] );
static void opt( int n, float x[], float e,
                 float xo[], float g[], float w[], float s[], float ki[],
                 float ko[], float m[], float r[], float u[], float p[],
                 float q[], float Js[], float *J[] );



/*
   ******* HERE IS THE ENTRY POINT INTO THIS MODULE *********
*/
int qndav( int n, float x[], OPTFXN FXN, GRADF DFXN, float tol )
/*
   This subroutine is just a dummy to allocate the n(n+12)
   dimensional workspace w which is needed by the following
   subroutines. This is a holdover from the FORTRAN roots of
   this library. In FORTRAN, you can't dynamically allocate
   an array, so the calling program must create a "work array"
   of a certain size. Then you use clever function parameter
   mapping to divvy up this array into all of the vectors and
   matrices needed in the library module.

   This subroutine also assigns user defined functions to
   (locally) global pointers, so we don't have to keep passing
   them to each lower level.
*/
{
    float **w;
    w= matrix( 1, n+12, 1, n );
    F= FXN;
    if( DFXN )
        grad= DFXN;
    else
        grad= gradF;


///****/ printf( "qndav: ENTRY\n" );
///****/ printf( "\t  x= (%e %e)\n", x[1], x[2] );
    opt( n, x, tol, w[1], w[2], w[3],  w[4],  w[5],   w[6], w[7],
                    w[8], w[9], w[10], w[11], w[12], &w[12] );
    free_matrix( w, 1, n+12, 1, n );

    return( nLoops );
}




static void opt( int n, float x[], float e,
                 float xo[], float g[], float w[], float s[], float ki[],
                 float ko[], float m[], float r[], float u[], float p[],
                 float q[], float Js[], float *J[] )
{
    float mm, mw, mu, qko, alpha, v, delta, rr, gamma, a, b, c, bo,
          us, uu, um, t, df, fo, fi, dfo;
    float *Jq; /* just an alias for Js */
    float gabs;
    int   nLoopMax, i, k;


// initial section
///****/ printf( "\tInitial  x= (%e %e)\n", x[1], x[2] );
    nLoops= 0;
    nLoopMax= n*n;
    if( nLoopMax< 200 )
        nLoopMax= 200;
    fo= F( n, x );
    grad( n, x, fo, g );

    for ( gabs=0, i=1 ; i<=n ; i++ )
    {
        for ( k=i ; k<=n ; k++ )
        {
            J[i][k]= 0.0;
            J[k][i]= 0.0;
        }
        gabs += g[i]*g[i];
    }
    gabs= sqrt( 1+gabs );

    for ( i=1 ; i<=n ; i++ )
    {
        J[i][i]= g[i]/gabs;
        ko[i]= g[i]*g[i]/gabs;
        w[i]= ko[i];
        xo[i]= x[i];
    }
    Jq= Js; // assign alias


label1:
    dfo= 0.0;
    t= 2.0;
    for ( i=1 ; i<=n ; i++ )
    {
        s[i]= -ko[i];
        dfo += s[i]*s[i];
    }
    dfo= -dfo;

    if ( 4.0*fo< -dfo )
    {
        for ( i=1 ; i<=n ; i++ )
            s[i]= -s[i]*4.0*fo/dfo;
        dfo= -4.0*fo;
    }

label2:
    for ( i=1 ; i<=n ; i++ )
    {
        Js[i]= 0.0;
        for ( k=1 ; k<=n ; k++ )
            Js[i] += J[i][k]*s[k];
        x[i]= xo[i] +Js[i];
    }


///****/ printf( "qndav: F= %e\n", fo );
///****/ printf( "\t  g= (%e %e)\n", g[1], g[2] );
///****/ printf( "\t  x= (%e %e)\n", x[1], x[2] );

// exit tests

    nLoops++;
    if ( dfo>= -e || nLoops> nLoopMax )  goto label8;

    printf( "%5d  F=%16.8e\r", nLoops, fo );


    fi= F( n, x );
    if ( fi> fo )
    {
        for ( i=1 ; i<=n ; i++ )
            s[i]= s[i]/2.0;
        dfo= dfo/2.0;
        t= 0.5;
        goto label2;
    }

label3:
    df= 0.0;
    grad( n, x, fi, g );
    for ( i=1 ; i<=n ; i++ )
    {
        ki[i]= 0.0;
        for ( k=1 ; k<=n ; k++ )
            ki[i]= ki[i] +g[k]*J[k][i];
        df= df +ki[i]*s[i];
        m[i]= s[i] +ko[i] -ki[i];
        ko[i]= ki[i];
        xo[i]= x[i];
    }

    bo= df -dfo;
    fo= fi;
    dfo= df;
    if ( bo< e )
    {
        for ( i=1 ; i<=n ; i++ )
            s[i]= t*s[i];
        dfo= t*dfo;
        goto label2;
    }

label4:
    mm= 0.0;
    mw= 0.0;
    v= 0.0;
    for ( i=1 ; i<=n ; i++ )
    {
        mm= mm +m[i]*m[i];
        mw= mw +m[i]*w[i];
        v=  v  +m[i]*s[i];
    }

    if ( mm< e ) goto label1;
    mu= v -mm;
    um= 0.0;
    uu= 0.0;
    us= 0.0;
    for ( i=1 ; i<=n ; i++ )
    {
        u[i]= w[i] -mw*m[i]/mm;
        um= um +u[i]*m[i];
        uu= uu +u[i]*u[i];
        us= us+ u[i]*s[i];
    }

    if ( um*um*1.0e6 < mm*uu )
    {
        for ( i=1 ; i<=n ; i++ )
            r[i]= us*u[i]/uu;
        rr= us*us/uu;
    }
    else
    {
        for ( i=1 ; i<=n ; i++ )
            r[i]= 0.0;
        rr= 0.0;
    }

label5:
    b= rr +mu*v/mm;
    if ( b< e )
    {
        rr= bo -mu*v/mm;
        for ( i=1 ; i<=n ; i++ )
            r[i]= s[i] -v*m[i]/mm;
        b= bo;
    }

label6:
    if ( mu*v < mm*rr )
    {
        a= b -mu;
        c= b +v;
        gamma= sqrt( (1.0 -mu*v/(mm*rr) ) /(a*b) );
        if ( c< a ) gamma= -gamma;
        delta= sqrt( c/a );
    }
    else
    {
        gamma= 0.0;
        delta= sqrt( v/mu );
    }

label7:
    alpha= v +mu*delta +mm*rr*gamma;
    qko= 0.0;
    for ( i=1 ; i<=n ; i++ )
    {
        p[i]= m[i]*(delta-rr*gamma) +r[i]*v*gamma;
        q[i]= ( m[i]*(1.0+rr*gamma) -r[i]*mu*gamma )/alpha;
        w[i]= m[i]*rr*(1.0+mu*v*gamma/alpha)
                    -r[i]*(1.0+delta)*mu*v/alpha;
        qko= qko +q[i]*ko[i];
    }

    for ( i=1 ; i<=n ; i++ )
    {
        Jq[i]= 0.0;
        for ( k=1 ; k<=n ; k++ )
            Jq[i]= Jq[i] +J[i][k]*q[k];
        ko[i]= ko[i] +qko*p[i];
    }

    for ( i=1 ; i<=n ; i++ )
        for ( k=1 ; k<=n ; k++ )
            J[i][k]= J[i][k] + Jq[i]*p[k];

    if ( rr<= 0.0 )
        for ( i=1 ; i<=n ; i++ )
            w[i]= ko[i];
    goto label1;

label8:

    if( nLoops> nLoopMax )
        nLoops= -nLoops;
}






static void gradF( int n, float x[], float F0, float g[] )
{
    int i;
    float a, t, e= G_EPS;

    for ( i=1 ; i<=n ; i++ )
    {
        a= fabs( x[i] );
        if ( a< 1.0 )  a= 1.0;
        a= a*e;
        t= x[i];
        x[i]= t+a;
        g[i]= ( F(n,x) -F0 ) / a;
        x[i]= t;
    }
}

