# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* $Id: lex.l 3.9 1992/12/02 02:04:35 cthuang Exp $
 *
 * Lexical analyzer for C function prototype generator
 */

static int curly;	/* number of curly brace nesting levels */
static int ly_count;	/* number of occurances of %% */

#ifdef FLEX_SCANNER
/* flex scanner state */
static YY_BUFFER_STATE buffer_stack[MAX_INC_DEPTH];
#endif

static int inc_depth;				/* include nesting level */
static IncludeStack inc_stack[MAX_INC_DEPTH];	/* stack of included files */
static SymbolTable *included_files;		/* files already included */

static void update_line_num();
static void save_text();
static void save_text_offset();
static void get_comment();
static void get_cpp_directive();
static void do_include();

extern void yyerror();
#ifdef yywrap
#undef yywrap
#endif
# define CPP1 2
# define INIT1 4
# define INIT2 6
# define CURLY 8
# define LEXYACC 10
# define ASM 12
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
		{ save_text(); cur_file->line_num++;
			    cur_declarator = NULL; }
break;
case 2:
		{ save_text(); get_comment(); }
break;
case 3:
		save_text();
break;
case 4:
	{ save_text(); if (++ly_count >= 2) BEGIN INITIAL; }
break;
case 5:
	{ save_text(); BEGIN INITIAL; }
break;
case 6:
{ save_text(); update_line_num(); }
break;
case 7:
	save_text();
break;
case 8:
	{ save_text(); BEGIN LEXYACC; }
break;
case 9:
	{ save_text(); BEGIN CPP1; }
break;
case 10:
	{ save_text(); BEGIN CPP1; }
break;
case 11:
{
			    save_text();
			    sscanf(yytext, "define %s", buf);
			    get_cpp_directive();
			    new_symbol(typedef_names, buf, DS_EXTERN);
			}
break;
case 12:
    {
			    save_text();
			    sscanf(yytext, "include \"%[^\"]\"", buf);
			    get_cpp_directive();
			    do_include(buf, FALSE);
			}
break;
case 13:
{
			    save_text();
			    sscanf(yytext, "include <%[^>]>", buf);
			    get_cpp_directive();
			    do_include(buf, TRUE);
			}
break;
case 14:
 {
			    save_text();
			    sscanf(yytext, "line %d \"%[^\"]\"",
			     &cur_file->line_num, cur_file->file_name);
			    cur_file->line_num--;
			    BEGIN INITIAL;
			}
break;
case 15:
 {
			    save_text();
			    sscanf(yytext, "%d \"%[^\"]\"", &cur_file->line_num,
			     cur_file->file_name);
			    cur_file->line_num--;
			    BEGIN INITIAL;
			}
break;
case 16:
	{
			    save_text();
			    sscanf(yytext, "%d ", &cur_file->line_num);
			    cur_file->line_num--;
			    BEGIN INITIAL;
			}
break;
case 17:
		{ save_text(); get_cpp_directive(); }
break;
case 18:
	{ save_text_offset(); return '('; }
break;
case 19:
	{
			    save_text();
			    if (cur_file->convert)
				cur_file->begin_comment =
				 ftell(cur_file->tmp_file);
			    return ')';
			}
break;
case 20:
	{ save_text_offset(); return '*'; }
break;
case 21:
	{ save_text(); return ','; }
break;
case 22:
	{
			    save_text();
			    if (cur_file->convert)
				cur_file->begin_comment =
				 ftell(cur_file->tmp_file);
			    return ';';
			}
break;
case 23:
	{ save_text(); return T_ELLIPSIS; }
break;
case 24:
{
			    save_text();
			    update_line_num();
			    return T_STRING_LITERAL;
			}
break;
case 25:
	{ save_text(); BEGIN ASM; return T_ASM; }
break;
case 26:
	save_text();
break;
case 27:
	{ save_text(); BEGIN INITIAL; return T_ASMARG; }
break;
case 28:
		{ save_text(); update_line_num(); }
break;
case 29:
			save_text();
break;
case 30:
{ save_text_offset(); return T_TYPE_QUALIFIER; }
break;
case 31:
	{ save_text_offset(); return T_AUTO; }
break;
case 32:
	{ save_text_offset(); return T_EXTERN; }
break;
case 33:
{ save_text_offset(); return T_REGISTER; }
break;
case 34:
	{ save_text_offset(); return T_STATIC; }
break;
case 35:
{ save_text_offset(); return T_TYPEDEF; }
break;
case 36:
	{ save_text_offset(); return T_INLINE; }
break;
case 37:
	{ save_text_offset(); return T_CHAR; }
break;
case 38:
	{ save_text_offset(); return T_DOUBLE; }
break;
case 39:
	{ save_text_offset(); return T_FLOAT; }
break;
case 40:
	{ save_text_offset(); return T_INT; }
break;
case 41:
	{ save_text_offset(); return T_VOID; }
break;
case 42:
	{ save_text_offset(); return T_LONG; }
break;
case 43:
	{ save_text_offset(); return T_SHORT; }
break;
case 44:
	{ save_text_offset(); return T_SIGNED; }
break;
case 45:
{ save_text_offset(); return T_UNSIGNED; }
break;
case 46:
	{ save_text_offset(); return T_ENUM; }
break;
case 47:
	{ save_text_offset(); return T_STRUCT; }
break;
case 48:
	{ save_text_offset(); return T_UNION; }
break;
case 49:
	{ save_text_offset(); return T_VA_DCL; }
break;
case 50:
	{
			    save_text_offset();
			    if (find_symbol(type_qualifiers, yytext) != NULL)
				return T_TYPE_QUALIFIER;
			    else if (find_symbol(typedef_names, yytext) != NULL)
				return T_TYPEDEF_NAME;
			    else
				return T_IDENTIFIER;
			}
break;
case 51:
{
			    /* This can't handle the case where a comment
			     * containing a ] appears between the brackets.
			     */
			    save_text_offset();
			    update_line_num();
			    return T_BRACKETS;
			}
break;
case 52:
{
			    save_text_offset();
			    update_line_num();
			    return T_BRACKETS;
			}
break;
case 53:
	{ save_text(); BEGIN INIT1; return '='; }
break;
case 54:
	{ save_text(); curly = 1; BEGIN INIT2; }
break;
case 55:
	{
			    unput(yytext[yyleng-1]);
			    BEGIN INITIAL;
			    return T_INITIALIZER;
			}
break;
case 56:
	{ save_text(); update_line_num(); }
break;
case 57:
	save_text();
break;
case 58:
	{ save_text(); ++curly; }
break;
case 59:
	{
			    save_text();
			    if (--curly == 0) {
				BEGIN INITIAL;
				return T_INITIALIZER;
			    }
			}
break;
case 60:
	{ save_text(); update_line_num(); }
break;
case 61:
	save_text();
break;
case 62:
	{
			    save_text();
			    curly = 1;
			    BEGIN CURLY;
			    return T_LBRACE;
			}
break;
case 63:
	{ save_text(); ++curly; }
break;
case 64:
	{
			    save_text();
			    if (--curly == 0) {
				BEGIN INITIAL;
				return T_MATCHRBRACE;
			    }
			}
break;
case 65:
	{ save_text(); update_line_num(); }
break;
case 66:
	save_text();
break;
case 67:
	save_text();
break;
case 68:
		{
			    save_text();
			    put_error();
			    fprintf(stderr, "bad character '%c'\n", yytext[0]);
			}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* If the matched text contains any new line characters, then update the
 * current line number.
 */
static void
update_line_num ()
{
    char *p = yytext;
    while (*p != '\0') {
	if (*p++ == '\n')
	    cur_file->line_num++;
    }
}

/* Save the matched text in the temporary file.
 */
static void
save_text ()
{
    if (cur_file->convert) {
	fputs(yytext, cur_file->tmp_file);
    }
}

/* Record the current position in the temporary file and write the matched text
 * to the file.
 */
static void
save_text_offset ()
{
    strcpy(yylval.text.text, yytext);
    if (cur_file->convert) {
	yylval.text.begin = ftell(cur_file->tmp_file);
	fputs(yytext, cur_file->tmp_file);
    }
}

/* Scan to end of comment.
 */
static void
get_comment ()
{
    int c, lastc = '\0';

    while ((c = input()) != 0) {
	if (cur_file->convert)
	    fputc(c, cur_file->tmp_file);
	switch (c) {
	case '\n':
	    cur_file->line_num++;
	    break;
	case '/':
	    if (lastc == '*') {
		if (cur_file->convert) {
		    if (func_params && cur_declarator) {
			cur_declarator->begin_comment = cur_file->begin_comment;
			cur_file->begin_comment = ftell(cur_file->tmp_file);
			cur_declarator->end_comment = cur_file->begin_comment;
			cur_declarator = NULL;
		    } else {
			cur_file->end_comment = ftell(cur_file->tmp_file);
		    }
		}
		return;
	    }
	    break;
	}
	lastc = c;
    }
}

/* Scan rest of preprocessor directive.
 */
static void
get_cpp_directive ()
{
    static char cont_trigraph[] = { '?', '?', '/', '\0' };
    char c, lastc[4];
    
    lastc[0] = lastc[1] = lastc[2] = lastc[3] = '\0';

    while ((c = input()) != 0) {
	if (cur_file->convert)
	    fputc(c, cur_file->tmp_file);
	switch (c) {
	case '\n':
	    cur_file->line_num++;
	    if (lastc[2] != '\\' && strcmp(lastc, cont_trigraph) != 0) {
		BEGIN INITIAL;
		return;
	    }
	    break;
	case '*':
	    if (lastc[2] == '/')
		get_comment();
	    break;
	}
	lastc[0] = lastc[1];
	lastc[1] = lastc[2];
	lastc[2] = c;
    }
}

/* Return a pointer to the current file name.
 */
char *
cur_file_name ()
{
    return cur_file->file_name;
}

/* Return the current line number.
 */
unsigned
cur_line_num ()
{
    return cur_file->line_num;
}

/* Return the current temporary output file.
 */
FILE *
cur_tmp_file ()
{
    return cur_file->tmp_file;
}

/* Set the modify flag for the current file.
 */
void
cur_file_changed ()
{
    cur_file->changed = TRUE;
}

/* Return the temporary file offset of beginning of the current comment.
 */
long
cur_begin_comment ()
{
    return cur_file->begin_comment;
}

/* Return the text of the current lexical token.
 */
char *
cur_text ()
{
    return yytext;
}

#ifdef NEED_tmpfile
/*
 * tmpfile() - return a FILE* for a temporary file that will be
 * removed automatically when the program exits.
 * 
 * Not all systems have the ANSI tmpfile() function yet...
 *
 * DaviD W. Sanderson (dws@cs.wisc.edu)
 */
FILE *
tmpfile ()
{
    char name[MAX_TEXT_SIZE];
    char *tmpdir;
    FILE *f;

    if ((tmpdir = getenv("TMPDIR")) == (char *)0)
    {
	tmpdir = "/tmp";
    }
    sprintf(name, "%s/TfXXXXXX", tmpdir);
    mktemp(name);

    if ((f = fopen(name, "w+")) == (FILE *)0)
    {
	return (FILE *)0;
    }

    if (unlink(name) == -1)
    {
	fclose(f);
	return (FILE *)0;
    }

    return f;
}
#endif /* NEED_tmpfile */

/* Push a file onto the include stack.	The stream yyin must already
 * point to the file.
 */
static void
include_file (name, convert)
char *name;		/* file name */
boolean convert;	/* if TRUE, convert function definitions */
{
    ++inc_depth;
    cur_file = inc_stack + inc_depth;
    cur_file->file = yyin;
    cur_file->base_name = xstrdup(name);
    cur_file->file_name = strcpy(xmalloc(MAX_TEXT_SIZE), name);
    cur_file->line_num = 1;
    cur_file->convert = convert;
    cur_file->changed = FALSE;

#ifdef FLEX_SCANNER
    buffer_stack[inc_depth] = yy_create_buffer(yyin, YY_BUF_SIZE);
    yy_switch_to_buffer(buffer_stack[inc_depth]);
#endif

    if (convert) {
	cur_file->begin_comment = cur_file->end_comment = 0;
	cur_file->tmp_file = tmpfile();
	if (cur_file->tmp_file == NULL) {
	    fprintf(stderr, "%s: cannot create temporary file\n", progname);
	    cur_file->convert = FALSE;
	}
    }
}

#define BLOCK_SIZE 2048

/* Copy converted C source from the temporary file to the output stream.
 */
static void
put_file (outf)
FILE *outf;
{
    char block[BLOCK_SIZE];
    long filesize;
    unsigned nread, count;

    filesize = ftell(cur_file->tmp_file);
    fseek(cur_file->tmp_file, 0L, 0);
    while (filesize > 0) {
	count = (filesize < BLOCK_SIZE) ? (unsigned)filesize : BLOCK_SIZE;
	nread = fread(block, sizeof(char), count, cur_file->tmp_file);
	if (nread == 0)
	    break;
	fwrite(block, sizeof(char), nread, outf);
	filesize -= nread;
    }
}

/* Remove the top of the include stack.
 */
void
pop_file ()
{
    FILE *outf;

    if (yyin != stdin)
	fclose(yyin);

    if (cur_file->convert) {
	if (yyin == stdin) {
	    put_file(stdout);
	} else if (cur_file->changed) {
	    if ((outf = fopen(cur_file->base_name, "w")) != NULL) {
		put_file(outf);
		fclose(outf);
	    } else {
		fprintf(stderr, "%s: cannot create file %s\n", progname,
		 cur_file->base_name);
	    }
	}

	fclose(cur_file->tmp_file);
    }
    free(cur_file->base_name);
    free(cur_file->file_name);

#ifdef FLEX_SCANNER
    yy_delete_buffer(YY_CURRENT_BUFFER);
#endif

    if (--inc_depth >= 0) {
	cur_file = inc_stack + inc_depth;
	yyin = cur_file->file;

#ifdef FLEX_SCANNER
	yy_switch_to_buffer(buffer_stack[inc_depth]);
#endif
    }
}

/* Process include directive.
 */
static void
do_include (filename, stdinc)
char *filename; 	/* file to include */
boolean stdinc; 	/* TRUE if file name specified with angle brackets */
{
    char path[MAX_TEXT_SIZE];
    int i;
    FILE *fp;

    if (inc_depth >= MAX_INC_DEPTH-1) {
	put_error();
	fprintf(stderr, "includes too deeply nested\n");
	return;
    }

    sprintf(path, stdinc ? "<%s>" : "\"%s\"", filename);
    if (find_symbol(included_files, path) != NULL)
	return;
    new_symbol(included_files, path, 0);

    for (i = stdinc != 0; i < num_inc_dir; ++i) {
	if (strlen(inc_dir[i]) == 0) {
	    strcpy(path, filename);
	} else {
	    sprintf(path, "%s/%s", inc_dir[i], filename);
	}
	if ((fp = fopen(path, "r")) != NULL) {
	    yyin = fp;
	    include_file(path, func_style != FUNC_NONE && !stdinc);
	    return;
	}
    }

    if (!quiet) {
	put_error();
	fprintf(stderr, "cannot read file %s\n", filename);
    }
}

/* When the end of the current input file is reached, pop a
 * nested include file.
 */
int
yywrap ()
{
    if (inc_depth > 0) {
	pop_file();
	return 0;
    } else {
	return 1;
    }
}
int yyvstop[] = {
0,

68,
0,

67,
68,
0,

1,
0,

68,
0,

9,
68,
0,

18,
68,
0,

19,
68,
0,

20,
68,
0,

21,
68,
0,

68,
0,

68,
0,

22,
68,
0,

53,
68,
0,

68,
0,

50,
68,
0,

68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

50,
68,
0,

62,
68,
0,

68,
0,

17,
68,
0,

17,
67,
68,
0,

17,
68,
0,

17,
68,
-16,
0,

17,
68,
0,

17,
68,
0,

17,
68,
0,

57,
68,
0,

57,
67,
68,
0,

57,
68,
0,

57,
68,
0,

55,
57,
68,
0,

57,
68,
0,

57,
68,
0,

54,
57,
68,
0,

61,
68,
0,

61,
67,
68,
0,

61,
68,
0,

61,
68,
0,

61,
68,
0,

61,
68,
0,

58,
61,
68,
0,

59,
61,
68,
0,

66,
68,
0,

66,
67,
68,
0,

66,
68,
0,

66,
68,
0,

66,
68,
0,

66,
68,
0,

63,
66,
68,
0,

64,
66,
68,
0,

7,
68,
0,

7,
67,
68,
0,

7,
68,
0,

7,
68,
0,

7,
68,
0,

7,
68,
0,

7,
68,
0,

29,
68,
0,

29,
67,
68,
0,

29,
68,
0,

29,
68,
0,

26,
29,
68,
0,

27,
29,
68,
0,

29,
68,
0,

29,
68,
0,

67,
0,

24,
0,

9,
0,

2,
0,

-3,
0,

50,
0,

51,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

8,
0,

-16,
0,

-16,
0,

16,
0,

-16,
0,

56,
0,

60,
0,

65,
0,

6,
0,

4,
0,

5,
0,

28,
0,

24,
0,

23,
0,

3,
0,

10,
0,

50,
0,

25,
50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

40,
50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

-15,
-16,
0,

56,
0,

56,
0,

60,
0,

60,
0,

65,
0,

65,
0,

6,
0,

6,
0,

28,
0,

28,
0,

50,
0,

31,
50,
0,

37,
50,
0,

50,
0,

46,
50,
0,

50,
0,

50,
0,

50,
0,

42,
50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

41,
50,
0,

15,
16,
0,

50,
0,

50,
0,

50,
0,

39,
50,
0,

50,
0,

50,
0,

43,
50,
0,

50,
0,

50,
0,

50,
0,

50,
0,

48,
50,
0,

50,
0,

50,
0,

52,
0,

50,
0,

38,
50,
0,

32,
50,
0,

36,
50,
0,

50,
0,

44,
50,
0,

34,
50,
0,

47,
50,
0,

50,
0,

50,
0,

49,
50,
0,

50,
0,

35,
50,
0,

50,
0,

30,
0,

33,
50,
0,

45,
50,
0,

11,
0,

-14,
0,

14,
0,

12,
0,

13,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,15,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,16,	1,17,	
0,0,	1,16,	0,0,	16,92,	
19,96,	0,0,	16,92,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,18,	
1,19,	0,0,	16,92,	19,96,	
1,15,	1,20,	1,21,	1,22,	
12,83,	1,23,	0,0,	1,24,	
1,25,	1,15,	25,98,	0,0,	
24,97,	0,0,	12,81,	25,99,	
0,0,	0,0,	0,0,	0,0,	
1,26,	0,0,	1,27,	1,15,	
1,28,	2,19,	1,29,	2,45,	
0,0,	28,100,	0,0,	0,0,	
2,22,	0,0,	0,0,	6,58,	
2,24,	2,25,	8,65,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	83,151,	0,0,	
0,0,	2,26,	0,0,	2,27,	
1,30,	0,0,	1,15,	0,0,	
1,31,	4,48,	1,32,	12,82,	
1,33,	1,34,	1,35,	1,36,	
31,104,	97,159,	1,37,	31,105,	
0,0,	1,38,	33,108,	0,0,	
0,0,	0,0,	0,0,	1,39,	
1,40,	1,41,	1,42,	1,43,	
6,59,	2,30,	34,109,	8,66,	
1,44,	2,31,	36,112,	2,32,	
3,46,	2,33,	2,34,	2,35,	
2,36,	35,110,	37,113,	2,37,	
3,47,	3,17,	2,38,	3,47,	
32,106,	38,114,	32,107,	35,111,	
2,39,	2,40,	2,41,	2,42,	
2,43,	39,115,	4,50,	6,60,	
41,119,	2,44,	8,67,	4,51,	
8,68,	42,120,	4,52,	43,121,	
45,123,	3,46,	50,128,	51,129,	
40,116,	40,117,	3,46,	3,46,	
3,46,	5,53,	52,130,	3,46,	
83,152,	43,122,	3,48,	3,49,	
40,118,	5,54,	5,17,	93,95,	
5,54,	95,158,	100,161,	104,105,	
105,163,	106,164,	107,165,	108,166,	
109,167,	3,46,	3,46,	110,168,	
3,46,	111,169,	112,170,	114,173,	
113,171,	115,174,	116,175,	117,176,	
118,177,	119,179,	5,55,	100,162,	
113,172,	121,182,	122,183,	5,56,	
5,53,	5,53,	7,61,	125,184,	
5,57,	120,180,	128,185,	5,58,	
5,53,	118,178,	7,62,	7,17,	
3,46,	7,62,	129,186,	120,181,	
124,124,	125,124,	130,187,	3,50,	
131,133,	136,138,	5,53,	5,53,	
3,51,	5,53,	133,188,	3,52,	
134,0,	135,0,	138,190,	95,95,	
139,0,	140,0,	141,143,	7,63,	
144,0,	143,192,	146,148,	9,69,	
7,64,	7,61,	7,61,	149,0,	
153,155,	7,61,	145,0,	9,70,	
7,65,	7,61,	9,70,	148,194,	
5,59,	5,53,	155,196,	124,124,	
158,95,	156,0,	135,189,	10,69,	
150,0,	157,0,	140,191,	7,61,	
7,61,	163,199,	7,61,	10,70,	
162,162,	165,200,	10,70,	166,201,	
9,71,	167,202,	168,203,	145,193,	
169,204,	9,72,	9,69,	9,69,	
170,205,	171,206,	9,69,	5,60,	
133,133,	9,73,	9,69,	173,207,	
138,138,	150,195,	157,197,	162,162,	
10,71,	7,66,	7,61,	143,143,	
174,208,	10,72,	10,69,	10,69,	
9,69,	9,69,	10,69,	9,69,	
175,209,	10,73,	10,69,	176,210,	
177,211,	148,148,	134,135,	135,135,	
155,155,	178,212,	139,140,	140,140,	
179,213,	180,214,	144,145,	181,215,	
10,69,	10,69,	182,216,	10,69,	
7,67,	149,150,	7,68,	11,77,	
145,145,	183,217,	9,74,	9,69,	
185,219,	186,220,	187,221,	11,78,	
11,17,	188,133,	11,78,	156,157,	
190,138,	192,143,	150,150,	157,157,	
189,0,	194,148,	191,0,	13,84,	
196,155,	198,222,	10,74,	10,69,	
193,0,	195,0,	197,0,	13,85,	
199,223,	202,224,	13,85,	204,225,	
11,79,	9,75,	205,226,	9,76,	
206,227,	11,80,	11,77,	11,77,	
208,228,	209,229,	11,77,	210,230,	
211,231,	11,81,	11,77,	212,232,	
213,233,	214,234,	215,235,	216,236,	
13,86,	10,75,	219,237,	10,76,	
14,84,	13,87,	13,88,	13,89,	
11,77,	11,77,	13,84,	11,77,	
14,85,	13,90,	13,84,	14,85,	
220,238,	221,239,	222,240,	223,241,	
224,242,	225,243,	227,244,	228,245,	
18,93,	230,246,	231,247,	232,248,	
13,84,	13,84,	233,249,	13,84,	
18,93,	18,93,	235,250,	18,93,	
236,251,	14,86,	11,82,	11,77,	
221,239,	237,252,	14,87,	14,88,	
14,89,	238,253,	189,135,	14,84,	
191,140,	245,257,	14,90,	14,84,	
249,258,	250,259,	193,145,	195,150,	
197,157,	18,94,	13,91,	13,84,	
252,260,	253,261,	18,93,	18,93,	
18,93,	14,84,	14,84,	18,93,	
14,84,	254,262,	255,255,	18,93,	
257,264,	259,265,	262,262,	270,273,	
271,274,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	252,260,	
0,0,	18,93,	18,93,	255,255,	
18,93,	0,0,	0,0,	0,0,	
254,262,	0,0,	0,0,	14,91,	
14,84,	262,262,	0,0,	262,269,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	0,0,	0,0,	
0,0,	0,0,	0,0,	18,95,	
18,93,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	0,0,	
0,0,	0,0,	0,0,	29,101,	
0,0,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	29,101,	
29,101,	29,101,	29,101,	30,102,	
0,0,	261,261,	0,0,	0,0,	
0,0,	0,0,	0,0,	30,102,	
30,102,	0,0,	30,102,	49,124,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	49,125,	
49,126,	0,0,	49,124,	0,0,	
261,261,	0,0,	261,267,	0,0,	
0,0,	0,0,	0,0,	0,0,	
30,102,	0,0,	0,0,	0,0,	
0,0,	30,102,	30,102,	30,102,	
0,0,	0,0,	30,102,	0,0,	
49,124,	0,0,	30,102,	0,0,	
0,0,	49,124,	49,124,	49,124,	
261,268,	0,0,	49,124,	0,0,	
0,0,	55,131,	49,127,	0,0,	
30,102,	30,102,	0,0,	30,102,	
0,0,	55,131,	55,131,	0,0,	
55,131,	56,134,	0,0,	0,0,	
49,124,	49,124,	0,0,	49,124,	
0,0,	56,134,	56,0,	0,0,	
56,134,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,132,	30,103,	
0,0,	0,0,	0,0,	55,131,	
55,131,	55,131,	0,0,	0,0,	
55,131,	0,0,	56,134,	49,124,	
55,131,	0,0,	0,0,	56,132,	
56,134,	56,134,	0,0,	0,0,	
56,134,	0,0,	0,0,	0,0,	
56,134,	0,0,	55,131,	55,131,	
0,0,	55,131,	0,0,	0,0,	
0,0,	0,0,	59,132,	0,0,	
0,0,	0,0,	56,134,	56,134,	
0,0,	56,134,	59,132,	59,0,	
0,0,	59,132,	0,0,	0,0,	
0,0,	0,0,	63,136,	0,0,	
0,0,	0,0,	0,0,	0,0,	
55,133,	55,131,	63,136,	63,136,	
0,0,	63,136,	0,0,	0,0,	
0,0,	0,0,	0,0,	59,132,	
56,135,	56,134,	0,0,	0,0,	
59,132,	59,132,	59,132,	0,0,	
0,0,	59,132,	0,0,	0,0,	
0,0,	59,132,	0,0,	63,137,	
0,0,	0,0,	0,0,	0,0,	
63,136,	63,136,	63,136,	64,139,	
0,0,	63,136,	0,0,	59,132,	
59,132,	63,136,	59,132,	64,139,	
64,0,	0,0,	64,139,	0,0,	
0,0,	0,0,	0,0,	66,137,	
0,0,	0,0,	0,0,	63,136,	
63,136,	0,0,	63,136,	66,137,	
66,0,	0,0,	66,137,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,139,	0,0,	59,132,	0,0,	
0,0,	64,137,	64,139,	64,139,	
0,0,	0,0,	64,139,	0,0,	
0,0,	0,0,	64,139,	0,0,	
66,137,	63,138,	63,136,	0,0,	
0,0,	66,137,	66,137,	66,137,	
71,141,	0,0,	66,137,	0,0,	
64,139,	64,139,	66,137,	64,139,	
71,141,	71,141,	0,0,	71,141,	
0,0,	0,0,	0,0,	0,0,	
72,144,	0,0,	0,0,	0,0,	
66,137,	66,137,	0,0,	66,137,	
72,144,	72,0,	0,0,	72,144,	
0,0,	0,0,	0,0,	0,0,	
0,0,	71,142,	64,140,	64,139,	
0,0,	0,0,	71,141,	71,141,	
71,141,	0,0,	0,0,	71,141,	
0,0,	0,0,	0,0,	71,141,	
0,0,	72,144,	0,0,	66,137,	
0,0,	0,0,	72,142,	72,144,	
72,144,	74,142,	0,0,	72,144,	
0,0,	71,141,	71,141,	72,144,	
71,141,	74,142,	74,0,	0,0,	
74,142,	0,0,	0,0,	0,0,	
0,0,	79,146,	0,0,	0,0,	
0,0,	72,144,	72,144,	0,0,	
72,144,	79,146,	79,146,	0,0,	
79,146,	0,0,	0,0,	0,0,	
0,0,	0,0,	74,142,	71,143,	
71,141,	0,0,	0,0,	74,142,	
74,142,	74,142,	0,0,	0,0,	
74,142,	0,0,	0,0,	0,0,	
74,142,	0,0,	79,147,	72,145,	
72,144,	0,0,	0,0,	79,146,	
79,146,	79,146,	80,149,	0,0,	
79,146,	0,0,	74,142,	74,142,	
79,146,	74,142,	80,149,	80,0,	
0,0,	80,149,	0,0,	0,0,	
0,0,	0,0,	82,147,	0,0,	
0,0,	0,0,	79,146,	79,146,	
0,0,	79,146,	82,147,	82,0,	
0,0,	82,147,	0,0,	0,0,	
0,0,	0,0,	0,0,	80,149,	
0,0,	74,142,	0,0,	0,0,	
80,147,	80,149,	80,149,	0,0,	
0,0,	80,149,	0,0,	0,0,	
0,0,	80,149,	0,0,	82,147,	
79,148,	79,146,	0,0,	0,0,	
82,147,	82,147,	82,147,	86,153,	
0,0,	82,147,	0,0,	80,149,	
80,149,	82,147,	80,149,	86,153,	
86,153,	0,0,	86,153,	0,0,	
0,0,	0,0,	0,0,	87,156,	
0,0,	0,0,	0,0,	82,147,	
82,147,	0,0,	82,147,	87,156,	
87,0,	0,0,	87,156,	0,0,	
0,0,	0,0,	0,0,	0,0,	
86,154,	80,150,	80,149,	0,0,	
0,0,	86,153,	86,153,	86,153,	
0,0,	0,0,	86,153,	0,0,	
0,0,	0,0,	86,153,	0,0,	
87,156,	0,0,	82,147,	0,0,	
0,0,	87,154,	87,156,	87,156,	
91,154,	0,0,	87,156,	0,0,	
86,153,	86,153,	87,156,	86,153,	
91,154,	91,0,	0,0,	91,154,	
0,0,	0,0,	0,0,	0,0,	
99,99,	0,0,	0,0,	0,0,	
87,156,	87,156,	0,0,	87,156,	
99,99,	99,160,	0,0,	99,99,	
0,0,	0,0,	0,0,	0,0,	
0,0,	91,154,	86,155,	86,153,	
0,0,	0,0,	91,154,	91,154,	
91,154,	0,0,	0,0,	91,154,	
0,0,	0,0,	0,0,	91,154,	
0,0,	99,99,	87,157,	87,156,	
0,0,	0,0,	99,99,	99,99,	
99,99,	161,161,	0,0,	99,99,	
0,0,	91,154,	91,154,	99,99,	
91,154,	161,161,	161,161,	0,0,	
161,161,	0,0,	0,0,	0,0,	
0,0,	184,184,	0,0,	0,0,	
0,0,	99,99,	99,99,	0,0,	
99,99,	184,184,	184,218,	0,0,	
184,184,	0,0,	0,0,	0,0,	
0,0,	0,0,	161,161,	0,0,	
91,154,	0,0,	0,0,	161,161,	
161,161,	161,161,	0,0,	239,239,	
161,161,	0,0,	0,0,	0,0,	
161,161,	0,0,	184,184,	0,0,	
99,99,	0,0,	0,0,	184,184,	
184,184,	184,184,	0,0,	241,255,	
184,184,	0,0,	161,161,	161,198,	
184,184,	161,161,	239,239,	241,255,	
241,255,	0,0,	241,255,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	184,184,	184,184,	
0,0,	184,184,	239,254,	239,254,	
239,254,	239,254,	239,254,	239,254,	
239,254,	239,254,	239,254,	239,254,	
241,255,	161,161,	0,0,	0,0,	
256,256,	241,255,	241,256,	241,255,	
0,0,	0,0,	241,255,	0,0,	
256,256,	256,256,	241,241,	256,256,	
0,0,	184,184,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
241,255,	241,255,	0,0,	241,241,	
0,0,	0,0,	0,0,	0,0,	
0,0,	256,256,	0,0,	0,0,	
0,0,	260,260,	256,256,	0,0,	
256,263,	0,0,	0,0,	256,256,	
0,0,	0,0,	0,0,	256,256,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	241,255,	
0,0,	0,0,	0,0,	0,0,	
260,260,	256,256,	256,256,	0,0,	
256,256,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
256,256,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	0,0,	
0,0,	0,0,	0,0,	260,266,	
0,0,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	260,266,	
260,266,	260,266,	260,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	0,0,	0,0,	
0,0,	0,0,	266,266,	0,0,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	266,266,	266,266,	
266,266,	266,266,	267,270,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	267,270,	267,270,	
0,0,	267,270,	268,271,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	268,271,	268,271,	
0,0,	268,271,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	267,0,	
0,0,	0,0,	0,0,	0,0,	
267,270,	267,270,	267,270,	0,0,	
0,0,	267,270,	0,0,	268,271,	
0,0,	267,270,	0,0,	0,0,	
268,271,	268,271,	268,271,	0,0,	
0,0,	268,271,	0,0,	0,0,	
269,269,	268,271,	0,0,	267,270,	
267,270,	0,0,	267,270,	0,0,	
269,269,	269,272,	0,0,	269,269,	
0,0,	0,0,	0,0,	268,0,	
268,271,	0,0,	268,271,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	269,269,	267,270,	0,0,	
0,0,	0,0,	269,269,	269,269,	
269,269,	0,0,	0,0,	269,269,	
0,0,	0,0,	268,271,	269,269,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	269,269,	269,269,	0,0,	
269,269,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
269,269,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-30,	yysvec+1,	0,	
yycrank+-127,	0,		0,	
yycrank+-50,	yysvec+3,	0,	
yycrank+-168,	0,		0,	
yycrank+-28,	yysvec+5,	0,	
yycrank+-209,	0,		0,	
yycrank+-31,	yysvec+7,	0,	
yycrank+-246,	yysvec+7,	0,	
yycrank+-266,	yysvec+7,	0,	
yycrank+-334,	0,		0,	
yycrank+-7,	yysvec+11,	0,	
yycrank+-354,	yysvec+11,	0,	
yycrank+-391,	yysvec+11,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+6,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+-411,	0,		yyvstop+8,
yycrank+7,	0,		yyvstop+10,
yycrank+0,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+16,
yycrank+0,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+22,
yycrank+6,	0,		yyvstop+25,
yycrank+8,	0,		yyvstop+27,
yycrank+0,	0,		yyvstop+29,
yycrank+0,	0,		yyvstop+32,
yycrank+6,	0,		yyvstop+35,
yycrank+440,	0,		yyvstop+37,
yycrank+-562,	0,		yyvstop+40,
yycrank+9,	yysvec+29,	yyvstop+42,
yycrank+25,	yysvec+29,	yyvstop+45,
yycrank+6,	yysvec+29,	yyvstop+48,
yycrank+11,	yysvec+29,	yyvstop+51,
yycrank+23,	yysvec+29,	yyvstop+54,
yycrank+18,	yysvec+29,	yyvstop+57,
yycrank+24,	yysvec+29,	yyvstop+60,
yycrank+30,	yysvec+29,	yyvstop+63,
yycrank+48,	yysvec+29,	yyvstop+66,
yycrank+60,	yysvec+29,	yyvstop+69,
yycrank+31,	yysvec+29,	yyvstop+72,
yycrank+47,	yysvec+29,	yyvstop+75,
yycrank+62,	yysvec+29,	yyvstop+78,
yycrank+0,	0,		yyvstop+81,
yycrank+35,	0,		yyvstop+84,
yycrank+0,	0,		yyvstop+86,
yycrank+0,	yysvec+16,	yyvstop+89,
yycrank+0,	yysvec+25,	yyvstop+93,
yycrank+-574,	0,		yyvstop+96,
yycrank+61,	0,		yyvstop+100,
yycrank+53,	0,		yyvstop+103,
yycrank+65,	0,		yyvstop+106,
yycrank+0,	0,		yyvstop+109,
yycrank+0,	yysvec+16,	yyvstop+112,
yycrank+-620,	0,		yyvstop+116,
yycrank+-632,	0,		yyvstop+119,
yycrank+0,	0,		yyvstop+122,
yycrank+0,	yysvec+25,	yyvstop+126,
yycrank+-689,	0,		yyvstop+129,
yycrank+0,	0,		yyvstop+132,
yycrank+0,	0,		yyvstop+136,
yycrank+0,	yysvec+16,	yyvstop+139,
yycrank+-705,	0,		yyvstop+143,
yycrank+-746,	0,		yyvstop+146,
yycrank+0,	yysvec+25,	yyvstop+149,
yycrank+-762,	0,		yyvstop+152,
yycrank+0,	0,		yyvstop+155,
yycrank+0,	0,		yyvstop+159,
yycrank+0,	0,		yyvstop+163,
yycrank+0,	yysvec+16,	yyvstop+166,
yycrank+-803,	0,		yyvstop+170,
yycrank+-819,	0,		yyvstop+173,
yycrank+0,	yysvec+25,	yyvstop+176,
yycrank+-860,	0,		yyvstop+179,
yycrank+0,	0,		yyvstop+182,
yycrank+0,	0,		yyvstop+186,
yycrank+0,	0,		yyvstop+190,
yycrank+0,	yysvec+16,	yyvstop+193,
yycrank+-876,	0,		yyvstop+197,
yycrank+-917,	0,		yyvstop+200,
yycrank+0,	yysvec+25,	yyvstop+203,
yycrank+-933,	0,		yyvstop+206,
yycrank+49,	0,		yyvstop+209,
yycrank+0,	0,		yyvstop+212,
yycrank+0,	yysvec+16,	yyvstop+215,
yycrank+-974,	0,		yyvstop+219,
yycrank+-990,	0,		yyvstop+222,
yycrank+0,	0,		yyvstop+225,
yycrank+0,	0,		yyvstop+229,
yycrank+0,	yysvec+25,	yyvstop+233,
yycrank+-1031,	0,		yyvstop+236,
yycrank+0,	yysvec+16,	yyvstop+239,
yycrank+-87,	yysvec+18,	0,	
yycrank+0,	0,		yyvstop+241,
yycrank+-147,	yysvec+18,	0,	
yycrank+0,	yysvec+19,	yyvstop+243,
yycrank+59,	0,		0,	
yycrank+0,	0,		yyvstop+245,
yycrank+-1047,	0,		yyvstop+247,
yycrank+142,	0,		0,	
yycrank+0,	yysvec+29,	yyvstop+249,
yycrank+0,	yysvec+30,	0,	
yycrank+0,	0,		yyvstop+251,
yycrank+85,	yysvec+29,	yyvstop+253,
yycrank+87,	yysvec+29,	yyvstop+255,
yycrank+76,	yysvec+29,	yyvstop+257,
yycrank+70,	yysvec+29,	yyvstop+259,
yycrank+90,	yysvec+29,	yyvstop+261,
yycrank+71,	yysvec+29,	yyvstop+263,
yycrank+74,	yysvec+29,	yyvstop+265,
yycrank+77,	yysvec+29,	yyvstop+267,
yycrank+83,	yysvec+29,	yyvstop+269,
yycrank+88,	yysvec+29,	yyvstop+271,
yycrank+85,	yysvec+29,	yyvstop+273,
yycrank+94,	yysvec+29,	yyvstop+275,
yycrank+87,	yysvec+29,	yyvstop+277,
yycrank+96,	yysvec+29,	yyvstop+279,
yycrank+103,	yysvec+29,	yyvstop+281,
yycrank+89,	yysvec+29,	yyvstop+283,
yycrank+108,	yysvec+29,	yyvstop+285,
yycrank+110,	yysvec+29,	yyvstop+287,
yycrank+101,	yysvec+29,	yyvstop+289,
yycrank+0,	0,		yyvstop+291,
yycrank+-215,	yysvec+49,	yyvstop+293,
yycrank+-177,	yysvec+49,	yyvstop+295,
yycrank+0,	0,		yyvstop+297,
yycrank+0,	yysvec+49,	yyvstop+299,
yycrank+112,	0,		0,	
yycrank+123,	0,		0,	
yycrank+116,	0,		0,	
yycrank+-136,	yysvec+55,	0,	
yycrank+0,	0,		yyvstop+301,
yycrank+-200,	yysvec+55,	0,	
yycrank+-226,	yysvec+56,	0,	
yycrank+-227,	yysvec+56,	0,	
yycrank+-137,	yysvec+63,	0,	
yycrank+0,	0,		yyvstop+303,
yycrank+-204,	yysvec+63,	0,	
yycrank+-230,	yysvec+64,	0,	
yycrank+-231,	yysvec+64,	0,	
yycrank+-150,	yysvec+71,	0,	
yycrank+0,	0,		yyvstop+305,
yycrank+-211,	yysvec+71,	0,	
yycrank+-234,	yysvec+72,	0,	
yycrank+-244,	yysvec+72,	0,	
yycrank+-154,	yysvec+79,	0,	
yycrank+0,	0,		yyvstop+307,
yycrank+-225,	yysvec+79,	0,	
yycrank+-241,	yysvec+80,	0,	
yycrank+-258,	yysvec+80,	0,	
yycrank+0,	0,		yyvstop+309,
yycrank+0,	0,		yyvstop+311,
yycrank+-160,	yysvec+86,	0,	
yycrank+0,	0,		yyvstop+313,
yycrank+-228,	yysvec+86,	0,	
yycrank+-255,	yysvec+87,	0,	
yycrank+-259,	yysvec+87,	0,	
yycrank+-172,	yysvec+18,	yyvstop+315,
yycrank+0,	0,		yyvstop+317,
yycrank+0,	0,		yyvstop+319,
yycrank+-1088,	0,		0,	
yycrank+267,	0,		yyvstop+321,
yycrank+158,	yysvec+29,	yyvstop+323,
yycrank+0,	yysvec+29,	yyvstop+325,
yycrank+166,	yysvec+29,	yyvstop+328,
yycrank+165,	yysvec+29,	yyvstop+330,
yycrank+183,	yysvec+29,	yyvstop+332,
yycrank+173,	yysvec+29,	yyvstop+334,
yycrank+183,	yysvec+29,	yyvstop+336,
yycrank+191,	yysvec+29,	yyvstop+338,
yycrank+184,	yysvec+29,	yyvstop+340,
yycrank+0,	yysvec+29,	yyvstop+342,
yycrank+192,	yysvec+29,	yyvstop+345,
yycrank+199,	yysvec+29,	yyvstop+347,
yycrank+198,	yysvec+29,	yyvstop+349,
yycrank+205,	yysvec+29,	yyvstop+351,
yycrank+200,	yysvec+29,	yyvstop+353,
yycrank+204,	yysvec+29,	yyvstop+355,
yycrank+223,	yysvec+29,	yyvstop+357,
yycrank+214,	yysvec+29,	yyvstop+359,
yycrank+222,	yysvec+29,	yyvstop+361,
yycrank+230,	yysvec+29,	yyvstop+363,
yycrank+237,	yysvec+29,	yyvstop+365,
yycrank+-1104,	0,		yyvstop+367,
yycrank+235,	0,		0,	
yycrank+233,	0,		0,	
yycrank+241,	0,		0,	
yycrank+-253,	yysvec+55,	yyvstop+370,
yycrank+-342,	yysvec+56,	yyvstop+372,
yycrank+-256,	yysvec+63,	yyvstop+374,
yycrank+-344,	yysvec+64,	yyvstop+376,
yycrank+-257,	yysvec+71,	yyvstop+378,
yycrank+-350,	yysvec+72,	yyvstop+380,
yycrank+-261,	yysvec+79,	yyvstop+382,
yycrank+-351,	yysvec+80,	yyvstop+384,
yycrank+-264,	yysvec+86,	yyvstop+386,
yycrank+-352,	yysvec+87,	yyvstop+388,
yycrank+294,	0,		0,	
yycrank+263,	yysvec+29,	yyvstop+390,
yycrank+0,	yysvec+29,	yyvstop+392,
yycrank+0,	yysvec+29,	yyvstop+395,
yycrank+257,	yysvec+29,	yyvstop+398,
yycrank+0,	yysvec+29,	yyvstop+400,
yycrank+253,	yysvec+29,	yyvstop+403,
yycrank+254,	yysvec+29,	yyvstop+405,
yycrank+262,	yysvec+29,	yyvstop+407,
yycrank+0,	yysvec+29,	yyvstop+409,
yycrank+261,	yysvec+29,	yyvstop+412,
yycrank+261,	yysvec+29,	yyvstop+414,
yycrank+278,	yysvec+29,	yyvstop+416,
yycrank+275,	yysvec+29,	yyvstop+418,
yycrank+284,	yysvec+29,	yyvstop+420,
yycrank+284,	yysvec+29,	yyvstop+422,
yycrank+275,	yysvec+29,	yyvstop+424,
yycrank+283,	yysvec+29,	yyvstop+426,
yycrank+288,	yysvec+29,	yyvstop+428,
yycrank+0,	yysvec+29,	yyvstop+430,
yycrank+0,	0,		yyvstop+433,
yycrank+280,	0,		0,	
yycrank+287,	0,		0,	
yycrank+396,	0,		0,	
yycrank+365,	0,		0,	
yycrank+307,	yysvec+29,	yyvstop+436,
yycrank+307,	yysvec+29,	yyvstop+438,
yycrank+299,	yysvec+29,	yyvstop+440,
yycrank+0,	yysvec+29,	yyvstop+442,
yycrank+309,	yysvec+29,	yyvstop+445,
yycrank+295,	yysvec+29,	yyvstop+447,
yycrank+0,	yysvec+29,	yyvstop+449,
yycrank+313,	yysvec+29,	yyvstop+452,
yycrank+315,	yysvec+29,	yyvstop+454,
yycrank+299,	yysvec+29,	yyvstop+456,
yycrank+317,	yysvec+29,	yyvstop+458,
yycrank+0,	yysvec+29,	yyvstop+460,
yycrank+312,	yysvec+29,	yyvstop+463,
yycrank+316,	yysvec+29,	yyvstop+465,
yycrank+328,	0,		0,	
yycrank+333,	0,		0,	
yycrank+1122,	0,		0,	
yycrank+0,	0,		yyvstop+467,
yycrank+-1146,	0,		yyvstop+469,
yycrank+0,	yysvec+29,	yyvstop+471,
yycrank+0,	yysvec+29,	yyvstop+474,
yycrank+0,	yysvec+29,	yyvstop+477,
yycrank+336,	yysvec+29,	yyvstop+480,
yycrank+0,	yysvec+29,	yyvstop+482,
yycrank+0,	yysvec+29,	yyvstop+485,
yycrank+0,	yysvec+29,	yyvstop+488,
yycrank+338,	yysvec+29,	yyvstop+491,
yycrank+340,	yysvec+29,	yyvstop+493,
yycrank+0,	yysvec+29,	yyvstop+495,
yycrank+439,	0,		0,	
yycrank+348,	0,		0,	
yycrank+448,	yysvec+239,	0,	
yycrank+-410,	yysvec+241,	0,	
yycrank+-1183,	yysvec+241,	0,	
yycrank+346,	yysvec+29,	yyvstop+498,
yycrank+0,	yysvec+29,	yyvstop+500,
yycrank+361,	yysvec+29,	yyvstop+503,
yycrank+1212,	0,		0,	
yycrank+556,	0,		0,	
yycrank+453,	0,		0,	
yycrank+0,	0,		yyvstop+505,
yycrank+0,	yysvec+29,	yyvstop+507,
yycrank+0,	yysvec+29,	yyvstop+510,
yycrank+1287,	0,		yyvstop+513,
yycrank+-1409,	0,		0,	
yycrank+-1421,	0,		0,	
yycrank+-1467,	0,		yyvstop+515,
yycrank+-429,	yysvec+267,	0,	
yycrank+-402,	yysvec+268,	0,	
yycrank+0,	0,		yyvstop+517,
yycrank+0,	0,		yyvstop+519,
yycrank+0,	0,		yyvstop+521,
0,	0,	0};
struct yywork *yytop = yycrank+1560;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,014 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,047 ,
'(' ,')' ,01  ,01  ,',' ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,',' ,01  ,01  ,'>' ,'?' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,']' ,01  ,'A' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,1,1,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
