
title FAST CRC for MSC
page 75,132

; written by:   Mike Dumdei
;               6 Holly Lane
;               Texarkana, TX  75503

comment |======================================================================

 int  calc_crc(char *, int);
    ARGS:
      Pointer to block to calculate CRC value on
      Number of bytes in block
    RETURNS:
      16 bit CRC for the block

 int  update_crc(int, char);
    ARGS:
      CRC value to be updated
      Byte of data to be added to the CRC
    RETURNS:
      Updated CRC

==============================================================================|

public  _calc_crc, _update_crc

irp     cdmod, <MEDIUM,LARGE,HUGE>
        ifdef   cdmod
        FARCODE equ 1
        endif
endm
irp     dtmod, <COMPACT,LARGE,HUGE>
        ifdef   dtmod
        FARDATA equ 1
        endif
endm
ifdef FARCODE
CRC_TEXT        SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:CRC_TEXT
BPOFST = 6
else
_TEXT           SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:_TEXT
BPOFST = 4
endif

BlockPtr        equ     [bp][BPOFST]
ifdef FARDATA
BlockSeg        equ     [bp][BPOFST+2]
BlockCnt        equ     [bp][BPOFST+4]
else
BlockCnt        equ     [bp][BPOFST+2]
endif
CRCin           equ     [bp][BPOFST]
CRCchar         equ     [bp][BPOFST+2]

ifdef FARCODE
_calc_crc       proc    far
else
_calc_crc       proc    near
endif
        push    bp
        mov     bp,sp
        push    si
        push    di              ;setup stack frame
ifdef FARDATA
        push    es
        mov     es,BlockSeg
endif
        mov     bx,BlockPtr
        mov     si,BlockCnt     ;get the arguments
        xor     ax,ax           ;AX will hold CRC value
        or      si,si
        jz      done            ;done if block count was zero
        mov     di,8
        mov     dx,1021h        ;values used when calc'g CRC
outer_loop:
ifdef FARDATA
        xor     ah,es:[bx]
else
        xor     ah,[bx]
endif
        inc     bx
        mov     cx,di
inner_loop:
        shl     ax,1
        jnc     lp_contin
        xor     ax,dx
lp_contin:
        loop    inner_loop
        dec     si
        jnz     outer_loop      ;calculate the CRC value
done:
ifdef FARDATA
        pop     es
endif
        pop     di
        pop     si
        pop     bp
        ret                     ;fix regs and return with AX=CRC
_calc_crc       endp

ifdef FARCODE
_update_crc     proc    far
else
_update_crc     proc    near
endif
        push    bp
        mov     bp,sp           ;C stack frame
        mov     ax,CRCin        ;get passed CRC to be updated
        xor     ah,CRCchar
        mov     cx,8
        mov     dx,1021h
updt_loop:
        shl     ax,1
        jnc     updt_contin
        xor     ax,dx
updt_contin:
        loop    updt_loop       ;update the CRC
        pop     bp
        ret                     ;return updated value
_update_crc     endp

ifdef FARCODE
CRC_TEXT        ends
else
_TEXT           ends
endif
        end

