/* ddump.c displays a file hex 'dump' on the screen.
   compiled with: 'cc ddump.c -lcurses -oddump'
*/

#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <errno.h>

FILE *filein;

char infilename[80];
char hexline[16];
char searchline[64];
char searchstr[16];
char workline[80];
char inchar;
int i, j, k;
int pagecnt;
int linecnt;
long fileposition;

main(int argc, char *argv[], char envp[])
{
  initscr();
/*  nodelay(curscr,TRUE); */
  cbreak();
/*  noecho();*/ 
  refresh();
  for (i=0; i<80; i++) infilename[i] = '\0'; 
  for (i=0; i<80; i++) workline[i] = '\0'; 
  for (i=0; i<16; i++) hexline[i] = '\0';
  strcpy(infilename,argv[1]);
  printw("%s\n",infilename);
  if (infilename[0] == '\0')
   {
     printw("\nDumps hex values of a file to the screen\n\n");
     printw("Enter input file name "); 
     refresh();
     getstr(infilename);
     refresh(); erase();
   }
  if ((filein = fopen(infilename,"rb+"))==NULL) { 
     switch (errno) {
        case (ENOENT) : printw("\nError 2. No such file or directory"); break;
        case (ETXTBSY) : printw("\nError 26. Text file busy"); break;
        default  : printw("\nFile Error Number: %ld",errno);
        }
     printw("\nSorry can't read that file\n"); refresh(); endwin(); exit(0); }
  pagecnt = 0; linecnt = 0;
  move(0,0); refresh();
  printw (" OFFSET   Examining contents of <%s>",infilename); 
  move(0,64); refresh(); printw ("ASCII");
  move(2,10); refresh();
  for (i=0; i<16; i++) printw("%0.2X ",i);
  printw (" ");
  for (i=0; i<16; i++) printw("%X",i);
  printw("\n");
  refresh();
  while (!feof(filein))
   {
     inchar = fgetc(filein);
     hexline[linecnt] = inchar;
     if (linecnt == 0) fileposition = ftell(filein);
     linecnt++;
     if (linecnt > 15) 
      {
        refresh();
        printw("%0.8ld  ",(fileposition-1));
        for (i=0; i<16; i++) printw("%0.2X ",hexline[i]);     
        printw(" ");
        for (i=0; i<16; i++) {
            if (isprint(hexline[i])) printw("%c",hexline[i]);
               else printw("^");
                             } 
        printw("\n");
        refresh();
        linecnt = 0;
        for (i=0; i<16; i++) hexline[i] = '\0';
        pagecnt++;
      }
     if (pagecnt > 15)
      {
       for (i=0; i<80; i++) workline[i] = '\0';
       for (i=0; i<16; i++) searchstr[i] = '\0';
printw("\nEnter file offset or 'u'p a page or return for down a page\n");
printw("or 's' followed by search term or 'quit' to exit: ");
       clrtobot(); refresh();
       getstr(workline);
       pagecnt = 0;
       if (workline[0] == 'q' || workline[0] == 'Q') break;
       refresh();
       /* check for page up */
       if (workline[0] == 'u' || workline[0] == 'U')
          { fileposition = ftell(filein);
            fileposition = fileposition - 512;
            if (fileposition < 0) fileposition = 0; 
            fseek(filein,fileposition,0);
          }
       /* check for a search string and the search if so */
       if (workline[0] == 's' || workline[0] == 'S') 
          {
            for (i=1; i<16; i++) searchstr[i-1] = workline[i];
            searchstr[15] = '\0';
            for (i=0; i<16; i++) if (searchstr[i] == '\n') searchstr[i]='\0'; 
            fileposition = ftell(filein);
            fileposition = fileposition - 256; 
            if (fileposition < 0) fileposition = 0;
            fseek(filein,fileposition,0);
            move(22,0); refresh();
            printw("Searching for <%s> from position... ",searchstr);
            printw("%0.8ld",fileposition); refresh();
            k = 0; /* k = 1 exits loop */
            while (k == 0)
            {
            move(22,0); refresh();
            printw("Searching for <%s> from position... ",searchstr);
            fileposition = ftell(filein);
            printw("%0.8ld",fileposition); refresh();
            for (i=0; i<64; i++) searchline[i] = '\0';
            for (i=0; i<64; i++) { 
                if (feof(filein)) 
                   searchline[i] = ' ';
                   else { searchline[i] = fgetc(filein);
                          if (searchline[i] == '\0') searchline[i] = ' ';
                        }
                }
            if (strstr(searchline,searchstr)!=NULL)
               { /* found */
                 fseek(filein,(long)-64,1);
                 k = 1;
               } else { /* continue */
                 if (!feof(filein)) fseek(filein,(long)-16,1);
               }
            if (feof(filein)&&k!=1) { /* not found */
               printw("\n<%s> not found.  Press Return",searchstr);
               refresh();
               getstr(searchstr);
               clearerr(filein);
               fseek(filein,(long)0,0); 
               k = 1;
               }
            }
          } 
       /* check for numeric input and set file position if so */
       fileposition = -1;
       fileposition = atol(workline);
       if (fileposition > 0) 
        {
          fileposition--;
          fseek(filein,fileposition,0); 
        }
       move(0,0); refresh();
       printw (" OFFSET   Examining contents of <%s>",infilename); 
       move(0,64); refresh(); printw ("ASCII");
       move(2,10); refresh();
       for (i=0; i<16; i++) printw("%0.2X ",i);
       printw(" ");
       for (i=0; i<16; i++) printw("%X",i);
       printw("\n");
       refresh();
      }
   }
        /* last row */
        if (workline[0] != 'q' && workline[0] != 'Q') { 
        printw("%0.8ld  ",(fileposition-1));
        for (i=0; i<16; i++) printw("%0.2X ",hexline[i]);     
        printw(" ");
        for (i=0; i<16; i++) {
            if (isprint(hexline[i])) printw("%c",hexline[i]);
               else printw("^");
                             } 
        printw("\n");
        refresh();
        }
printw("C'est tout!!!\n");
clrtobot(); refresh();
endwin();
system("stty sane tab3");
}


     

