


/*	difftime.c
 *
 *	Calculates the difference in hours and minutes (HH:MM format)
 *	between a starting time and finish time as given on the
 *	command line.
 *
 *	Usage:	  difftime start_time finish_time
 *	Example:  difftime 2359 420
 *		  04:21
 *
 *	Author:   Gene Kwiecinski
 *	Date:	  03-18-93
 */


#undef UNIX	/*  controls file name display in error strings  */


/*  included header files  */

#include <stdio.h>
#include <stdlib.h>


/*  external function declarations  */

extern void	exit();
extern char	*itoa();
extern int	fprintf();


/*  error messages  */

char	*eusage = "usage:  %s start_time finish_time\n",
	*ebadts = "%s:  bad start_time\n",
	*ebadtf = "%s:  bad finish_time\n";


/*  output format string  */

char	*fmtstr = "%02d:%02d\n";



/*  main function  */

main( argc, argv )
	int	argc;
	char	*argv[];
	{
	char	*pname;
	int	ts, tf, hh, mm;

#if UNIX
	pname = argv[0];		/*  for Unix  */
#else
	pname = "difftime";		/*  for DOS   */
#endif

	/*  check usage  */
	if( argc != 3 ){
		fprintf( stderr, eusage, pname );
		exit(1);
		}

	/*  get start_time and finish_time  */
	ts = atoi( argv[1] );
	tf = atoi( argv[2] );

	/*  bounds checking  */
	if( ts < 0 || ts > 2359 || ts/100 > 59 ){
		fprintf( stderr, ebadts, pname );
		exit(1);
		}
	if( tf < 0 || tf > 2359 || tf/100 > 59 ){
		fprintf( stderr, ebadtf, pname );
		exit(1);
		}

	/*  calculate difference and print  */
	hh = ( tf/100 - ts/100 );
	mm = ( tf%100 - ts%100 );
	if( mm < 0 )
		hh--, mm += 60;
	if( mm > 59 )
		hh++, mm -= 60;
	if( hh < 0 )
		hh += 24;
	if( hh > 24 )
		hh -= 24;
	fprintf( stdout, fmtstr, hh, mm );

	exit(0);
	}

