#include <dos.h>
#include <conio.h>

unsigned ShortCursor, MidCursor, TallCursor, OldCursor, NoCursor;
unsigned getCursor(void);
void initCursor(void)
/* Initializes the different Cursor types */
{
 struct text_info ti;

 gettextinfo(&ti);
 OldCursor = getCursor();
 if (ti.currmode == MONO)
 {
  ShortCursor = 0x0A0C;
  MidCursor = 0x090C;
  NoCursor = 0x2000;
 }
 else
 {
  ShortCursor = 0x0607;
  MidCursor = 0x0507;
  TallCursor = 0x000D; /* 0x0307; */
  NoCursor = 0x2000;
 }
} /* initCursor */

void SetCursor(unsigned int shape)
/* Sets the shape of the Cursor */
{
 union REGS reg;

 reg.h.ah = 1;
 reg.x.cx = shape;
 int86(0X10, &reg, &reg);
} /* SetCursor */

unsigned getCursor(void)
/* Returns the shape of the current Cursor */
{
 union REGS reg;

 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0X10, &reg, &reg);
 return(reg.x.cx);
} /* getCursor */

