#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include "keys.h"

/* structure template for list */
struct address
{
  char FirstName[15];
  char LastName[15];
  char Street[40];
  char City[20];
  char State[3];
  char Zip[10];
  char Phone[15];
  struct address *Next;           /* pointer to next record  */
  struct address *Prior;          /* pointer to Prior record */
};

struct address Dummy;		  /* dummy record for data entry */
struct address *FirstRecord;      /* pointer to first record */
struct address *Last;             /* pointer to last record  */

/* constants for prompts */
const char *FirstPrompt = "        enter first name:  ";
const char *LastPrompt = "         enter last name:  ";

/* file name field */
char FileName[12];

/* count of records */
int count;

/* structure for screen setup */
struct text_info textinfo;

/* function prototypes */
void main_menu(), enter(), search(), save(), load(), charbox(), Beep(void);
void inputs(char *s, int count), display_screen();
void put_char(char a), labels(void), browse(void);
void square(int x, int y), done(int selection), WriteFile();
void put_char(char a), open_file();
void field(char *field, int max);
void edit(void), spawnit(void);
int getkey(), menu_select();
unsigned edit_field(const unsigned row, unsigned column,
		    char *s, unsigned max, unsigned back, unsigned fore);
unsigned display(struct address *info, char *s1, char *s2, 
                 unsigned back, unsigned fore);


/* Cursor Control Variables and Function Prototypes */
extern unsigned ShortCursor, MidCursor, TallCursor, OldCursor, NoCursor;
void initCursor(void), SetCursor(unsigned shape);

/* main function */
void main(int argc, char *argv[])
{
  char s[80];
  struct address *RecordBuffer;

  gettextinfo(&textinfo);

  FirstRecord = Last = NULL;
  *FileName = NULL;

  textmode(3);
  textcolor(YELLOW);

  initCursor();
  SetCursor(NoCursor);

  /* if command line arguements... */
  if (argc >= 2)
  {
    clrscr();
    strcpy(FileName, argv[1]);
    open_file();
  }

  /* draw box */
  charbox();

  /* shrink window */
  window(2, 2, 79, 24);

  /* main program loop */
  for (;;)
  {
    switch (menu_select())
    {
      case 1:     enter();  /* enter record            */
        break;
      case 2:     delete(); /* remove an address       */
        break;
      case 3:     labels();        /* write list as labels */
        break;
      case 4:     search(); /* find a record      */
        break;
      case 5:     edit();
        break;
      case 6:     save();        /* save list to disk       */
        break;
      case 7:     load();        /* load from disk     */
        break;
      case 8:     browse();      /* allow user to browse through list */
        break;
      case 9:     spawnit();
        break;
      case 10:
        if (FileName[0])
        {
          unsigned answer;
            
          clrscr();
          gotoxy(2, 1);
          cprintf("%s loaded.  Save before exiting? (Y/N)\n", FileName);
          gotoxy(2, 2);
          cputs("(Press ESCAPE to return to program)");
          textattr(YELLOW | BLINK | LIGHTGRAY);
          gotoxy(2, 3);
          cprintf("WARNING -- Current data will be lost if not saved!");
          answer = getch();
          if (answer == ESC)
          {
            textbackground(BLACK);
            textcolor(YELLOW);
            break;
          } 
          if ((toupper(answer) == 'Y'))
          {
            clrscr();
            textbackground(BLACK);
            textcolor(YELLOW);
            WriteFile();
          }
        }
        textattr(textinfo.attribute);
        window(1, 1, 80, 25);
        SetCursor(OldCursor);
        clrscr();
        exit(0);
    }
  }
}

/* Enter names and addresses */
void enter()
{
  struct address *store_record();
  struct address *enteree;
  unsigned RecordIndex = 6;
  unsigned max = 0;
  unsigned begin = 31;
  char *s;

  clrscr();

  enteree = (struct address *) calloc(1, sizeof(struct address));
  if (!enteree)
  {
    clrscr();
    puts("out of memory");
    return;
  }

  display(&Dummy, "Add Record Mode", 
          "Enter a record, press any key to continue", YELLOW, LIGHTGRAY);
  SetCursor(TallCursor);

  while ( (RecordIndex <= 18) && (RecordIndex >= 4) )
  {
    if (RecordIndex == 4) RecordIndex += 2;

    switch (RecordIndex)
    {
      case  4:
        break;
      case 6:
        s = enteree->FirstName;
        max = 14;
      	break;
      case 8:
        s = enteree->LastName;
      	max = 14;
      	break;
      case 10:
        s = enteree->Street;
      	max = 39;
      	break;
      case 12:
      	s = enteree->City;
      	max = 19;
      	break;
      case 14:
        s = enteree->State;
      	max = 2;
      	break;
      case 16:
      	s = enteree->Zip;
      	max = 9;
      	break;
      case 18:
      	s = enteree->Phone;
      	max = 14;
      	break;
    }
    gotoxy(begin, RecordIndex);
    RecordIndex = edit_field(begin, RecordIndex, s, max, LIGHTGRAY, YELLOW);
    

    if ((RecordIndex == 8) && (*s == 0)) return;

  } /* while loop for input of fields */
  clrscr();
  FirstRecord = store_record(enteree, FirstRecord);
}     

/* edit a record */
void edit(void)
{
  int RecordIndex = 6, max = 0;
  int begin = 31;
  char sfirst[20], slast[20];
  struct address *editee, *find();
  register int loop;
  char *s;

  /* initialize input strings */
  for (loop = 0; loop < 20; loop++)
  {
    sfirst[loop] = '\0';
    slast[loop] = '\0';
  }

  clrscr();
  SetCursor(TallCursor);
  gotoxy(2,1);
  cputs(FirstPrompt);
  edit_field(27, 1, sfirst, 15, LIGHTGRAY, YELLOW);
  gotoxy(2, 2);
  cputs(LastPrompt);
  edit_field(27, 2, slast, 15, LIGHTGRAY, YELLOW);
  SetCursor(NoCursor);

  clrscr();

  editee = find(sfirst, slast);

  if (!editee) return;

  display(editee, "Edit Record Mode", "Change Record - <enter> to continue",
          YELLOW, LIGHTGRAY);

  SetCursor(TallCursor);
  while ( (RecordIndex <= 18) && (RecordIndex >= 4) )
  {
    if (RecordIndex == 4) RecordIndex += 2;

    switch (RecordIndex)
    {
      case  4:
      	break;

      case 6:
      	s = editee->FirstName;
      	max = 14;
      	break;

      case 8:
      	s = editee->LastName;
      	max = 14;
      	break;

      case 10:
      	s = editee->Street;
      	max = 39;
      	break;

      case 12:
      	s = editee->City;
      	max = 19;
      	break;

      case 14:
      	s = editee->State;
      	max = 2;
      	break;

      case 16:
      	s = editee->Zip;
      	max = 9;
      	break;

      case 18:
      	s = editee->Phone;
      	max = 14;
      	break;
    }
    gotoxy(begin, RecordIndex);
    RecordIndex = edit_field(begin, RecordIndex, s, max, LIGHTGRAY, YELLOW);
  }  /* while RecordIndex OK & editee  */

  SetCursor(NoCursor);

  /* put revised record into sorted order in list */

  if(FirstRecord == editee)
  {
    FirstRecord = editee->Next;
    if (FirstRecord) FirstRecord->Prior = NULL;
    else Last = NULL;
  }
  else
  {
    editee->Prior->Next = editee->Next;
    if (editee != Last)
      editee->Next->Prior = editee->Prior;
    else
     Last = editee->Prior;
  }

  FirstRecord = store_record(editee, FirstRecord);

}  /* edit */

unsigned edit_field(const unsigned col, unsigned row,
		    char *s, unsigned max, unsigned back, unsigned fore)
/* A field edit routine that that returns an interger
   that is incremented if the CR, down arrow, or page down is hit,
   and is decremented if the up arrow of page up is hit.  This
   interger can be used to indicate field numbers.  The length of the
   string passed to edit must have at least as many characters allocated
   to it as the number "max"  */
{
 unsigned character, end = (strlen(s) + col);
 unsigned pos = col, Index, IsSpace;
 const char Space = ' ';
 struct text_info textinfo;

 gettextinfo(&textinfo);
 max += col;

 textbackground(back);
 textcolor(fore);
 gotoxy(col, row);
 field(s, (max+1) - col);
 do

 {
  switch(character = getkey())
  {
   case HOME :
    pos = col;
    gotoxy(col, row);
    break;
   case END :
    pos = end;
    gotoxy(end, row);
    break;
   case LEFT :
    if (pos > col)
    {
     pos--;
     gotoxy(pos, row);
    }
    else
    {
      Beep();
    }
    break;
   case RIGHT :
    if (pos < end)
    {
     pos++;
     gotoxy(pos, row);
    }
    else
    {
     Beep();
    }
    break;
   case BS :
    if (pos == col)
    {
      Beep();
      break;
    }
    pos--;
    for (Index = pos - col; Index <= end - col; Index++)
    {
     s[Index] = s[Index + 1];
    }
    gotoxy(col, row);
    cputs(s);
    putchar(Space);
    end--;
    gotoxy(pos, row);
    break;
   case DEL :
    if (pos >= end)
    {
      Beep();
      break;
    }
    end--;
    for(Index = pos - col; Index <= end - col; Index++)
     s[Index] = s[Index+1];
    gotoxy(col, row);
    cputs(s);
    putchar(Space);
    gotoxy(pos, row);
    break;
   case PGUP :
   case UP :
    if (row >= 1)
    {
      textattr(textinfo.attribute);
      return(row - 2);
    }
    break;
   case PGDN :
   case CR :
   case DOWN :
    textattr(textinfo.attribute);
    return (row + 2);
   case ESC :
    pos = col;
    gotoxy(col, row);
    break;
   case CTRLLEFT :
    if (pos == col)
    {
      Beep();
      break;
    }
    IsSpace = FALSE;
    Index = (pos - col - 2);
    if (Index <= 0)
    {
     gotoxy(col, row);
     Index = 0;
     pos = col;
     break;
    }
    while ((!IsSpace) && (Index != 0))
    {
     while (!IsSpace)
     {
      if ((s[Index] == ' ') | (s[Index] == 0))
	IsSpace = TRUE;
      Index--;
      if (Index <= 0)
      {
	pos = col;
	Index = 0;
	gotoxy(col, row);
	break;
      }
     }
     if (Index == 0)
      break;
     Index += 3;
     pos = Index + col -1;
     gotoxy(pos, row);
    }
    break;
   case CTRLRIGHT :
    if (pos >= end)
    {
      Beep();
      break;
    }
    IsSpace = FALSE;
    Index = (pos - col);
    while ((!IsSpace) && (pos < end))
    {
     if (s[Index] == ' ')
     {
       IsSpace = TRUE;
       Index++;
     }
     while (!IsSpace)
     {
      if ((s[Index] == ' ') | (s[Index] == NULL))
	IsSpace = TRUE;
      if (s[Index] == NULL) Index--;
      Index++;
     }
     Index++;
     pos = Index + col -1;
     gotoxy(pos, row);
    }
    break;
   default  :
    if ((character >= ' ') && (character <= '~'))
    {
     if (end >= max)
     {
      Beep();
      break;
     }
     for (Index = end - col + 1; Index > pos - col; Index--)
       s[Index] = s[Index - 1];
     s[Index] = ((char)character);
     if (strlen(s) <= 1)
	 s[Index + 1] = NULL;
     gotoxy(col, row);
     end++;
     s[end-col] = NULL;
     cputs(s);
     pos++;
     gotoxy(pos, row);
     break;
    }  /* if */
  }  /* switch */
  s[end-col] = NULL;
 }  while (1);  /* do */
}  /* editstring */


/* Create a doubly linked list in sorted order.  A pointer
   to the first element is returned */

struct address *store_record(struct address *insertee,       /* new record */
                          struct address *first)     /* store in sorted order */
{
  struct address *old, *next_to_compare;
  char *Spaces = "                              ";
  char insert_buffer[32];
  char next_buffer[32];
  char *insert_first = &insert_buffer[16];
  char *next_first = &next_buffer[16];
  unsigned Index;

  if (Last == NULL)              /* first element in list */
  {
    insertee->Next  = NULL;
    insertee->Prior = NULL;
    Last   = insertee;
    return insertee;
  }
  next_to_compare = first;                  /* start at top of list */
  old = NULL;
  
  /* set up last name, first name Indexes */
  
  strcpy(insert_buffer, Spaces);
  strcpy(next_buffer, Spaces);
  
  Index = 0;
  
  while (insertee->LastName[Index])
  {
    insert_buffer[Index] = insertee->LastName[Index];
    Index++;
  }
         
  Index = 0;
  
  while (next_to_compare->LastName[Index])
  {
    next_buffer[Index] = next_to_compare->LastName[Index];
    Index++;
  }
  
  strcpy(insert_first, insertee->FirstName);
  strcpy(next_first, next_to_compare->FirstName); 
  
  while (next_to_compare)
  {
    if (strcmpi(next_buffer, insert_buffer) < 0)
    {
      old = next_to_compare;
      next_to_compare = next_to_compare->Next;
 
      strcpy(insert_buffer, Spaces);
      strcpy(next_buffer, Spaces);
  
      Index = 0;
  
      while (insertee->LastName[Index])
      {
        insert_buffer[Index] = insertee->LastName[Index];
        Index++;
      }
         
      Index = 0;
  
      while (next_to_compare->LastName[Index])
      {
        next_buffer[Index] = next_to_compare->LastName[Index];
        Index++;
      }
  
      strcpy(insert_first, insertee->FirstName);
      strcpy(next_first, next_to_compare->FirstName); 
    }
    else
    {
      if (next_to_compare->Prior)
      {
	next_to_compare->Prior->Next = insertee;
	insertee->Next = next_to_compare;
	insertee->Prior = next_to_compare->Prior;
	next_to_compare->Prior = insertee;
	return first;
      }
      insertee->Next = next_to_compare;          /* new first element     */
      insertee->Prior = NULL;
      next_to_compare->Prior = insertee;
      return insertee;
    }
  }
  old->Next = insertee;       /* put on end       */
  insertee->Next = NULL;
  insertee->Prior = old;
  Last = insertee;
  return FirstRecord;
}

/* remove an element from the list */
delete()
{
  struct address *RecordBuffer, *find();
  char slast[15], sfirst[15];
  char answer;
  unsigned loop;

  for (loop = 0; loop < 15; loop++)
  {
    sfirst[loop] = '\0';
    slast[loop] = '\0';
  }

  clrscr();
  SetCursor(TallCursor);
  gotoxy(2, 1);
  cputs(FirstPrompt);
  edit_field(27, 1, sfirst, 15, LIGHTGRAY, YELLOW);
  gotoxy(2, 2);
  cputs(LastPrompt);
  edit_field(27, 2, slast, 15, LIGHTGRAY, YELLOW);
  SetCursor(NoCursor);
  
  RecordBuffer = find(sfirst, slast);

  if (RecordBuffer)
  {
    clrscr();
    SetCursor(TallCursor);
    answer = display(RecordBuffer, "Delete Record Mode", "Ok to delete? (Y/N)", 
                     YELLOW, LIGHTGRAY);
    SetCursor(NoCursor);
    
    if (toupper(answer) == 'Y')
    {
      if(FirstRecord == RecordBuffer)
      {
	FirstRecord = RecordBuffer->Next;
	if (FirstRecord) 
	  FirstRecord->Prior = NULL;
	else 
	  Last = NULL;
	clrscr();
	gotoxy(2, 1);
	cprintf("Record deleted");
	getch();
      }
      else
      {
	RecordBuffer->Prior->Next = RecordBuffer->Next;
	if (RecordBuffer != Last)
	  RecordBuffer->Next->Prior = RecordBuffer->Prior;
	else
	Last = RecordBuffer->Prior;
	clrscr();
	gotoxy(2, 1);
	cprintf("Record deleted");
	getch();
      }
    }
  }
  else
  {
    clrscr();
    gotoxy(2, 1);
    cprintf("record not found, press <CR> to continue...");
    getch();
  }
}

/* find the address given the name */
struct address *find(char *sfirst, char *slast)
{
  struct address *RecordBuffer;
  RecordBuffer = FirstRecord;
  while (RecordBuffer)
  {
    if (!strcmpi(slast, RecordBuffer->LastName))
    {
      if (!strcmpi(sfirst, RecordBuffer->FirstName))
      return RecordBuffer;
    }
    RecordBuffer = RecordBuffer->Next;           /* get next record */
  }
  clrscr();
  return NULL;                   /* not found   */
}

/* allow the user to browse the list, and
   edit a record if he or she wishes
*/
void browse(void)
{
  unsigned struct address *RecordBuffer, *InfoBuffer;
  unsigned ans = 0, max = 0;
  char *s;
  unsigned startflag = FALSE;

  RecordBuffer = FirstRecord;
  clrscr();

  while (RecordBuffer)
  {
    unsigned RecordIndex = 6;
    const unsigned begin = 31;

    if (startflag)
    {
      ans = getkey();
      if ((ans == UP) || (ans == PGUP))
           Beep();
      startflag = FALSE;
    }
    else
    {
      ans = display(RecordBuffer, "Browse List Mode", 
                   "PGUP=prior ESC=abort CR=next F10=edit", YELLOW, LIGHTGRAY);
    }
    
    switch(ans)
    {
      case PGUP:
      case UP:
        if (RecordBuffer->Prior == NULL) 
        {
          startflag = TRUE;
          break;
        }
        RecordBuffer = RecordBuffer->Prior;
        break;
        
      /* edit a record */
      case F10:
        InfoBuffer = RecordBuffer;
        RecordBuffer = InfoBuffer->Next;
        SetCursor(TallCursor);
        while ( (RecordIndex <= 18) && (RecordIndex >= 4) )
        {
          if (RecordIndex == 4) RecordIndex += 2;

          switch (RecordIndex)
          {
            case  4:
              break;

            case 6:
              s = InfoBuffer->FirstName;
              max = 14;
      	      break;

            case 8:
              s = InfoBuffer->LastName;
              max = 14;
      	      break;

            case 10:
              s = InfoBuffer->Street;
              max = 39;
              break;

            case 12:
      	      s = InfoBuffer->City;
              max = 19;
              break;

            case 14:
              s = InfoBuffer->State;
              max = 2;
              break;

            case 16:
              s = InfoBuffer->Zip;
              max = 9;
              break;

            case 18:
              s = InfoBuffer->Phone;
              max = 14;
              break;
           }
           gotoxy(begin, RecordIndex);
           RecordIndex = edit_field(begin, RecordIndex, s, max, 
                                    LIGHTGRAY, YELLOW);

        } /* while loop for input of fields */
        SetCursor(NoCursor);
        /* put revised record into sorted order in list */

        if(FirstRecord == InfoBuffer)
        {
          FirstRecord = InfoBuffer->Next;
          if (FirstRecord) FirstRecord->Prior = NULL;
          else Last = NULL;
        }
        else
        {
          InfoBuffer->Prior->Next = InfoBuffer->Next;
          if (InfoBuffer != Last)
            InfoBuffer->Next->Prior = InfoBuffer->Prior;
          else
            Last = InfoBuffer->Prior;
        }
        
        FirstRecord = store_record(InfoBuffer, FirstRecord);

	break;
      case ESC:
        return;
      default:
        RecordBuffer = RecordBuffer->Next;
        break;
    }
  }
}

/* put the list to a file in label format */
void labels(void)
{
  FILE *labels;
  struct address *RecordBuffer;

  RecordBuffer = FirstRecord;
  
  if ((labels = fopen("label.txt", "wt")) == NULL)
  {
    clrscr();
    gotoxy(2, 1);
    puts("Unable to open file \"label.txt\"");
    return;
  }

  while(RecordBuffer)
  {
    fprintf(labels, "%s ", RecordBuffer->FirstName);
    fprintf(labels, "%s\n", RecordBuffer->LastName);
    fprintf(labels, "%s\n", RecordBuffer->Street);
    fprintf(labels, "%s, ", RecordBuffer->City);
    fprintf(labels, "%s   ", RecordBuffer->State);
    fprintf(labels, "%s\n\n", RecordBuffer->Zip);
    RecordBuffer = RecordBuffer->Next;
  }
  fclose(labels);
  clrscr();
  gotoxy(2, 1);
  cputs("Labels sent to file \"label.txt\"");
  gotoxy(2, 2);
  cputs("Press any key to continue...");
  getch();
}


/* display an address */
unsigned display(struct address *RecordBuffer, char *s1, char *s2, 
                 unsigned fore, unsigned back)
{
  int loop;
  unsigned answer;
  unsigned s1y = ((80 - strlen(s1))/2);
  unsigned s2y = ((80 - strlen(s2))/2);

  struct text_info textinfo;

  gettextinfo(&textinfo);

  gotoxy(18, 6);
  cprintf("first name:  ");
  gotoxy(18, 8);
  cprintf(" last name:  ");
  gotoxy(18, 10);
  cprintf("    street:  ");
  gotoxy(18, 12);
  cprintf("      city:  ");
  gotoxy(18, 14);
  cprintf("     state:  ");
  gotoxy(18, 16);
  cprintf("       zip:  ");
  gotoxy(18, 18);
  cprintf("     phone:  ");

  textbackground(back);
  textcolor(fore);

  gotoxy(31, 6);
  field(RecordBuffer->FirstName, 15);
  gotoxy(31, 8);
  field(RecordBuffer->LastName, 15);
  gotoxy(31, 10);
  field(RecordBuffer->Street, 41);
  gotoxy(31, 12);
  field(RecordBuffer->City, 20);
  gotoxy(31, 14);
  field(RecordBuffer->State, 3);
  gotoxy(31, 16);
  field(RecordBuffer->Zip, 10);
  gotoxy(31, 18);
  field(RecordBuffer->Phone, 15);

  textattr(textinfo.attribute);

  gotoxy(s1y, 3);

  cputs(s1);
  
  gotoxy(s2y, 21);

  cputs(s2);

  answer = getkey();

  return answer;
}

/* search for an address given the name */
void search()
{
  char fname[15];
  char lname[15];
  struct address *RecordBuffer, *find();
  unsigned loop;
  
  clrscr();
  for (loop = 0; loop < 15; loop++)
  {
    fname[loop] = '\0';
    lname[loop] = '\0';
  };
  SetCursor(TallCursor);
  gotoxy(2, 1);
  cputs(FirstPrompt);
  edit_field(27, 1, fname, 15, LIGHTGRAY, YELLOW);
  gotoxy(2, 2);
  cputs(LastPrompt);
  edit_field(27, 2, lname, 15, LIGHTGRAY, YELLOW);
  SetCursor(NoCursor);

  if (!((RecordBuffer=find(fname, lname))!=0))
  {
    clrscr();
    gotoxy(2, 1);
    cputs("name not found, press <CR> to continue...");
    getch();
  }
  else
  {
    clrscr();
    display(RecordBuffer, "Display Record Mode", "Press any key to continue...", 
            YELLOW, LIGHTGRAY);
  }
}

void save()
{
  clrscr();
  gotoxy(2, 1);
  cputs("Enter name of file:  ");
  SetCursor(TallCursor);
  inputs(FileName, 15);
  SetCursor(NoCursor);
  WriteFile();
}

/* save the mailing list to a disk file */
void WriteFile()
{
  register int t;
  struct address *RecordBuffer;
  FILE *fp;
  if ((fp = fopen(FileName, "wb")) == NULL)
  {
    clrscr();
    gotoxy(2, 1);
    cprintf("cannot save file %s", FileName);
    getch();
    return;
  }
  gotoxy(2, 2);
  cputs("saving file");
  RecordBuffer = FirstRecord;
  while (RecordBuffer)
  {
    fwrite(RecordBuffer, sizeof(struct address), 1, fp);
    RecordBuffer = RecordBuffer->Next;           /* get next address */
  }
  fclose(fp);
  gotoxy(2, 3);
  cputs("file saved");
  gotoxy(2, 4);
  cputs("press <CR> to continue...");
  getch();
}

/* load an address file from disk */
void load()
{
  char answer;

  clrscr();

  if (FileName[0] > 1)
  {
    clrscr();
    gotoxy(2, 1);
    cprintf("%s already loaded.  Load new file? (Y/N)\n", FileName);
    textattr(YELLOW | BLINK | LIGHTGRAY);
    gotoxy(2, 2);
    cprintf("WARNING -- Current data will be lost if not saved!");
    textbackground(BLACK);
    textcolor(YELLOW);
    answer = getch();
    if (!(toupper(answer) == 'Y'))
      return;
  }
  clrscr();
  gotoxy(2, 1);
  SetCursor(TallCursor);
  cputs("File name:  ");
  inputs(FileName, 15);
  SetCursor(NoCursor);
  clrscr();
  open_file();
}

/* actually open the file */
void open_file()
{
  register int t;
  struct address *RecordBuffer, *temp = NULL;
  FILE *fp;

  if((fp = fopen(FileName, "rb")) == NULL)
  {
    clrscr();
    *FileName = NULL;
    gotoxy(2, 1);
    cprintf("cannot open file\n");
    gotoxy(2, 2);
    cputs("press <CR> to continue...");
    getch();
    FileName[1] = 0;
    return;
  }

  while (FirstRecord)
  {
    RecordBuffer = FirstRecord->Next;
    free(RecordBuffer);
    FirstRecord = RecordBuffer;
  }

  FirstRecord = (struct address *) calloc(1, sizeof(struct address));
  if (!FirstRecord)
  {
    clrscr();
    gotoxy(2, 1);
    cputs("Out of memory");
    gotoxy(2, 2);
    cputs("press <CR> to continue...");
    return;
  }
  RecordBuffer = FirstRecord;
  count = 0;
  while (!feof(fp))
  {
    if (1 != fread(RecordBuffer, sizeof(struct address), 1, fp)) break;
    /* get memory for next */
    RecordBuffer->Next = (struct address *) calloc(1, sizeof(struct address));
    ++count;
    if (!RecordBuffer->Next)
    {
      printf("out of memory\n");
      return;
    }
    RecordBuffer->Prior = temp;
    temp = RecordBuffer;
    RecordBuffer = RecordBuffer->Next;
  }
  temp->Next = NULL;             /* last entry */
  Last = temp;

  FirstRecord->Prior = NULL;
  fclose(fp);
  gotoxy(2, 1);
  cputs("File loaded....");
  gotoxy(2, 2);
  cprintf("Total of %d records in file.", count);
  gotoxy(2, 3);
  cputs("press any key to continue...");
  getch();
  return;
}

/* shell out to DOS */
void spawnit(void)
{
  textattr(textinfo.attribute);
  window(1, 1, 80, 25);
  SetCursor(ShortCursor);
  clrscr();
  puts("Type \"EXIT\" to return to program.");
  
  spawnl(P_WAIT, "c:\\command", NULL);
  
  clrscr();
  SetCursor(NoCursor);
  textcolor(YELLOW);
  charbox();
  window(2, 2, 79, 24);
}
