
// Program DEMO1: a dirt-simple demonstration of DLOAD.

// This is the root (main program) of a structure that also includes
// four dynamic load modules: DEMODLM1, DEMODLM2, DEMODLM3, and DEMODLM4.

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <process.h>

#include "dload.h"

void report(void);

int main(void);

main()
  {
    char     *dlmname1 = "DEMODLM1";             // Name of the first .DLM file
    char     *dlmname2 = "DEMODLM2";             // Name of the second .DLM file
    int       handle1, handle2;                  // DLM handles

    char      history[80]   = "History:";        // Initialized history string
                                                 // (Warning: just barely big
                                                 // enough for this demo.)

    printf("\n");
    printf("  This program illustrates the simple example of DLOAD\n");
    printf("  program structure shown in Figure 1 of the DLOAD User's manual,\n");
    printf("  using the simplest possible operations. \n\n");
    printf("  The main program, named DEMO1, defines a char buffer initialized\n");
    printf("  to the string \"History:\"; it loads and executes the DLM (Dynamic\n");
    printf("  Load Module) DEMODLM1, and then loads and executes DEMODLM2.\n");
    printf("  DEMODLM2 in turn loads and executes DEMODLM3, which loads\n");
    printf("  and executes DEMODLM1 (although the load turns out to be a\n");
    printf("  no-op, since DEMODLM1 was never unloaded).  [TIME: T=1]\n");
    printf("  Then, DEMODLM3 unloads DEMODLM1 (to make room in memory) and\n");
    printf("  finally loads and executes DEMODLM4.  [TIME: T=2]\n");
    printf("  Everybody returns, and the program ends.\n\n");
    printf("  Every call to the DLOAD function \"dlm_execute\" passes a pointer\n");
    printf("  to the history buffer; everybody appends a few characters to this\n");
    printf("  buffer to record their entry and exit (example: \"DLM2[\" upon entry to\n");
    printf("  DEMODLM2), and then prints the resulting lengthened string.\n\n");
    printf("  Note: this program also contains a function named \"report,\" which\n");
    printf("  displays a report of loaded DLMs; the calls to this function have been\n");
    printf("  commented out.  Edit and remake DEMO1.C to see the report.\n\n");

    printf("  ...press any key to begin: ");
    getch();
    printf("\n");

    if ((handle1 = dlm_load(dlmname1)) < 1)     // Load DEMODLM1.DLM, test: OK?
      {
        printf("!! Failed to load %s.DLM; error code = %d.\n", dlmname1, handle1);
        printf("!! Aborting DEMO1 program.\n");
        exit(-1);
      }

//    report();

    printf("\n\n%s\n", strcat(history, " Main[")); // Show: entering main pgm

    dlm_execute(handle1, history);              // Do DEMODLM1, passing history

    printf("%s\n", strcat(history, " Main[]")); // Show: enter, exit main pgm

    if ((handle2 = dlm_load(dlmname2)) < 1)     // Load DEMODLM2.DLM, test: OK?
      {
        printf("!! Failed to load %s.DLM; error code = %d.\n", dlmname2, handle2);
        printf("!! Aborting DEMO1 program.\n");
        exit(-1);
      }

//    report();

    dlm_execute(handle2, history);              // Do DEMODLM2, passing history

//    report();

    dlm_unload(-1);                             // Unload all DLMs from memory

    printf("%s\n", strcat(history, " Main]"));  // Show: exiting DEMO1 main pgm

//    report();

    return(0);                                  // Return to DOS command line.
  }

void report()
  {
    DLM_DATA   dlm_data;
    LPDLM_DATA lpdlm_data;
    int        i;

    lpdlm_data = (LPDLM_DATA) &dlm_data;

    printf("\n");
    printf("                   Currently Loaded DLMs\n\n");
    printf("handle segment length load-ct active-ct name\n");
    printf("------ ------- ------ ------- --------- ------------------------\n");

    i  = 1;
    while (dlm_info(i, lpdlm_data))
      {
        if (lpdlm_data->load_count)
          {
            printf("%6d    %04X %6u %7d %9d %Fs\n",
                    i,
                    lpdlm_data->segment,
                    lpdlm_data->size,
                    lpdlm_data->load_count,
                    lpdlm_data->active_count,
                    lpdlm_data->filename);
          }

        i++;
      }

    printf("\n");
  }

