
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991
//     ALL RIGHTS RESERVED
//
// program - demo2.c
// purpose - to interface with dlm routines.
// author  - don wanless
// history - 3-11-91
//

// Note: this program also contains a function named "report" which
// displays a report of loaded DLMs; the calls to this function have been
// commented out.  Edit and remake DEMO2.C to see the report.

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <io.h>
# include <fcntl.h>
# include <conio.h>
# include <time.h>

# include "dload.h"
# include "demo2.h"

extern void main(int argc,char **argv);
extern void report(void);
extern void usage(char *str);

//*******************************************************************
// demo2 - to test interface
//
//*******************************************************************
void main(int argc, char **argv)
  {
    int         i;
    char       *cp;
    int         in_handle;
    int         ot_handle;
    char        in_dlm[20];
    char        ot_dlm[20];
    RDCB        rdcb;
    WRCB        wrcb;

    printf("in demo2\n");

    if (argc < 3)
      usage("");

    for (i = 1; i < argc; i++)
      {
        cp = argv[i];
        if (*cp = '-')
          {
            cp++;
            *cp = (char) tolower(*cp);
            switch(*cp)
              {
                case 'i':
                  cp++;
                  if (!stricmp(cp, "kb"))
                    strcpy(in_dlm, "kbreader");
                  else
                    {
                      strcpy(in_dlm, "flreader");
                      strcpy(rdcb.name, cp);
                    }
                  break;

                case 'o':
                  cp++;
                  if (!stricmp(cp, "sc"))
                    strcpy(ot_dlm, "scwriter");
                  else
                    {
                      strcpy(ot_dlm, "flwriter");
                      strcpy(wrcb.name, cp);
                    }
                  break;

                default:
                  usage(argv[i]);
              }
          }
      }

    printf("\nDEMO2 (main module) Starting\n");

    printf("DEMO2 (main module) Loading DLM '%s'\n", in_dlm);

    if ((in_handle = dlm_load(in_dlm)) > 0)
      {
        printf("DEMO2 (main module) Loading DLM '%s'\n", ot_dlm);

        if ((ot_handle = dlm_load(ot_dlm)) > 0)
          {
//            report();

            wrcb.command = WR_OPEN;
            if (dlm_execute(ot_handle, &wrcb))
              {
                rdcb.command = RD_OPEN;
                if (dlm_execute(in_handle, &rdcb))
                  {
                    rdcb.command = RD_READ;
                    wrcb.command = WR_WRITE;
                    i = 0;

                    while (dlm_execute(in_handle, &rdcb))
                      {
                        strcpy(wrcb.buf, rdcb.buf);
                        dlm_execute(ot_handle, &wrcb);
                        i++;
                      }

                    rdcb.command = RD_CLOSE;
                    dlm_execute(in_handle, &rdcb);
                  }

                wrcb.command = WR_CLOSE;
                dlm_execute(ot_handle, &wrcb);

                printf("DEMO2 (main module) Processed %d lines.\n\n", i);
              }

            printf("DEMO2 (main module) Unloading DLM '%s'\n", ot_dlm);

            dlm_unload(ot_handle);
          }

        printf("DEMO2 (main module) Unloading DLM '%s'\n", in_dlm);

        dlm_unload(in_handle);
      }

    printf("DEMO2 (main module) Exit\n");
  }

//*******************************************************************
// report - to get report of loaded dlm's
//
//
//*******************************************************************
void report()
  {
    DLM_DATA   dlm_data;
    LPDLM_DATA lpdlm_data;
    int        i;

    lpdlm_data = (LPDLM_DATA) &dlm_data;

    printf("\n");
    printf("                   Currently Loaded DLMs\n\n");
    printf("handle segment length load-ct active-ct name\n");
    printf("------ ------- ------ ------- --------- ------------------------\n");

    i  = 1;
    while (dlm_info(i, lpdlm_data))
      {
        if (lpdlm_data->load_count)
          {
            printf("%6d    %04X %6u %7d %9d %Fs\n",
                    i,
                    lpdlm_data->segment,
                    lpdlm_data->size,
                    lpdlm_data->load_count,
                    lpdlm_data->active_count,
                    lpdlm_data->filename);
          }

        i++;
      }

    printf("\n");
  }

//*******************************************************************
// usage - tell how to invoke
//
//*******************************************************************
void usage(char *str)
  {
    if (*str)
      printf("\n   '%s'\n", str);
    else
      {
        printf("\nPurpose: This program demonstrates the DLOAD facility.\n");

        printf("\n         It loads .DLM modules to perform the actions selected\n");
        printf(  "         by the user at runtime.\n");

        printf("\n         The program will read input from one of two supported sources:\n");
        printf(  "         ... FILE or KEYBOARD\n");

        printf("\n         and write it to one of two supported destinations:\n");
        printf(  "         ... FILE or SCREEN\n");

        printf("\n         This is intended to be a simple example of a program whose\n");
        printf(  "         components are configured at runtime, not at compile/link time.\n");
      }

    printf("\nusage: demo2 -i[KB|fname] -o[SC|fname]\n");

    printf("\nwhere:       -iKB    - input from keyboard\n");
    printf(  "             -ifname - input from file fname\n");
    printf(  "             -oSC    - output to screen\n");
    printf(  "             -ofname - output to file fname\n");

    exit(1);
  }

//*******************************************************************
