
// demo2.h

// this must be a far structure
// user can define any structure to fit application

// make sure any elements defined in control block will not have
// model dependent sizes (such as pointers)


// reader control block

typedef struct tagRDCB
  {
    unsigned  command;
    int       rc;
    char      buf[256];
    char      name[80];
    unsigned  fh;
  } RDCB;

typedef RDCB far * LPRDCB;

// reader commands

# define RD_OPEN  1
# define RD_READ  2
# define RD_CLOSE 3


// writer control block

typedef struct tagWRCB
  {
    unsigned  command;
    int       rc;
    char      buf[256];
    char      name[80];
    unsigned  fh;
  } WRCB;

typedef WRCB far * LPWRCB;

// writer commands

# define WR_OPEN  1
# define WR_WRITE 2
# define WR_CLOSE 3

// end demo2.h

