
//
// Program demo3: An example of using stub functions to call functions
//                in a dlm.

# include <stdio.h>
# include <conio.h>
# include <string.h>
# include <process.h>

# include "demo3d.h"
# include "dload.h"

int handle=0;

void main(void);

//*******************************************************************
// demo3 - test executing functions in dlm through use of stub routines
//
//*******************************************************************
void main()
  {
    char temp[80];
    int  len;

    printf("\n");
    printf("The purpose of this demo is to illustrate how you can remove\n");
    printf("functions from your main-line C program, put them into a DLM\n");
    printf("(or several DLMs), and then use them in a \"normal\" manner in\n");
    printf("your program.\n\n");

    printf("  ...press any key to begin: ");
    getch();
    printf("\n");

    xstrcpy(temp, "AbCdE");
    printf("after xstrcpy '%s'\n", temp);

    len = xstrlen(temp);
    printf("after xstrlen  %d\n", len);

    xstrupr(temp);
    printf("after xstrupr '%s'\n", temp);

    xstrlwr(temp);
    printf("after xstrlwr '%s'\n", temp);

    // not necessary to do dlm_unload because main program is exiting
    // to DOS, and all memory is returned.
  }

//*******************************************************************


// stub functions used to call functions in DEMO3D.DLM


//*******************************************************************
// xstrlen - find length of a string
//
//*******************************************************************
int xstrlen(char far *str)
  {
    DLMPARMS dlmparms;
    int      len;

    // Check to see if the service DLM is loaded, and load it IFF necessary:
    if (!handle)
      xloaddlm();

    dlmparms.cmd = DO_XSTRLEN;
    dlmparms.lp1 = str;

    dlm_execute(handle, (LPDLMPARMS) &dlmparms);
    len = dlmparms.rc;

    return(len);
  }

//*******************************************************************
// xstrupr - convert a string to upper case
//
//*******************************************************************
char far *xstrupr(char far *str)
  {
    DLMPARMS dlmparms;

    // Check to see if the service DLM is loaded, and load it IFF necessary:
    if (!handle)
      xloaddlm();

    dlmparms.cmd = DO_XSTRUPR;
    dlmparms.lp1 = str;

    dlm_execute(handle, (LPDLMPARMS) &dlmparms);

    return(str);
  }

//*******************************************************************
// xstrlwr - convert a string to lower case
//
//*******************************************************************
char far *xstrlwr(char far *str)
  {
    DLMPARMS dlmparms;

    // Check to see if the service DLM is loaded, and load it IFF necessary:
    if (!handle)
      xloaddlm();

    dlmparms.cmd = DO_XSTRLWR;
    dlmparms.lp1 = str;

    dlm_execute(handle, (LPDLMPARMS) &dlmparms);

    return(str);
  }

//*******************************************************************
// xstrcpy - copy a string
//
//*******************************************************************
char far *xstrcpy(char far *str1, char far *str2)
  {
    DLMPARMS dlmparms;

    // Check to see if the service DLM is loaded, and load it IFF necessary:
    if (!handle)
      xloaddlm();

    dlmparms.cmd = DO_XSTRCPY;
    dlmparms.lp1 = str1;
    dlmparms.lp2 = str2;

    dlm_execute(handle, (LPDLMPARMS) &dlmparms);

    return(str1);
  }

//*******************************************************************


// service routine used to load DEMO3D.DLM


//*******************************************************************
// xloaddlm - check to see if demo3d.dlm loads properly
//
//*******************************************************************
void xloaddlm()
  {
    if ((handle = dlm_load("DEMO3D")) < 1)
      {
        printf("!! Failed to load DEMO3D.DLM; error code = %d.\n", handle);
        exit(1);
      }
  }

//*******************************************************************
