
// Module DEMO3D ... belongs to DEMO3
//
// Make this by typing:
//
//    C> nmake DEMO3D.MAK
//
// ...which will produce the file DEMO3D.DLM

# include <stdio.h>
# include <string.h>

# include "demo3d.h"

int dlm_main(LPDLMPARMS lpdlmparms);

//*******************************************************************
// dlm_main - dispatcher to call functions in dlm
//
//*******************************************************************
int dlm_main(LPDLMPARMS lpdlmparms)
  {
    int rc;

    rc = 0;

    switch (lpdlmparms->cmd)
      {
        case DO_XSTRLEN:
          rc = xstrlen(lpdlmparms->lp1);
          lpdlmparms->rc = rc;
          break;

        case DO_XSTRUPR:
          xstrupr(lpdlmparms->lp1);
          break;

        case DO_XSTRLWR:
          xstrlwr(lpdlmparms->lp1);
          break;

        case DO_XSTRCPY:
          xstrcpy(lpdlmparms->lp1, lpdlmparms->lp2);
          break;

        default:
          rc = -1;
          break;
      }

    return(0);
  }

//*******************************************************************


// actual functions in DEMO3D.DLM


//*******************************************************************
// xstrlen - find length of a string
//
//*******************************************************************
int xstrlen(char far *str)
  {
    int len;

    len = 0;
    while (*str++)
      len++;

    return(len);
  }

//*******************************************************************
// xstrupr - convert a string to upper case
//
//*******************************************************************
char far *xstrupr(char far *str)
  {
    char far *ls1;

    ls1 = str;
    while (*str)
      {
        if (*str >= 'a' && *str <= 'z')
          *str -= 32;
        str++;
      }

    return(ls1);
  }

//*******************************************************************
// xstrlwr - convert a string to lower case
//
//*******************************************************************
char far *xstrlwr(char far *str)
  {
    char far *ls1;

    ls1 = str;
    while (*str)
      {
        if (*str >= 'A' && *str <= 'Z')
          *str += 32;
        str++;
      }

    return(ls1);
  }

//*******************************************************************
// xstrcpy - copy a string
//
//*******************************************************************
char far *xstrcpy(char far *str1, char far *str2)
  {
    char far *ls1;

    ls1 = str1;
    while (*str2)
      *str1++ = *str2++;
    *str1 = 0;

    return(ls1);
  }

//*******************************************************************
