// Module DEMODLM2 ... belongs to DEMO1
//
// Make this by typing:
//
//    C> nmake DEMODLM2.MAK
//
// ...which will produce the file DEMODLM2.DLM

#include <stdio.h>
#include <string.h>
#include <process.h>

#include "dload.h"

dlm_main(char far *history)
  {
    char     *dlmname3 = "DEMODLM3";             // Name of the third .DLM file
    int       handle3;                           // Its handle

    printf("%Fs\n", _fstrcat(history, " DLM2["));// Show: entering DLM2

    if ((handle3 = dlm_load(dlmname3)) < 1)      // Load DEMODLM3.DLM, test: OK?
      {
        printf("!! Failed to load %s.DLM; error code = %d.\n", dlmname3, handle3);
        printf("!! Aborting DEMO1 program.\n");
        exit(-1);
      }

    dlm_execute(handle3, history);               // Do DEMODLM3, passing history

    printf("%Fs\n", _fstrcat(history, " DLM2]"));// Show: exiting DLM2

    return (0);                                  // Return to DEMO1 main pgm
  }

