// Module DEMODLM3 ... belongs to DEMO1
//
// Make this by typing:
//
//    C> nmake DEMODLM3.MAK
//
// ...which will produce the file DEMODLM3.DLM

#include <stdio.h>
#include <string.h>

#include "dload.h"

dlm_main(char far *history)
  {
    char     *dlmname1 = "DEMODLM1";             // Name of the first .DLM file
    char     *dlmname4 = "DEMODLM4";             // Name of the fourth .DLM file
    int       handle1, handle4;                  // Handles for DLM1, DLM4

    printf("%Fs\n", _fstrcat(history, " DLM3["));// Show: entering DLM3

    handle1 = dlm_load(dlmname1);                // (Already loaded, of course,
                                                 // but this gets its handle.)

    dlm_execute(handle1, history);               // Do DLM1, passing history



    printf("%Fs\n", _fstrcat(history, " DLM3[]"));// Show: enter/exit DLM3



    while (dlm_unload(handle1) > 0)              // Sloppy coding example of
                                   ;             // removing DLM1 from memory

    handle4 = dlm_load(dlmname4);                // Load DLM4

    dlm_execute(handle4, history);               // Do DLM4, passing history



    printf("%Fs\n", _fstrcat(history, " DLM3]"));// Show: exiting DLM3

    return(0);                                   // Return to DLM2
  }

