
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991
//     ALL RIGHTS RESERVED
//
// program - flreader.c
// purpose - a dlm to read from a sequential text file.
// author  - don wanless
// history - 4-15-91
//

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <io.h>

# include "demo2.h"

// to set stack size (default  2048)
// char  _DLM_STACK_PLUS_HEAP[] = "DLM_STACK_PLUS_HEAP=4096";

extern int   dlm_main(LPRDCB lprdcb);

//*******************************************************************
// dlm_main - dlm user main function
//
//*******************************************************************
int dlm_main(LPRDCB lprdcb)
  {
    int  rc;
    char buf[256];

    switch (lprdcb->command)
      {
        case RD_OPEN:
          _fstrcpy(buf, lprdcb->name);
          printf("FLREADER (dlm) Opening file '%Fs' for input.\n\n", lprdcb->name);
          lprdcb->fh = (unsigned) fopen(buf, "r");
          rc = lprdcb->fh;
          break;

        case RD_READ:
          if (fgets(buf, 256, (FILE *) lprdcb->fh))
            {
              buf[strlen(buf) - 1] = 0;
              _fstrcpy(lprdcb->buf, buf);
              lprdcb->rc = 1;
            }
          else
            lprdcb->rc = 0;
          rc = lprdcb->rc;
          break;

        case RD_CLOSE:
          printf("\nFLREADER (dlm) Closing input file '%Fs'.\n\n", lprdcb->name);
          fclose((FILE *) lprdcb->fh);
          lprdcb->fh = 0;
          rc = 0;
          break;

        default:
          rc = -1;
          break;
      }

    return(rc);
  }

//*******************************************************************
