
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991
//     ALL RIGHTS RESERVED
//
// program - flwriter.c
// purpose - a dlm to read from a sequential text file.
// author  - don wanless
// history - 4-15-91
//

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <io.h>

# include "demo2.h"

// to set stack size (default  2048)
// char  _DLM_STACK_PLUS_HEAP[] = "DLM_STACK_PLUS_HEAP=4096";

extern int   dlm_main(LPWRCB lpwrcb);

//*******************************************************************
// dlm_main - dlm user main function
//
//*******************************************************************
int dlm_main(LPWRCB lpwrcb)
  {
    int  rc;
    char buf[256];

    switch (lpwrcb->command)
      {
        case WR_OPEN:
          _fstrcpy(buf, lpwrcb->name);
          printf("FLWRITER (dlm) Opening file '%Fs' for output.\n\n", lpwrcb->name);
          lpwrcb->fh = (unsigned) fopen(buf, "w");
          rc = lpwrcb->fh;
          break;

        case WR_WRITE:
          _fstrcpy(buf, lpwrcb->buf);
          strcat(buf, "\n");
          fputs(buf, (FILE *) lpwrcb->fh);
          lpwrcb->rc = 1;
          rc = lpwrcb->rc;
          break;

        case WR_CLOSE:
          printf("FLWRITER (dlm) Closing output file '%Fs'\n\n", lpwrcb->name);
          fclose((FILE *) lpwrcb->fh);
          lpwrcb->fh = 0;
          rc = 0;
          break;

        default:
          rc = -1;
          break;
      }

    return(rc);
  }

//*******************************************************************
