
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991
//     ALL RIGHTS RESERVED
//
// program - kbreader.c
// purpose - a dlm to read from a sequential text file.
// author  - don wanless
// history - 4-15-91
//

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <conio.h>

# include "demo2.h"

// to set stack size (default  2048)
// char  _DLM_STACK_PLUS_HEAP[] = "DLM_STACK_PLUS_HEAP=4096";

extern int   dlm_main(LPRDCB lprdcb);

//*******************************************************************
// dlm_main - dlm user main function
//
//*******************************************************************
int dlm_main(LPRDCB lprdcb)
  {
    static int linect;

    int   rc;
    char  buf[256];
    char *cp;
    int   ic;

    switch (lprdcb->command)
      {
        case RD_OPEN:
          lprdcb->fh = 1;
          printf("KBREADER (dlm) Type [<Ctrl>Z] to terminate your input.\n");
          linect = 0;
          rc = lprdcb->fh;
          break;

        case RD_READ:
          if (lprdcb->fh)
            {
              linect++;
              printf("KBREADER (dlm) %04d: ", linect);

              *buf = 0;
              cp = buf;

              while (1)
                {
                  if (kbhit())
                    {
                      ic = getch();

                      if (ic == 0x1a)
                        {
                          putch('\r');
                          putch('\n');

                          lprdcb->rc = 0;
                          break;
                        }
                      else if (!ic)
                        {
                          ic = getch();
                        }
                      else
                        {
                          if (ic == '\r')
                            {
                              putch('\r');
                              putch('\n');

                              lprdcb->rc = 1;
                              break;
                            }

                          putch(ic);
                          *cp++ = (char) ic;
                        }
                    }
                }

              *cp = 0;
              _fstrcpy(lprdcb->buf, buf);

              rc = lprdcb->rc;
            }
          else
            lprdcb->rc = 0;

          rc = lprdcb->rc;
          break;

        case RD_CLOSE:
          printf("KBREADER (dlm) Input terminated.\n\n");
          lprdcb->fh = 0;
          rc = 0;
          break;

        default:
          lprdcb->fh = -1;
          rc = -1;
          break;
      }

    return(rc);
  }

//*******************************************************************
