
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991
//     ALL RIGHTS RESERVED
//
// program - scwriter.c
// purpose - a dlm to write to the screen.
// author  - don wanless
// history - 4-15-91
//

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <io.h>

# include "demo2.h"

// to set stack size (default  2048)
// char  _DLM_STACK_PLUS_HEAP[] = "DLM_STACK_PLUS_HEAP=4096";

extern int   dlm_main(LPWRCB lpwrcb);

//*******************************************************************
// dlm_main - dlm user main function
//
//*******************************************************************
int dlm_main(LPWRCB lpwrcb)
  {
    static int linect;

    int  rc;
    char buf[256];

    switch (lpwrcb->command)
      {
        case WR_OPEN:
          lpwrcb->fh = 1;
          printf("SCWRITER (dlm) Opening display screen for writing.\n\n");
          linect = 0;
          rc = lpwrcb->fh;
          break;

        case WR_WRITE:
          if (lpwrcb->fh)
            {
              _fstrcpy(buf, lpwrcb->buf);
              linect++;
              printf("SCWRITER (dlm) %04d: %s\n", linect, buf);
              lpwrcb->rc = 1;
            }
          else
            lpwrcb->rc = 0;

          rc = lpwrcb->rc;
          break;

        case WR_CLOSE:
          lpwrcb->fh = 0;
          printf("SCWRITER (dlm) Closing display screen.\n\n");
          rc = 0;
          break;

        default:
          rc = -1;
          break;
      }

    return(rc);
  }

//*******************************************************************
