/* ExtMath.h */

#ifndef __EXTMATH
#define __EXTMATH
#define u_long unsigned long

/* Macros */
#define NeededForDec(n)  (((u_long)(n) * 487  + 454) / 455)
#define BitsForDigits(n) (((u_long)(n) * 2136 + 642) / 643)

/* ASM functions */
void   ExtZero(u_long far *X, int nx);
int    ExtInc(u_long far *X, int nx);
int    ExtDec(u_long far *X, int nx);
void   ExtMov(u_long far *X, int nx, u_long far *Y, int ny);
void   ExtMovUp(u_long far *X, int nx, u_long far *Y, int ny);
void   ExtSwap(u_long far *X, u_long far *Y, int n);
int    ExtNZLen(u_long far *X, int nx);
int    ExtNeg(int Carryin, u_long far *X, int nx);
int    ExtAdd(int Carryin,  u_long far *X, int nx, u_long far *Y, int ny);
int    ExtSub(int Borrowin, u_long far *X, int nx, u_long far *Y, int ny);
int    ExtAddToNeg(int Borrowin, u_long far *X, int nx, u_long far *Y, int ny);
u_long ExtMul1(u_long Carryin, u_long X, u_long far *Y, int ny);
u_long ExtMulMod1(u_long X, u_long Y, u_long M);
u_long ExtDiv1(u_long Carryin, u_long X, u_long far *Y, int ny);
u_long ExtMod1(u_long Carryin, u_long X, u_long far *Y, int ny);
u_long ExtShiftL(u_long Carryin, int NShift, u_long far *Y, int ny);
u_long ExtShiftR(u_long Carryin, int NShift, u_long far *Y, int ny);
int    ExtCmp(u_long far *X, int nx, u_long far *Y, int ny);
void   ExtMulA(u_long far *X, int nx, u_long far *Y, int ny, u_long far *Z);
int    ExtMulAddA(u_long far *X, int nx, u_long far *Y, int ny, u_long far *Z);
void   ExtToDecA(u_long far *X, int nx);

/* C functions */
u_long far *ExtMAlloc(int N);
u_long far *ExtReAlloc(u_long far *X, int N);
void   ExtMul(u_long far *X, int nx, u_long far *Y, int ny,
              u_long far *Z, int nz);
int    ExtMulAdd(u_long far *X, int nx, u_long far *Y, int ny,
                 u_long far *Z, int nz);
void   ExtDiv(u_long far *X, int nx, u_long far *Y, int ny); 
void   ExtMulMod(u_long far *X, int nx, u_long *Y, int ny,
                 u_long far *Mod, int nm, u_long *Z);
void   ExtPowerMod(u_long far *X, int nx, u_long far *P, int np,
                   u_long far *Mod, int nm, u_long far *Z);
int    ExtGCD(u_long far *X, int nx, u_long far *Y, int ny, u_long far *GCD);
int    ExtInverse(u_long far *X, int nx, u_long far *Mod, int nm,
                  u_long far *Inverse);
void   ExtRandom(u_long far *X, int nx);
void   ExtRandomSeed(u_long far *X, int nx);
void   ExtToDec(u_long far *X, int nx);

/* Address of user error routine */
extern void (far *ExtMathErrorFunc)(int ierr, char *Msg);

/* Multiply method */
extern int ExtMulMethod;

/* Random generation method */
extern int ExtFastRandom;
#endif