;
; asm header file for fixfloat funcs
;

extern rand32_                  : proc near
extern randpowint_              : proc near
extern randinter_               : proc near

extern ffsmul_                  : proc near
extern ffmul_                   : proc near
extern ffsdiv_                  : proc near
extern ffdiv_                   : proc near
extern ffsin_                   : proc near
extern ffcos_                   : proc near
extern ffasin_                  : proc near
extern ffacos_                  : proc near
extern fftan_                   : proc near
extern ffatan_                  : proc near
extern ff_vec_to_ang_           : proc near
extern fflog2_                  : proc near
extern ffexp2_                  : proc near
extern ffpow_                   : proc near
extern ffsqrt_                  : proc near
extern ffhyp_                   : proc near
extern fftrihyp_                : proc near
extern ffmuldiv_                : proc near
extern ffmmd_                   : proc near
extern ffortproj_               : proc near
extern ffortproj1_              : proc near
extern ffdot_through_hyps_      : proc near
extern ffalmosthyp_             : proc near

extern ff_double_div_           : proc near
extern ff_double_shift_         : proc near

extern isqrt_                   : proc near



; below macros are to replace routine calls
; from assembly

; for multiplies one factor is placed in EAX
; the other one passed as an argument

; for divides the dividend (above line) is
; placed in EAX, the divisor (below line) is
; passed as an argument. NOTE Dont use EDX as
; divisor since eax is expanded into edx 
; before dividing.

; Note these divides does no div by 0 checking
; and might raise exceptions

; all foru of these macros modify EDX


MFFSMUL     MACRO      MULTIPLIER

    imul    MULTIPLIER
    shrd    eax,edx,16

ENDM

MFFMUL      MACRO      MULTIPLIER

    mul     MULTIPLIER
    shrd    eax,edx,16

ENDM

MFFSDIV     MACRO      DIVISOR

    cdq
    shld    edx,eax,16
    shl     eax,16
    idiv    DIVISOR
    
ENDM

MFFDIV      MACRO      DIVISOR

    mov     edx,eax
    shl     eax,16
    shr     edx,16
    div     DIVISOR
    
ENDM

















