/* Glue to help port gnu make to extended DOS using Watcom C compiler */

#include "make.h"
#include <process.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_DIRECTORIES 200

typedef struct base_s
{
	char *base_name;	/* base  string or null pointer */
	char cur_letter;	/* current letter (0,a,b.c...z) */
} base_t;

#define MAX_BASES 10
#define MAX_BASE_LENGTH

int findbase(base_t *bases, char * base)
{
	int i;

	for (i = 0; bases[i].base_name; i++);
	{
		if (strcmp(bases[i].base_name, base) == 0)
		{
			return(i);	/* return index of matching slot */
		}
	}
	return(i);	/* return index of empty slot */
}


char *mktemp(char *template)
{
	static int first = 1;
	static base_t bases[MAX_BASES+1];
	static char base[MAX_BASE_LENGTH+1];

	int i,j;



	i = strlen(template);


	if ((i < 6) || (i > (MAX_BASE_LENGTH + 6)))
	{
		return (0); /* template badly formed */
	}


	strcpy (base,(char *) (&template + i - 6)); /* copy possible "XXXXXX" */

	if (!strcmp(base,"XXXXXX"))
	{
		return (0); /* template badly formed */
	}

	if (first)	/* init bases if first time */
	{
		first = 0;

		for (i = 0; i < MAX_BASES+1; i++)
		{
			bases[i].base_name = 0;
			bases[i].cur_letter = '0';	/* first letter */
		}
	}
	
	/* compute the base */
	strncpy (base, template, strlen(template) - 6);


	i = findbase(bases, base);	/* has this base been used before? */

	if ((i == -1) || (i == MAX_BASES))
	{
		return(0);	/* overflow */
	}

	if (!bases[i].base_name)	/* slot empty ? */
	{
		/* YES, Initialize it */
		bases[i].base_name = strdup(base);
	}
	else if (bases[i].cur_letter++ == '0') /* 0,a,b,c... z */
	{
		bases[i].cur_letter = 'a';
	}
	strcpy(template, base);
	strcat(template, "0");
	sprintf((char *) (&template + strlen(template)),"%05d",getpid);

	/* compute the position of the character that changes */
	j =  strlen (bases[i].base_name);

	/* finish the new name */
	template[j] = bases[i].cur_letter;

	return(template);	/* return a pointer to the name */
}

/* dummy kill routine - kill has no meaning in a single task environment */
int kill(int pid, int sig)
{
	return(0); /* kill has no meaning in a dos environment */
}

int wait(int *statloc)
{
	return (0);
}
/* dummy pipe routine - pipe has no meaning in a single task environment */
int pipe(int fields[2])
{
#ifdef DEBUG
	printf("Pipe called with fields = 0x%x and 0x%x\n", fields[0],
		fields[1]);
#endif
	return(-1); /* pipe has no meaning in a dos environment */
}

int vfork(void)
{
	/* can not be simulated in a dos environment */
	fprintf(stderr, "vfork can not be simulated in a MSDOS environment!\n");
	return(-1);
}

int execve(const char *pathname, char *const argv[], char *const env[])
{
	printf("execve: %s\n",pathname);
	return(spawnvpe(P_WAIT, pathname, argv, NULL));
}

int getloadavg(double loadavg[], int nelem)
{
	errno = 0;
	return(0);	/* not implimented */
}

int geteuid(void)
{
	return(getpid());
}

int getegid(void)
{
	return(getpid());
}
int my_stat(const char *path, struct stat *buf)
{
	int hash = 0;
	int i;
	char *full_path, *p;
	static int count = 0; /* count of list members */
	static char **list = 0;

	if (!list)
	{
		/* create storage for list of diroctory names */
		list = (char **) xmalloc((MAX_DIRECTORIES + 1) * sizeof( char *));
		count = 0;
	}

	if (stat (path, buf) != 0)
	{
		return (-1);
	}
	full_path = xmalloc(PATH_MAX+1);
	if (!_fullpath(full_path, path, PATH_MAX))
	{
		return(-1);
	}

	for (i = 0;  i < count; i++)
	{
		if (!strcmp(full_path, list[i]))
		{
			/* found a match */
			break;
		}
	}
	if (i == count)
	{
		/* no match put new name in list */
		list[i] = xmalloc(strlen(full_path) + 1);
		strcpy(list[i],full_path);
		count++;
	}

	buf->st_ino = i; /* st_ino is index to string (full_path) */

	free (full_path);
	return(0);
}
