/*****************************************************************************
 
  Program: KWTREE.C
  
  Purpose: List all of the directories on current disk drive
  
  Date: 08-25-1993
  
  Author: Karl Weller [74620,2112]
          (216)-397-9949
          
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

char bars[] = "|/-\\";
int addcount=0;

char *do_malloc(unsigned);
void add_entry(char *name);

char *dirptr[8000];
int dircnt=0;
int dirpos=0;

int main(int argc, char *argv[],char *envp[])
{
    char filespec[400];
    char *tmp;
    register int i,j;
    struct find_t find;
    
    
    dirptr[0] = do_malloc(10);

  /* change to     "c:\\" for listing a specific drive */
    strcpy(dirptr[0],"\\"); 

  /* Give credit where credit is due <g>! */ 
    fprintf(stderr,"Karl's Directory Tree Lister v1.0\nThis program lists all the directories on the current drive\nWritten by: Karl Weller [74620,2112] 08-25-1993 (Press ESC to Exit)\n\n");
    fprintf(stderr,"Reading....%c",bars[addcount++%4]);

  /*
     This is the main loop, loop through each directory looking for additional
     directories.   This would be a great program to use recursion, but I
     don't have the guts!  < oh, well no glory >
     
     (The last statement will probably nag me until I rewrite the loop to be 
      recursive)
  */
    while(dirpos<=dircnt) {
        if (dircnt>7995) { /* only allocated 8000 pointers see declaration
                              for dirptr */
            printf("Too many directories!\n");
            exit(0);
        }
        strcpy(filespec,dirptr[dirpos]); /* copy the base directory to the */
        strcat(filespec,"*.*");          /* file spec. */
        if (kbhit()) {
            if (getch()==27) {
                fprintf(stderr,"***Escape Hit***\n");
                goto exit;
            }
        }
        if( !_dos_findfirst( filespec, 0xffff, &find ) ) {
            if (find.attrib & _A_SUBDIR) {
                add_entry(find.name); /* Found new dir, add to list */
            }
            while( !_dos_findnext( &find ) ) {
                if (find.attrib & _A_SUBDIR) {
                    add_entry(find.name); /* Found new dir, add to list */
                }
            }
        }
        ++dirpos;
    }

    fprintf(stderr,"\nSorting...");
    for(i=0;i<=dircnt-1;++i) {
        for(j=i+1;j<=dircnt;++j) {
            if (strcmp(dirptr[j],dirptr[i]) < 0) {
                tmp = dirptr[i];
                dirptr[i] = dirptr[j];
                dirptr[j] = tmp;
            }
        }
    }

    fprintf(stderr,"\n");
    for(i=0;i<=dircnt;++i) {          /* Display the tree ! */
        printf("%s\n",dirptr[i]);
        free(dirptr[i]);
    }
exit:
    return(0);
}

/*****************************************************************************
 Malloc w/ error checking.
 
 Die if no memory available
*****************************************************************************/
char *do_malloc(unsigned size)
{
    char *ptr;
    
    ptr = (char *)malloc(size);
    if (ptr == NULL) {
        fprintf(stderr,"\nInsufficient memory for malloc\n");
        exit(-1);
    }
    return(ptr);
}

/*****************************************************************************
 Add a directory to the list
*****************************************************************************/
void add_entry(char *name)
{
    fprintf(stderr,"%c%c",(char)8,bars[addcount++%4]);

    if (*name != '.') { /* if it's a dot listing skip */
        ++dircnt;
        dirptr[dircnt] = do_malloc(4+strlen(name)+strlen(dirptr[dirpos]));
        sprintf(dirptr[dircnt],"%s%s\\",dirptr[dirpos],name);
    }
}
