/*non base e logarithms*/
/*  By Thomas Wakeman  */
/* all rights reserved */

#include <math.h>

#ifndef __cplusplus
#error Must use C++ compiler.
#endif

#ifndef _LOGRTHM_H
#define _LOGRTHM_H  //prevent multiple inclusions

//functions

inline float logrthm(int B, int N) {return (log(N)/log(B));}
inline float logrthm(float B , int N) {return (log(N)/log(B));}
inline double logrthm(double B, int N) {return (log(N)/log(B));}
inline long double logrthm(long double B, int N) {return (logl(N)/log(B));}

inline float logrthm(int B, float N) {return (log(N)/log(B));}
inline float logrthm(float B, float N) {return (log(N)/log(B));}
inline double logrthm(double B, float N) {return (log(N)/log(B));};
inline long double logrthm(long double B, float N) {return (logl(N)/log(B));};

inline double logrthm(int B, double N) {return (log(N)/log(B));}
inline double logrthm(float B, double N) {return (log(N)/log(B));}
inline double logrthm(double B, double N) {return (log(N)/log(B));}
inline long double logrthm(long double B, double N) {return (logl(N)/log(B));}

inline long double logrthm(int B, long double N) {return (log(N)/logl(B));};
inline long double logrthm(float B, long double N) {return (log(N)/logl(B));}
inline long double logrthm(double B, long double N) {return (log(N)/logl(B));}
inline long double logrthm(long double B, long double N) {return (logl(N)/logl(B));}

#ifdef __COMPLEX_H //complex number functions
inline complex logrthm(int B, complex N) {return (log(N)/log(B));}
inline complex logrthm(float B, complex N) {return (log(N)/log(B));}
inline complex logrthm(double B, complex N) {return (log(N)/log(B));}
inline complex logrthm(long double B, complex N) {return (log(N)/logl(B));}

inline complex logrthm(complex B, int N) {return (log(N)/log(B));}
inline complex logrthm(complex B, float N) {return (log(N)/log(B));}
inline complex logrthm(complex B, double N) {return (log(N)/log(B));}
inline complex logrthm(complex B, long double N) {return (logl(N)/log(B));}

inline complex logrthm(complex B, complex N) {return (log(N)/log(B));}
#endif

#endif





