#include "malloc.h"
#include "accum.h"
#include "anci.h"

char *init_accum()
{
	ACCUM *a;

	a = NEW(ACCUM);
	check_malloc(a);
	a->used = 0;
	a->have = 8;
	a->buf = malloc(8);
	check_malloc(a->buf);
	return((char *)a);
}

accum_char(A,c)
char *A;
#define a ((ACCUM *)A)
char c;
{
	while (a->used >= a->have)
	{
		a->buf = realloc(a->buf,a->have+=8);
		check_malloc(a->buf);
	}
	a->buf[a->used++] = c;
}
#undef a

char accum_regret(A)
char *A;
#define a ((ACCUM *)A)
{
	if (a->used > 0)
	{
		return(a->buf[--a->used]);
	}
	else
	{
		return(0);
	}
}
#undef a

char *accum_result(A)
char *A;
#define a ((ACCUM *)A)
{
	char *cp;

	cp = realloc(a->buf,a->used+1);
	check_malloc(cp);
	cp[a->used] = '\0';
	OLD(a);
	return(cp);
}
#undef a

char *accum_sofar(A)
char *A;
#define a ((ACCUM *)A)
{
	char *cp;

	cp = malloc(a->used+1);
	check_malloc(cp);
	bcopy(a->buf,cp,a->used);
	cp[a->used] = '\0';
	return(cp);
}
#undef a

char *accum_buf(A)
char *A;
#define a ((ACCUM *)A)
{
	return(a->buf);
}
#undef a

int accum_howfar(A)
char *A;
#define a ((ACCUM *)A)
{
	return(a->used);
}
#undef a
