


cpp(1)                    User Commands                    cpp(1)



NAME
     cpp - the C language preprocessor

SYNOPSIS
     /usr/ccs/lib/cpp [ -CMP ] [ -undef ] [ -D_n_a_m_e ]
          [ -D_n_a_m_e=_d_e_f ] [ -I_d_i_r_e_c_t_o_r_y ] [ -U_n_a_m_e ]
          [ _i_n_p_u_t-_f_i_l_e [ _o_u_t_p_u_t-_f_i_l_e ] ]

DESCRIPTION
     cpp is the C language preprocessor.  It is  invoked  as  the
     first pass of any C compilation started with the cc(1B) com-
     mand; however, cpp can also be used as a first-pass  prepro-
     cessor for other Sun compilers.

     Although cpp can be used as a macro processor, this  is  not
     normally  recommended,  as  its output is geared toward that
     which would be acceptable as input to  a  compiler's  second
     pass.   Thus, the preferred way to invoke cpp is through the
     cc(1B) command, or  some  other  compilation  command.   For
     general-purpose macro-processing, see m4(1), and the chapter
     on m4 in _S_u_n_O_S _5._3 _P_r_o_g_r_a_m_m_i_n_g _U_t_i_l_i_t_i_e_s.

     cpp optionally accepts two filenames as  arguments.   _i_n_p_u_t-
     _f_i_l_e and _o_u_t_p_u_t-_f_i_l_e are, respectively, the input and output
     files for the preprocessor.  They default  to  the  standard
     input and the standard output.

    C++ comment  indicator  `//' is not supported.

OPTIONS

     -C    Pass all comments (except those  that  appear  on  cpp
          directive lines) through the preprocessor.  By default,
          cpp strips out C-style comments.

     -M    Generate a list of  makefile  dependencies  and  write
          them  to the standard output.  This list indicates that
          the object file which would be generated from the input
          file  depends  on the input file as well as the include
          files referenced.

     -P    Preprocess the input without producing the  line  con-
          trol  information  used  by  the  next  pass  of  the C



     Last change: 5 Jul 1990                    1






cpp(1)                    User Commands                    cpp(1)



          compiler.


     -undef
          Remove initial definitions for all predefined symbols.

     -D_n_a_m_e
          Define _n_a_m_e as 1 (one). This is the same  as  if  a   -
          D_n_a_m_e=1  option appeared on the cpp command line, or as
          if a

               #define _n_a_m_e 1

          line appeared in the source file that cpp  is  process-
          ing.


     -D_n_a_m_e=_d_e_f
          Define _n_a_m_e as if by a #define directive.  This is  the
          same as if a

               #define _n_a_m_e def

          line appeared in the source file that cpp  is  process-
          ing.   The   -D option has lower precedence than the -U
          option.  That is, if the same name is used in both a -U
          option  and  a   - D option, the name will be undefined
          regardless of the order of the options.

     -I_d_i_r_e_c_t_o_r_y
          Insert _d_i_r_e_c_t_o_r_y into  the  search  path  for  #include
          files  with names not beginning with `/'.  _d_i_r_e_c_t_o_r_y is
          inserted ahead of  the  standard  list  of  ``include''
          directories.   Thus, #include files with names enclosed
          in double-quotes (") are  searched  for  first  in  the
          directory  of  the file with the #include line, then in
          directories named with  - I  options,  and  lastly,  in
          directories from the standard list.  For #include files
          with names enclosed in angle-brackets (<>), the  direc-
          tory  of  the  file  with  the  #include  line  is  not
          searched.  See Details below for exact details of  this
          search order.

     -U_n_a_m_e
          Remove any initial definition of _n_a_m_e, where _n_a_m_e is  a
          symbol that is predefined by a particular preprocessor.



     Last change: 5 Jul 1990                    2






cpp(1)                    User Commands                    cpp(1)



USAGE
  Directives
     All cpp directives start with a hash symbol (#) as the first
     character  on a line.  White space (SPACE or TAB characters)
     can appear after the initial # for proper indentation.

     #define _n_a_m_e _t_o_k_e_n-_s_t_r_i_n_g
          Replace subsequent instances of _n_a_m_e with _t_o_k_e_n-_s_t_r_i_n_g.

     #define _n_a_m_e(_a_r_g_u_m_e_n_t [, _a_r_g_u_m_e_n_t] ...  ) _t_o_k_e_n-_s_t_r_i_n_g
          There can  be  no  space  between  _n_a_m_e  and  the  `('.
          Replace  subsequent  instances  of  _n_a_m_e, followed by a
          parenthesized list  of  arguments,  with  _t_o_k_e_n-_s_t_r_i_n_g,
          where  each  occurrence  of  an  _a_r_g_u_m_e_n_t in the _t_o_k_e_n-
          _s_t_r_i_n_g is replaced by the corresponding  token  in  the
          comma-separated  list.   When a macro with arguments is
          expanded, the arguments are placed  into  the  expanded
          _t_o_k_e_n-_s_t_r_i_n_g  unchanged.  After the entire _t_o_k_e_n-_s_t_r_i_n_g
          has been expanded, cpp re-starts its scan for names  to
          expand  at  the  beginning  of the newly created _t_o_k_e_n-
          _s_t_r_i_n_g.

     #undef _n_a_m_e
          Remove any definition for the symbol  _n_a_m_e.   No  addi-
          tional tokens are permitted on the directive line after
          _n_a_m_e.

     #include "_f_i_l_e_n_a_m_e"
     #include <_f_i_l_e_n_a_m_e>
          Read in the contents  of  _f_i_l_e_n_a_m_e  at  this  location.
          This data is processed by cpp as if it were part of the
          current file.  When the <_f_i_l_e_n_a_m_e>  notation  is  used,
          _f_i_l_e_n_a_m_e   is   only   searched  for  in  the  standard



     Last change: 5 Jul 1990                    3






cpp(1)                    User Commands                    cpp(1)



          ``include'' directories.  See the -I and   - Y  options
          above  for  more detail.  No additional tokens are per-
          mitted on the directive line after  the  final  `"'  or
          `>'.

     #line _i_n_t_e_g_e_r-_c_o_n_s_t_a_n_t "_f_i_l_e_n_a_m_e"
          Generate line control information for the next pass  of
          the C compiler.  _i_n_t_e_g_e_r-_c_o_n_s_t_a_n_t is interpreted as the
          line number of the next line  and  _f_i_l_e_n_a_m_e  is  inter-
          preted  as the file from where it comes.  If "_f_i_l_e_n_a_m_e"
          is not given, the current filename  is  unchanged.   No
          additional  tokens  are permitted on the directive line
          after the optional _f_i_l_e_n_a_m_e.

     #if _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n
          Subsequent lines up to the matching #else, #elif  ,  or
          #endif   directive,   appear  in  the  output  only  if
          _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n yields a nonzero value.  All binary
          non-assignment  C  operators, including `&&', `||', and
          `,',  are  legal  in  _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n.   The   `?:'
          operator,  and  the  unary `-', `!', and `~' operators,
          are also legal in _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n.

          The precedence of these operators is the same  as  that
          for C.  In addition, the unary operator defined, can be
          used  in  _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n  in  these   two   forms:
          `defined  ( _n_a_m_e )' or `defined _n_a_m_e'.  This allows the
          effect of  #ifdef  and  #ifndef  directives  (described
          below)  in  the  #if  directive.  Only these operators,
          integer constants, and names  that  are  known  by  cpp
          should be used within _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n.  In particu-
          lar, the size of operator is not available.

     #ifdef _n_a_m_e
          Subsequent lines up to the matching  #else,  #elif,  or
          #endif  appear  in  the  output  only  if _n_a_m_e has been
          defined, either with a  #define  directive  or  a   - D
          option,  and  in  the  absence of an intervening #undef
          directive.  No additional tokens are permitted  on  the
          directive line after _n_a_m_e.

     #ifndef _n_a_m_e
          Subsequent lines up to the matching  #else,  #elif,  or
          #endif  appear  in the output only if _n_a_m_e has _n_o_t been
          defined, or if its definition has been removed with  an
          #undef  directive.   No additional tokens are permitted
          on the directive line after _n_a_m_e .

     #elif _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n
          Any number of #elif directives may  appear  between  an
          #if,  #ifdef, or #ifndef directive and a matching #else
          or #endif directive.  The  lines  following  the  #elif



     Last change: 5 Jul 1990                    4






cpp(1)                    User Commands                    cpp(1)



          directive  appear in the output only if all of the fol-
          lowing conditions hold:

               +o   The _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n in the  preceding  #if
                  directive  evaluated  to  zero, the _n_a_m_e in the
                  preceding #ifdef is not defined, or the _n_a_m_e in
                  the preceding #ifndef directive _w_a_s defined.
               +o   The  _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n  in  all  intervening
                  #elif directives evaluated to zero.
               +o   The current _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n  evaluates  to
                  non-zero.

          If the _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n evaluates to non-zero,  sub-
          sequent  #elif  and  #else directives are ignored up to
          the matching #endif.  Any  _c_o_n_s_t_a_n_t-_e_x_p_r_e_s_s_i_o_n  allowed
          in an #if directive is allowed in an #elif directive.

     #else
          This inverts the sense  of  the  conditional  directive
          otherwise  in  effect.   If  the  preceding conditional
          would indicate that lines  are  to  be  included,  then
          lines  between  the  #else  and the matching #endif are
          ignored.  If the preceding conditional  indicates  that
          lines  would  be ignored, subsequent lines are included
          in the output.  Conditional directives and  correspond-
          ing #else directives can be nested.

     #endif
          End a section of lines begun by one of the  conditional
          directives  #if,  #ifdef, or #ifndef.  Each such direc-
          tive must have a matching #endif.

  Macros
     Formal parameters  for  macros  are  recognized  in  #define
     directive bodies, even when they occur inside character con-
     stants and quoted strings.  For instance, the output from:
          #define abc(a) |`|a|
          abc(xyz)

     is the seven characters `` |` xyz|''  (SPACE,  vertical-bar,
     backquote,  x,  y,  z,  vertical-bar).   Macro names are not
     recognized within character constants or quoted strings dur-
     ing the regular scan.  Thus:
          #define abc xyz
          printf("abc");

     does not expand abc in the second line, since it is inside a
     quoted  string  that  is not part of a #define macro defini-
     tion.

     Macros are  not  expanded  while  processing  a  #define  or
     #undef.  Thus:



     Last change: 5 Jul 1990                    5






cpp(1)                    User Commands                    cpp(1)



          #define abc zingo
          #define xyz abc
          #undef abc
          xyz

     produces abc.  The  token  appearing  immediately  after  an
     #ifdef or #ifndef is not expanded.

     Macros are not expanded during the scan which determines the
     actual parameters to another macro call.  Thus:
          #define reverse(first,second)second first
          #define greeting hello
          reverse(greeting,
          #define greeting goodbye
          )

     produces `` #define hello goodbye  hello''.

  Output
     Output consists of a copy of the input file, with  modifica-
     tions, plus lines of the form:

          #_l_i_n_e_n_o " _f_i_l_e_n_a_m_e" "_l_e_v_e_l"

     indicating the original source line number and  filename  of
     the following output line and whether this is the first such
     line after an include file has been entered  (_l_e_v_e_l=1),  the
     first  such  line  after  an  include  file  has been exited
     (_l_e_v_e_l=2), or any other such line (_l_e_v_e_l is empty).

  Details
  _D_i_r_e_c_t_o_r_y _S_e_a_r_c_h _O_r_d_e_r
     #include files are searched for in the following order:

          1.  The  directory  of  the  file  that  contains   the
              #include  request (that is, #include is relative to
              the file being scanned when the request is made).

          2.  The directories specified by -I options,  in  left-
              to-right order.

          3.  The standard  directory(s)  (/usr/include  on  UNIX
              systems).

  _S_p_e_c_i_a_l _N_a_m_e_s
     Two special names are understood by cpp.  The name  __LINE__
     is defined as the current line number (a decimal integer) as
     known by  cpp,  and  __FILE__  is  defined  as  the  current
     filename  (a  C  string)  as known by cpp.  They can be used
     anywhere (including in macros) just  as  any  other  defined
     name.




     Last change: 5 Jul 1990                    6






cpp(1)                    User Commands                    cpp(1)



  _N_e_w_l_i_n_e _C_h_a_r_a_c_t_e_r_s
     A NEWLINE  character  terminates  a  character  constant  or
     quoted  string.   An  escaped  NEWLINE (that is, a backslash
     immediately followed by a NEWLINE) may be used in  the  body
     of  a  #define statement to continue the definition onto the
     next line.  The escaped NEWLINE is not included in the macro
     value.

  _C_o_m_m_e_n_t_s
     Comments are removed (unless the -C option is  used  on  the
     command  line).   Comments  are  also ignored, except that a
     comment terminates a token.

SEE ALSO
     cc(1B), m4(1)

     _S_u_n_O_S _5._3 _P_r_o_g_r_a_m_m_i_n_g _U_t_i_l_i_t_i_e_s

DIAGNOSTICS
     The error messages produced by cpp are intended to be  self-
     explanatory.   The  line number and filename where the error
     occurred are printed along with the diagnostic.

NOTES
     When NEWLINE characters were found  in  argument  lists  for
     macros to be expanded, some previous versions of cpp put out
     the NEWLINE characters as they were found and expanded.  The
     current version of cpp replaces them with SPACE characters.

     Because the standard directory for  included  files  may  be
     different  in  different environments, this form of #include
     directive:

          #include <file.h>

     should be used, rather than one with an absolute path, like:

          #include "/usr/include/file.h"

     cpp warns about the use of the absolute pathname.

     While the compiler allows 8-bit strings and comments, 8-bits
     are not allowed anywhere else.












     Last change: 5 Jul 1990                    7



