#include "malloc.h"
#include "is.h"
#include "io.h"
#include "accum.h"
#include "symtbl.h"
#include "stats.h"
#include "anci.h"

#ifndef rindex
char *rindex();
#endif

int nIfiles;
char **Ifiles;

init_include()
{
	nIfiles = 0;
	Ifiles = (char **) malloc(0);
	check_malloc(Ifiles);
}

Ifile(f)
char *f;
{
	Ifiles = (char **) realloc((char *)Ifiles,(nIfiles+1)*sizeof(char *));
	check_malloc(Ifiles);
	Ifiles[nIfiles] = copyofstr(f);
	check_malloc(Ifiles[nIfiles]);
	nIfiles ++;
}

do_include(sharp)
int sharp;
{
	char c;
	char *acc;

	if (in_false_if())
	{
		if (sharp)
		{
			flush_sharp_line();
		}
		return;
	}
	while (1)
	{
		c = getnonspace();
		if (isbsymchar(c))
		{
			char *cp;
			DEF *d;
			cp = init_accum();
			while (issymchar(c))
			{
				accum_char(cp,c);
				c = Get();
			}
			Push(c);
			cp = accum_result(cp);
			d = find_def(cp);
			if (d)
			{
				expand_def(d);
				n_hits ++;
			}
			else
			{
				char *dp;
				for (dp=cp+strlen(cp);dp>cp;dp--) Push(*dp);
				n_misses ++;
			}
		}
		else
		{
			break;
		}
	}
	acc = init_accum();
	if (c == '"')
	{
		while (1)
		{
			c = Get();
			if (c == '\n')
			{
				Push('\n');
				c = '"';
				err_head();
				fprintf(stderr,"warning: unterminated %cinclude filename\n",
									      sharp?'#':'@');
			}
			if (c == '"')
			{
				break;
			}
			accum_char(acc,c);
		}
		if (sharp)
		{
			flush_sharp_line();
		}
		read_include_file(accum_result(acc),1,sharp);
	}
	else if (c == '<')
	{
		while (1)
		{
			c = Get();
			if (c == '\n')
			{
				Push('\n');
				c = '>';
				err_head();
				fprintf(stderr,"warning: unterminated %cinclude filename\n",
									      sharp?'#':'@');
			}
			if (c == '>')
			{
				break;
			}
			accum_char(acc,c);
		}
		if (sharp)
		{
			flush_sharp_line();
		}
		read_include_file(accum_result(acc),0,sharp);
	}
	else
	{
		free(accum_result(acc));
		err_head();
		fprintf(stderr,"illegal %cinclude filename delimiter\n",sharp?'#':'@');
	}
}

read_include_file(name,dohere,sharp)
char *name;
int dohere;
int sharp;
{
	FILE *f;
	char *n;
	char temp[1024];
	char *cp;
	extern int incldep;
	extern char *incldep_o;


	f = NULL;
	if (dohere)
	{
		if ((strcmp(curdir(),".") != 0) && (name[0] != '\\'))
		{
			sprintf(temp,"%s\\%s",curdir(),name);
			n = temp;
		}
		else
		{
			n = name;
		}
		f = fopen(n,"r");
	}
	if (f == NULL)
	{
		if (name[0] == '\\')
		{
			f = fopen(name,"r");
			n = name;
		}
		else
		{
			int i;
			n = temp;
			for (i=0;i<nIfiles;i++)
			{
				sprintf(temp,"%s\\%s",Ifiles[i],name);

				f = fopen(temp,"r");
				if (f != NULL)
				{
					break;
				}
			}
		}
	}
	if (f == NULL)
	{
		err_head();
		fprintf(stderr,"can't find include file %s\n",name);
		free(name);
		return;
	}
	if (incldep)
	{
		printf("%s: %s\n",incldep_o,n);
	}
	out_at(!sharp,n);
	autodef_file(n);
	autodef_line(1);
	Push('\n');
	Get();
	push_new_file(n,f);
	cp = rindex(n,'\\');
	if (cp)
	{
		*cp = '\0';
		cp = copyofstr(n);
	}
	else
	{
		cp = copyofstr(".");
	}
	check_malloc(cp);
	*Curdir() = cp;
	free(name);
	return;
}
