#include "symtbl.h"
#include "malloc.h"
#include "io.h"

do_set()
{
	char *mac;
	char c;
	char temp[64];

	mac = read_ident();
	if (! mac)
	{
		err_head();
		fprintf(stderr,"@set: missing/illegal macro name\n");
		return;
	}
	if (! in_false_if())
	{
		char *cp;
		c = getnonspace();
		if (c != '(')
		{
			err_head();
			fprintf(stderr,"@set must have ()s\n");
			Push(c);
			return;
		}
		sprintf(temp,"%d",eval_expr(0,1));
		undef(mac);
		cp = copyofstr(temp);
		check_malloc(cp);
		define(mac,-1,cp,DEF_DEFINE);
	}
	free(mac);
}
