/*
 * Diskette head cleaner
 *
 * For use with cleaning disks.
 * Moves the disk head back and forth across the entire cleaning disk.
 *
 * Copyright 1991-1996 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc scrub -fop
 */
#include <stdio.h>

int drive, cylinders, step = 10;

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;

	if(argc < 3)
		abort("Use: scrub <drive> <cylinders> [step]");
	if(((drive = toupper(argv[1][0])-'A') >= 2) || (argv[1][1] != ':'))
		abort("Invalid floppy drive id");
	cylinders = atoi(argv[2]);
	if(argc > 3)
		step = atoi(argv[3]);

	for(j=0; j < 5; ++j) {
		seek(drive, 1);
		for(i = step; i < cylinders; i += step) {
			seek(drive, i);
			seek(drive, i - (step/2)); } }
}

/*
 * Seek to cylinder on drive
 */
seek(drive, track) asm
{
		MOV		DL,6[BP]	; Get drive ID
		XOR		AH,AH		; Funct zero
		INT		13h			; Reset disk
		MOV		CH,4[BP]	; Get cylinder
		MOV		AX,0401h	; Verify funct, 1 sector
		MOV		CL,AL		; Begin with sector 1
		XOR		DH,DH		; Head 0
		INT		13h			; Seek to cylinder
}
