/*
 * Reads one or more files, and displays the number of lines, and the
 * total size of the file in bytes.
 *
 * Demonstrates setting up and using a two byte counter, which is used
 * to keep track of the total number of characters. Up to 655350000
 * characters can be counted.
 *
 * Copyright 1991-1996 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc size -fop
 */
#include <stdio.h>

unsigned tlines = 0, tcharh = 0, tcharl = 0;

/*
 * Convert a double word number to an ASCII string
 */
char *dtoa(high, low)
	unsigned high, low;
{
	static char dtoabuf[10];

	if(high)
		sprintf(dtoabuf,"%u%04u", high, low);
	else
		sprintf(dtoabuf,"%u", low);

	return dtoabuf;
}

/*
 * Main program, determine size of files
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i;
	FILE *fp;

	if(argc == 1)
		dosize(stdin,"<stdin>");
	else {
		for(i=1; i < argc; ++i)
			if(fp = fopen(argv[i],"rvb")) {
				dosize(fp,argv[i]);
				fclose(fp); } }
	if(argc > 2)
		printf("\nTotal of %s characters, %u lines.\n", dtoa(tcharh, tcharl), tlines);
}

/*
 * Process an individual file & determine its size
 */
dosize(fp, name)
	FILE *fp;
	char *name;
{
	unsigned lines, charh, charl, chr;

	lines = charh = charl = 0;
	while((chr = getc(fp)) != -1) {
		if(++charl >= 10000) {
			++charh;
			charl -= 10000; }
		if(chr == '\n')
			++lines; }
	tlines += lines;
	if((tcharl += charl) >= 10000) {
		++tcharh;
		tcharl -= 10000; }
	tcharh += charh;
	printf("%12s characters,%5u lines in file: '%s'\n", dtoa(charh, charl), lines, name);
}
