#include <stdio.h>
#include <conio.h>
#include <dos.h>



/* for the mouse-state */
typedef struct
{
	int bLeft;
	int bMiddle;
	int bRight;
	int nHor;
	int nVer;
}t_Mouse;




int InitMouse(void);
void ResetMouse(void);
void ShowMouse(void);
void HideMouse(void);
void LimitMouseHor(int min,int max);
void LimitMouseVer(int min,int max);
void GetMouseState(t_Mouse  *tState);



void main( void )
{
	t_Mouse MouseStateOld,MouseStateNew ;
	int c;
	InitMouse();
	ShowMouse();
	MouseStateOld = MouseStateNew ;
	printf("Normal:\n");
	do
	{
		GetMouseState(&MouseStateNew);
		if ( 	( MouseStateNew.nHor    != MouseStateOld.nHor )    ||
				( MouseStateNew.nVer    != MouseStateOld.nVer )    ||
				( MouseStateNew.bLeft   != MouseStateOld.bLeft )   ||
				( MouseStateNew.bMiddle != MouseStateOld.bMiddle ) ||
				( MouseStateNew.bRight  != MouseStateOld.bRight ) )
		{
			printf("Hor: %03d Ver: %03d Left: %d Middle: %d  Right: %d\r",
					MouseStateNew.nHor,MouseStateNew.nVer,
					MouseStateNew.bLeft, MouseStateNew.bMiddle, MouseStateNew.bRight);
			MouseStateOld = MouseStateNew;
		}
	}
	while ( !kbhit() );
	(void) getch();
	printf("\nLimited Hor 50 - 100 \n");
	LimitMouseHor(50,100);
	do
	{
		GetMouseState(&MouseStateNew);
		if ( 	( MouseStateNew.nHor    != MouseStateOld.nHor )    ||
				( MouseStateNew.nVer    != MouseStateOld.nVer )    ||
				( MouseStateNew.bLeft   != MouseStateOld.bLeft )   ||
				( MouseStateNew.bMiddle != MouseStateOld.bMiddle ) ||
				( MouseStateNew.bRight  != MouseStateOld.bRight ) )
		{
			printf("Hor: %03d Ver: %03d Left: %d Middle: %d  Right: %d\r",
					MouseStateNew.nHor,MouseStateNew.nVer,
					MouseStateNew.bLeft, MouseStateNew.bMiddle, MouseStateNew.bRight);
			MouseStateOld = MouseStateNew;
		}
	}
	while ( !kbhit() );
	(void) getch();
	printf("\nLimited Ver 50 - 100 \n");
	LimitMouseVer(50,100);
	do
	{
		GetMouseState(&MouseStateNew);
		if ( 	( MouseStateNew.nHor    != MouseStateOld.nHor )    ||
				( MouseStateNew.nVer    != MouseStateOld.nVer )    ||
				( MouseStateNew.bLeft   != MouseStateOld.bLeft )   ||
				( MouseStateNew.bMiddle != MouseStateOld.bMiddle ) ||
				( MouseStateNew.bRight  != MouseStateOld.bRight ) )
		{
			printf("Hor: %03d Ver: %03d Left: %d Middle: %d  Right: %d\r",
					MouseStateNew.nHor,MouseStateNew.nVer,
					MouseStateNew.bLeft, MouseStateNew.bMiddle, MouseStateNew.bRight);
			MouseStateOld = MouseStateNew;
		}
	}
	while ( !kbhit() );

	HideMouse();
}




/*********************************/
/* Mouse - Functions             */
/*********************************/

/*
Inp.:
		AX = 0000h
Return: AX = status
		0000h hardware/driver not installed
		FFFFh hardware/driver installed
		BX = number of buttons
		0000h other than two
		0002h two buttons (many drivers)
		0003h Mouse Systems/Logitech three-button mouse
		FFFFh two buttons
*/

int InitMouse(void)
{
	union REGS inregs;
	union REGS outregs;
	inregs.x.ax = 0;
	int86( 0x33, &inregs, &outregs);
	if( outregs.x.ax == 0000 )
	{
		return -1;
	}
	else
	{
		return( outregs.x.bx );
	}
}

void ResetMouse(void)
{
	union REGS inregs;
	inregs.x.ax = 0x21;
	int86( 0x33, &inregs, &inregs );
}

void ShowMouse(void)
{
	union REGS inregs;
	inregs.x.ax = 01;
	int86( 0x33, &inregs, &inregs);
}

void HideMouse(void)
{
	union REGS inregs;
	inregs.x.ax = 02;
	int86( 0x33, &inregs, &inregs);
}

void LimitMouseHor(int nMin,int nMax)
{
	union REGS inregs;
	inregs.x.ax = 07;
	inregs.x.cx = nMin;
	inregs.x.dx = nMax;
	int86( 0x33, &inregs, &inregs);
}
void LimitMouseVer(int nMin,int nMax)
{
	union REGS inregs;
	inregs.x.ax = 0x08;
	inregs.x.cx = nMin;
	inregs.x.dx = nMax;
	int86( 0x33, &inregs, &inregs );
}

void GetMouseState(t_Mouse *tState)
{
	union REGS inregs;

	inregs.x.ax = 0x03;
	int86( 0x33, &inregs, &inregs );
	tState->nVer    =   inregs.x.dx;
	tState->nHor    =   inregs.x.cx;
	tState->bLeft   = ( inregs.x.bx >> 0 ) & 1;
	tState->bRight  = ( inregs.x.bx >> 1 ) & 1;
	tState->bMiddle = ( inregs.x.bx >> 2 ) & 1;
}





