/* DEMO1.C  - MicroThread demonstration written by I H Ting

  This example demonstrates basic multi-threading. Three threads
  are created; one outputting 300 'A's at priority 5,
  another outputting 300 'B's at priority 3,
  and another outputting 300 'C's at priority 1.
*/

#include "mthread.h"

void ThreadA(void)
{
  int i;

  MTputs("\nThread A started\n");
  for(i=0; i<300; i++){
    MTputchar('A');
  }
  MTputs("\nThread A finished\n");
}

void ThreadB(void)
{
  int i;

  MTputs("\nThread B started\n");
  for(i=0; i<300; i++){
    MTputchar('B');
  }
  MTputs("\nThread B finished\n");
}

void ThreadC(void)
{
  int i;

  MTputs("\nThread C started\n");
  for(i=0; i<300; i++){
    MTputchar('C');
  }
  MTputs("\nThread C finished\n");
}


void main(void)
{
  MTInitialise();

  MTputs("\nMicroThread demonstration\nAdding threads...");
  MTAddThread(ThreadA, 5);
  MTAddThread(ThreadB, 3);
  MTAddThread(ThreadC, 1);

  MTputs("\nStarting multithreading...");

  MTStartMultiThreading();

  MTputs("\nMultithreading ended");
}
