/* DEMO3.C  - MicroThread demonstration written by I H Ting

  This example demonstrates background file copying.
  The user is prompted for source and destination filenames
  that a new thread is started to perform the actual file copying
  in the background whilst the prompt returns. Multiple file copying
  sessions can be started, one after another and they will all be done
  simultaneously.
*/

#include "mthread.h"

struct twoFiles{
  char sourceFile[128], destFile[128];
};

#define COPY_BLOCK_SIZE 512

/* The file copying thread function */
void CopyFiles(struct twoFiles *pArg)
{
  FILE * fpSource, *fpDest;
  size_t nBytes;
  char buffer[COPY_BLOCK_SIZE];

  fpSource=MTfopen(pArg->sourceFile, "rb");
  if (fpSource==NULL) return;
  fpDest=MTfopen(pArg->destFile, "wb");
  if (fpDest==NULL){
    MTfclose(fpSource);
    return;
  }
  while(1){
    nBytes=MTfread(buffer,1,COPY_BLOCK_SIZE, fpSource);
    MTfwrite(buffer,1,nBytes, fpDest);
    if(MTfeof(fpSource))break;
  }
  MTfclose(fpSource);
  MTfclose(fpDest);
}


/* User prompt routine */
void PromptLoop(void)
{
  char sourceFile[128],destFile[128];

  struct twoFiles arg;

  while(1){
    MTputs("\nSource filename>");
    MTgets(sourceFile);
    if(sourceFile[0]==NULL){
      MTputs("\nEnding demonstration...");
      return;
    }
    MTputs("\nDestination filename>");
    MTgets(destFile);
    if(destFile[0]==NULL){
      MTputs("\nEnding demonstration...");
      return;
    }
      MTstrcpy(arg.sourceFile, sourceFile);
      MTstrcpy(arg.destFile, destFile);
      MTAddArgThread(CopyFiles, 1, sizeof(arg),&arg);
  }
}


void main(void)
{
  MTprintf("MicroThread Demonstration.\nBackground file copying.");
  MTprintf("\nEnter the source and destination filenames when prompted.");
  MTprintf("\nA new thread will be started in the background for each file.");
  MTprintf("\nTo end simply enter a blank filename (carriage return).");
  MTInitialise();
  MTAddThread(PromptLoop,5);
  MTStartMultiThreading();
  MTputs("done.");
}


