/* DEMO4.C  - MicroThread demonstration written by I H Ting

  This example demonstrates mailboxes and inter-thread messaging.
  A mailbox is created and several thread are created to send and
  receive message to and from the mailbox.
*/

#include "mthread.h"


unsigned msgsSnd=0;

void Receiver(void)
{
  char buffer[40];
  unsigned mbx,i;
  mbx = MTGetMailboxHandle("TestMailBox");
  if(mbx){
    for (i=0; i < 70; i++){
      MTSleep(MTrandom(20));
      MTprintf("\nReceiving message...");
      MTReceiveMsg(mbx,40,buffer);
      MTprintf("\nReceived message: %s.",buffer);
    }
  }
  MTEndMultiThreading();
}


void Sender(void)
{
  unsigned mbx, i;
  char buffer[40];
  mbx = MTGetMailboxHandle("TestMailBox");
  if(mbx){
    for (i=0; i < 70; i++){
      MTsprintf(buffer,"This is message number %u",msgsSnd);
      MTprintf("\nSending message: %s",buffer);
      MTSendMsg(mbx,40,buffer);
      msgsSnd++;
      MTprintf("\nMessage sent");
    }
  }
  MTEndMultiThreading();
}


void TestMessages(void)
{
  unsigned mbx;

  MTInitialise();
  mbx = MTCreateMailbox("TestMailBox");
  if (mbx){
    MTAddThread(Receiver,1);
    MTAddThread(Receiver,1);
    MTAddThread(Sender,5);
    MTAddThread(Sender,5);
    MTAddThread(Sender,5);
    MTAddThread(Sender,5);
  }
  MTStartMultiThreading();
}


void main(void)
{
  TestMessages();
}


