/* This is a minimal demonstration of the use of the MTask */
/* multitasking kernel.  3 tasks are created: One to print */
/* the character 'A' continous, another to print 'B', and  */
/* a third to wait for the 'q' key to be pressed - to stop */
/* the multitasking.                                       */


#include <stdio.h>
#include <stdlib.h>
#include "mtask.h"   /* This header file must be included. */

char Data=0;
unsigned semaphore=0;

void Sender(void)
{
  char ch;
  while(1){
    while(Data);
    ch = MTGetch();
    MTPrintf("Sender: sending character %c.\n",ch);
    MTWait(&semaphore);
    Data = ch;
    MTSignal(&semaphore);
    if (ch =='q') 
      EndMultiTasking();
  }
}



void Receiver(void)
{
  char ch;
  while(1){
    if (Data != 0){
      MTWait(&semaphore);
      ch=Data;
      Data=0;
      MTSignal(&semaphore);
      MTPrintf("Receiver: receiving %c.\n",ch);
    }
    delay(200);
  }
}





/* the main program */
void main(void)
{
  /* The multitasking kernel has to be initialised */
  InitMultiTasking();

  AddTask( Sender);
  AddTask( Receiver);

  puts("Multitasking starting...\n");

  StartMultiTasking();

  puts("\nMultitasking ended.");
}


