/* MicroThread V2.5

  A minimal Borland/Turbo C multithreading library for DOS program.
  Written and placed into the public domain by I H Ting. Please read
  the files README.TXT and MTHREAD.TXT for more information.

  Comments and suggestions to :

      Internet Email : i.h.ting@wlv.ac.uk

      Compuserve     : 100023,3363

      Otherwise      : I H Ting
                       University of Wolverhampton
                       School of Computing & I. T.
                       Wulfruna Street
                       Wolverhampton WV1 1SB
                       U.K.
*/

/* MTCRTLIB.C - Semaphored replacements for some of the C runtime
   library functions to prevent re-entrancy problem. This is obviously
   not a complete list, as I have only done the ones that I needed.
   However, it is straight-forward to add your own functions.
*/


#define MTCRTLIB_C
#include "stdio.h"
#include "stdarg.h"
#include "stdlib.h"
#include "conio.h"
#include "mthread.h"

extern Semaphore semaCRunTimeLib;

int MTfprintf (FILE *stream, const char *format, ...)
{
  va_list argptr;
  int cnt;
  char buffer[512];

  MTWait(semaCRunTimeLib);
  va_start(argptr, format);
  cnt = vsprintf(buffer, format, argptr);
  va_end(argptr);
  fprintf(stream,buffer);
  MTSignal(semaCRunTimeLib);
  return(cnt);
}

int MTprintf (const char *format, ...)
{
  va_list argptr;
  int cnt;
  char buffer[512];

  MTWait(semaCRunTimeLib);
  va_start(argptr, format);
  cnt = vsprintf(buffer, format, argptr);
  va_end(argptr);
  puts(buffer);
  MTSignal(semaCRunTimeLib);
  return(cnt);
}


int MTfputs(const char *s, FILE *stream)
{
  int retval;

  MTWait(semaCRunTimeLib);
  retval = fputs(s,stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTfputc(int c, FILE *stream)
{
  int retval;

  MTWait(semaCRunTimeLib);
  retval = fputc(c,stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


FILE *MTfopen(const char *filename, const char *mode)
{
  FILE *retval;

  MTWait(semaCRunTimeLib);
  retval = fopen(filename, mode);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTfclose(FILE *stream)
{
  int retval;

  MTWait(semaCRunTimeLib);
  retval = fclose(stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTfeof(FILE *stream)
{
  int retval;

  MTWait(semaCRunTimeLib);
  retval = feof(stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}



int MTsprintf (char *buffer, const char *format, ...)
{
  va_list argptr;
  int cnt;

  MTWait(semaCRunTimeLib);
  va_start(argptr, format);
  cnt = vsprintf(buffer, format, argptr);
  va_end(argptr);
  MTSignal(semaCRunTimeLib);
  return(cnt);
}


char *MTfgets(char *s, int n, FILE *stream)
{
  char *retval=NULL;

  MTWait(semaCRunTimeLib);
  retval = fgets(s, n, stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTfgetc(FILE *stream)
{
  int retval=NULL;

  MTWait(semaCRunTimeLib);
  retval = fgetc(stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}




int MTxyputc(int x, int y, int c)
{
  int retval,lastx,lasty;

  MTWait(semaCRunTimeLib);
  lastx=wherex();
  lasty=wherey();
  gotoxy(x,y);
  retval = putch(c);
  gotoxy(lastx,lasty);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTxyputs(int x, int y, const char *s)
{
  int retval,lastx,lasty;

  MTWait(semaCRunTimeLib);
  lastx=wherex();
  lasty=wherey();
  gotoxy(x,y);
  retval = cputs(s);
  gotoxy(lastx,lasty);
  MTSignal(semaCRunTimeLib);
  return(retval);
}



int MTxyprintf (int x, int y, const char *format, ...)
{
  va_list argptr;
  int cnt,lastx,lasty;
  static char buffer[512];

  MTWait(semaCRunTimeLib);
  va_start(argptr, format);
  cnt = vsprintf(buffer, format, argptr);
  va_end(argptr);
  lastx=wherex();
  lasty=wherey();
  gotoxy(x,y);
  cputs(buffer);
  gotoxy(lastx,lasty);
  MTSignal(semaCRunTimeLib);
  return(cnt);
}


int MTkbhit(void)
{
  int retval;

  MTWait(semaCRunTimeLib);
  retval = kbhit();
  MTSignal(semaCRunTimeLib);
  return(retval);
}


int MTgetch(void)
{
  int retval=0;

  MTWait(semaCRunTimeLib);
  if (kbhit())
    retval =getch();
  MTSignal(semaCRunTimeLib);
  return(retval);
}



int MTrandom(int num)
{
  int retval;
  MTWait(semaCRunTimeLib);
  retval =random(num);
  MTSignal(semaCRunTimeLib);
  return(retval);
}

void MTclrscr(void)
{
  MTWait(semaCRunTimeLib);
  clrscr();
  MTSignal(semaCRunTimeLib);
}


char * MTgets(char *buf)
{
  char *ps=buf,theChar;

  while(1){
    MTWait(semaCRunTimeLib);
    theChar=0;
    if (kbhit()){
      theChar=getch();
    }
    MTSignal(semaCRunTimeLib);
    if(theChar=='\b'){
      if(ps!=buf){
        ps--;
        MTfputs("\b \b",stdout);
      }
    }
    else if (theChar=='\n'||theChar=='\r'){
      *ps='\0';
     return buf;
    }
    else if (theChar){
      MTfputc(theChar,stdout);
      *ps=theChar;
      ps++;
    }
  }
}



void *MTmalloc(size_t size)
{
  void *retval;

  MTWait(semaCRunTimeLib);
  retval = malloc(size);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


void MTfree(void *block)
{
  MTWait(semaCRunTimeLib);
  free(block);
  MTSignal(semaCRunTimeLib);
}




char *MTstrcpy(char *dest,char *source)
{
  char *pSource=source, *pDest=dest;

  while(*pSource){
    *pDest++ = *pSource++;
  }
  *pDest='\0';
  return(dest);
}


size_t MTfread(void *ptr, size_t size, size_t n, FILE *stream)
{
  size_t retval=0;

  MTWait(semaCRunTimeLib);
  retval = fread(ptr, size, n, stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}


size_t MTfwrite(const void *ptr, size_t size, size_t n, FILE*stream)
{
  size_t retval=0;

  MTWait(semaCRunTimeLib);
  retval = fwrite(ptr, size, n, stream);
  MTSignal(semaCRunTimeLib);
  return(retval);
}
