/* Copyright (C) 1992 Peter Edward Cann */

#include<stdio.h>
#include<dos.h>
#include<process.h>
#include<graph.h>
#include<time.h>

#define MAXTIMES 1024

long times[MAXTIMES];

int ntimes;

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, topind, curind, flag;
	char str[16], c;
	long tmptime;
	struct tm *tptr;
	struct find_t buf;
	printf("FAXMANIP Copyright (C) 1992 Peter Edward Cann\n");
	if(_dos_findfirst("*.rfx", _A_NORMAL, &buf))
		{
		printf("No .rfx files found in current directory.\n");
		exit(1);
		}
	ntimes=0;
	if(sscanf(buf.name, "%lx", &times[ntimes++])!=1)
		ntimes--;
	while(!_dos_findnext(&buf))
		{
		if(sscanf(buf.name, "%lx", &times[ntimes++])!=1)
			ntimes--;
		if(ntimes>=MAXTIMES)
			break;
		}
	for(i=0;i<ntimes;++i)
		for(j=i+1;j<ntimes;++j)
			if(times[i]<times[j])
				{
				tmptime=times[i];
				times[i]=times[j];
				times[j]=tmptime;
				}
	topind=curind=0;
	while(1)
		{
		_settextwindow(1,1,1,80);
		_settextcolor(0);
		_setbkcolor((long)7);
		_clearscreen(_GWINDOW);
		printf("              n=next   p=previous   c=convert   d=delete   q=quit");
		_settextwindow(2,1,25,80);
		_settextcolor(7);
		_setbkcolor((long)0);
		_clearscreen(_GWINDOW);
		for(i=0;(i<24)&&(i<(ntimes-topind));++i)
			{
			tptr=localtime(&times[topind+i]);
			_settextposition(i+1, 1);
			printf("%02d.%02d.%02d @ %02d:%02d:%02d",
				tptr->tm_year,
				(tptr->tm_mon)+1,
				tptr->tm_mday,
				tptr->tm_hour,
				tptr->tm_min,
				tptr->tm_sec
				);
			}
		flag=1;
		while((curind-topind<24)&&(curind>=topind)&&flag)
			{
			_settextposition(curind-topind+1, 21);
			switch(getch())
				{
				case 'n':
				case 'N':
					if(curind>=(ntimes-1))
						putch(0x07);
					else
						curind++;
					break;
				case 'p':
				case 'P':
					if(curind==0)
						putch(0x07);
					else
						curind--;
					break;
				case 'q':
				case 'Q':
					_settextposition(24, 1);
					exit(0);
					break;
				case 'd':
				case 'D':
					printf("Really delete? (Y/N) --> ");
					c=getch();
					if((c!='Y')&&(c!='y'))
						{
						_settextposition(curind-topind+1, 21);
						printf("\t\t\t\t");
						break;
						}
					sprintf(str, "%08lx.rfx", times[curind]);
					unlink(str);
					--ntimes;
					if(!ntimes)
						{
						_settextposition(24,1);
						printf("\nNo more faxes.\n");
						exit(0);
						}
					for(i=curind;i<ntimes;++i)
						times[i]=times[i+1];
					if(curind==ntimes)
						curind--;
					flag=0;
					break;
				case 'c':
				case 'C':
					_settextposition(24,1);
					printf("\nSpawning RFXTOPCX...\n");
					sprintf(str, "%08lx.rfx", times[curind]);
					if(argc==2)
						spawnlp(P_WAIT, "rfxtopcx", "rfxtopcx", str, "/debug", NULL);
					else
						spawnlp(P_WAIT, "rfxtopcx", "rfxtopcx", str, NULL);
					printf("\nPress any key to resume faxmanip: --> ");
					getch();
					flag=0;
					break;
				case 'e':
				case 'E':
					if(argc!=2)
						{
						putch(0x07);
						break;
						}
					_settextposition(24,1);
					printf("\nCalling editor...\n");
					sprintf(str, "%s %08lx.rfx", argv[1], times[curind]);
					system(str);
					printf("\nPress any key to resume faxmanip: --> ");
					getch();
					flag=0;
					break;
				default:
					putch(0x07);
					break;
				}
			}
		if(curind>12)
			topind=curind-12;
		else
			topind=0;
		}
	}
