/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 *	MicroSoft QuickC
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include<process.h>
#include<time.h>
#include"port.h"

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)))
		if(kbhit())
			getch();
	outp(basereg, c);
	}

int follow;

quit()
	{
	cleanup(0);
	exit(99);
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		if(str[i]=='\n')
			{
			sendchar('\r');
			sendchar('\n');
			}
		else
			sendchar(str[i]);
	}

portgets(str)
	char *str;
	{
	int i;
	i=0;
	while(i<255)
		{
		while(follow==index)
			{
			if(!(inp(basereg+MSTATREG)&DCDMASK))
				return(-1);
			if(kbhit())
				getch();
			}
		str[i]=buf[follow++];
		follow%=TBUFSIZ;
		if(str[i]=='\b')
			if(i>0)
				{
				i-=2;
				sendchar('\b');
				sendchar(' ');
				sendchar('\b');
				}
			else
				{
				i--;
				sendchar(0x07);
				}
		else
			sendchar(str[i]);
		if((str[i]=='\r')||(str[i]=='\n'))
			{
			sendchar('\r');
			sendchar('\n');
			str[i]='\0';
			break;
			}
		i++;
		}
	str[255]='\0';
	return(0);
	}
		
main(argc, argv)
	int argc;
	char **argv;
	{
	FILE *fd;
	long timestamp;
	struct tm *tstructptr;
	int i, j, outfd, ok, c, run, result, maxlines;
	char str[256];
	index=follow=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be already logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run MESSIN? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("I didn't think so!\n");
			exit(99);
			}
		else
			printf("OK, you're the boss!");
		}
	printf("Control-C to Exit.\n");
	if(argc!=6)
		{
		printf("USAGE: messin <comnum> <bps> <file> <max file bytes> <max message lines>\n");
		exit(10);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	setup();
	signal(SIGINT, quit);
	if((fd=fopen(argv[3], "a"))==NULL)
		{
		sprintf(str, "Sorry, can't open the file.\n");
		sendstr(str);
		printf("Error opening MESSIN file.\n");
		exit(11);
		}
	if(filelength(fd)>atol(argv[4]))
		{
		sprintf(str, "Sorry, the file has reached its limit.\n");
		sendstr(str);
		exit(12);
		}
	maxlines=atoi(argv[5]);
	sprintf(str, "\nEnter your name: --> ");
	sendstr(str);
	timestamp=time(NULL);
	tstructptr=localtime(&timestamp);
	if(portgets(str)==-1)
		{
		printf("Lost carrier detect.\n");
		exit(13);
		}
	fprintf(fd, "\nFROM: %s\nDATE: %02d.%02d.%02d/%02d:%02d\n", str,
		tstructptr->tm_year,
		(tstructptr->tm_mon)+1,
		tstructptr->tm_mday,
		tstructptr->tm_hour,
		tstructptr->tm_min);
	printf("Message comming in from %s:\n", str);
	sprintf(str, "End message with a line containing only period (.).\n\n");
	sendstr(str);
	i=0;
	while(portgets(str)!=-1)
		{
		if((strlen(str)==1)&&(str[0]=='.'))
			exit(0);
		printf("%s\n", str);
		fprintf(fd, "%s\n", str);
		if(i==(maxlines-5))
			{
			sprintf(str, "*** %d LINES REMAIN BEFORE LIMIT IS REACHED ***\n", maxlines-i);
			sendstr(str);
			}
		if(i>=maxlines)
			{
			sprintf(str, "*** LENGTH LIMIT REACHED ***\n");
			sendstr(str);
			exit(14);
			}
		}
	exit(0);
	}
