/* Copyright (C) 1992 Peter Edward Cann */

#include<stdio.h>
#include<fcntl.h>
#include<time.h>
#include"port.h"

#define NSCANS 4

unsigned char scans[NSCANS][16]=
	{
	"+FCON\r\n",
	"OK\r\n",
	"CONNECT\r\n",
	"+FHNG"
	};

int scani[NSCANS];

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)))
		if(kbhit())
			getch();
	outp(basereg, c);
	}

int follow;

quit()
	{
	cleanup(0);
	exit(99);
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		sendchar(str[i]);
	}

FILE *fd;

int scan(seconds)
	int seconds;
	{
	long timestamp;
	int i, j;
	timestamp=time(NULL);
	for(i=0;i<NSCANS;++i)
		scani[i]=0;
	while(1)
		{
		while(follow==index)
			{
			if(kbhit())
				getch();
			if((time(NULL)-timestamp)>seconds)
				{
				for(j=0;j<NSCANS;j++)
					scani[j]=0;
				return(-1);
				}
			}
		fputc(buf[follow], fd);
		putch(buf[follow]);
		for(i=0;i<NSCANS;i++)
			if(scans[i][scani[i]]==buf[follow])
				{
				scani[i]++;
				if(scans[i][scani[i]]=='\0')
					{
					for(j=0;j<NSCANS;j++)
						scani[j]=0;
					follow++;
					follow%=TBUFSIZ;
					return(i);
					}
				}
			else
				scani[i]=0;
		follow++;
		follow%=TBUFSIZ;
		}
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	long timestamp;
	int flag;
	unsigned char c;
	char fname[256];
	if(argc!=5)
		{
		printf("USAGE: rcvfax <comnum> <initspeed> <afterspeed> <dir>\n");
		exit(98);
		}
	timestamp=time(NULL);
	sprintf(fname, "%s\\%08lx.rfx", argv[4], timestamp);
	printf("Opening received fax file %s.\n", fname);
	if((fd=fopen(fname, "w"))==NULL)
		{
		printf("Error opening file %s.\n", fname);
		exit(97);
		}
	setmode(fileno(fd), O_BINARY);
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	follow=index=0;
	setup();
	speed=atoi(argv[3]);
	switch(scan(60))
		{
		case -1:
			cleanup(0);
			printf("Timeout waiting for +FCON.\n");
			fclose(fd);
			unlink(fname);
			exit(1);
			break;
		case 0:
			break;
		case 3:
			cleanup(0);
			printf("Hangup waiting for +FCON.\n");
			fclose(fd);
			unlink(fname);
			exit(1);
			break;
		default:
			cleanup(0);
			printf("Received recognized token other than +FCON.\n");
			fclose(fd);
			unlink(fname);
			exit(2);
			break;
		}
	setport();
	setup();
	switch(scan(30))
		{
		case -1:
			fprintf(fd, "\nTIMEOUT\n");
			cleanup(0);
			printf("Timeout waiting for initial OK.\n");
			exit(3);
			break;
		case 1:
			break;
		case 3:
			scan(15);
			cleanup(0);
			printf("Waiting for initial OK received +FHNG.\n");
			exit(30);
			break;
		default:
			cleanup(0);
			printf("Waiting for initial OK received other recognized token.\n");
			exit(4);
			break;
		}
	while(1)
		{
		/* Loop over pages */
		sendstr("AT+FDR\r");
		switch(scan(60))
			{
			case -1:
				fprintf(fd, "\nTIMEOUT\n");
				cleanup(0);
				printf("Timeout waiting for CONNECT.\n");
				exit(5);
				break;
			case 2:
				break;
			case 3:
				if(scan(15)==1)
					{
					cleanup(0);
					exit(0);
					}
				else
					{
					cleanup(0);
					printf("No OK after FHNG.\n");
					exit(11);
					}
			default:
				cleanup(0);
				printf("Bad stuff after +FDR command.\n");
				exit(6);
				break;
			}
		sendchar(0x11);
		flag=0;
		while(1)
			{
			/* Loop over characters */
			timestamp=time(NULL);
			while(follow==index)
				{
				if(kbhit())
					getch();
				if((time(NULL)-timestamp)>120)
				/*120 seems ridiculous, but 60 didn't do it*/
					{
					cleanup(0);
					fprintf(fd, "\nTIMEOUT\n");
					printf("Data timeout.\n");
					exit(7);
					}
				}
			fputc(buf[follow], fd);
			if(buf[follow]!=0x03)
				flag=0;
			else
				if(flag)
					{
					follow++;
					follow%=TBUFSIZ;
					break;
					}
			if(buf[follow]==0x10)
				flag=1;
			follow++;
			follow%=TBUFSIZ;
			}
		switch(scan(30))
			{
			case -1:
				fprintf(fd, "\nTIMEOUT\n");
				cleanup(0);
				printf("Timeout waiting for post-data OK.\n");
				exit(8);
				break;
			case 1:
				break;
			case 3:
				scan(15);
				printf("Hangup waiting for post-data OK.\n");
				cleanup(0);
				exit(31);
				break;
			default:
				cleanup(0);
				printf("Waiting for post-data OK wrong token.\n");
				exit(9);
				break;
			}
		}
	}
