#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<setjmp.h>

#define MAKEUP 0x1000
#define SEVENOHS 0x1fff

unsigned char curbyte, bitmask;

int rfxfd;

jmp_buf where;

int debug;

int getbit()
        {
        int result;
        if(!bitmask)
                {
                if(!read(rfxfd, &curbyte, 1))
			{
			printf("Premature end of file.\n");
			exit(1);
			}
		if(curbyte==0x10)
			{
			if(!read(rfxfd, &curbyte, 1))
				{
				printf("Premature end of file.\n");
				exit(1);
				}
			if(curbyte==0x03)
				{
				longjmp(where, -1);
				}
			}
                bitmask=0x80;
		if(debug)
			printf("(%02x)", curbyte);
                }
        result=curbyte&bitmask;
        bitmask>>=1;
	bitmask&=0x7f;
	if(debug)
		if(result)
			putchar('1');
		else
			putchar('0');
	return(result);
        }

int getwhite()
        {
        if(getbit())
         /* 1 */
         if(getbit())
          /* 11 */
          if(getbit())
           /* 111 */
           if(getbit())
            /* 1111 */
            return(7);
           else
            /* 1110 */
            return(6);
          else
           /* 110 */
           if(getbit())
            /* 1101 */
            if(getbit())
             /* 11011 */
             return(MAKEUP|64);
            else
             /* 11010 */
             if(getbit())
              /* 110101 */
              return(15);
             else
              /* 110100 */
              return(14);
           else
            /* 1100 */
            return(5);
         else
          /* 10 */
          if(getbit())
           /* 101 */
           if(getbit())
            /* 1011 */
            return(4);
           else
            /* 1010 */
            if(getbit())
             /* 10101 */
             if(getbit())
              /* 101011 */
              return(17);
             else
              /* 101010 */
              return(16);
            else
             /* 10100 */
             return(9);
          else
           /* 100 */
           if(getbit())
            /* 1001 */
            if(getbit())
             /* 10011 */
             return(8);
            else
             /* 10010 */
             return(MAKEUP|128);
           else
            /* 1000 */
            return(3);
        else
         /* 0 */
         if(getbit())
          /* 01 */
          if(getbit())
           /* 011 */
           if(getbit())
            /* 0111 */
            return(2);
           else
            /* 0110 */
            if(getbit())
             /* 01101 */
             if(getbit())
              /* 011011 */
              if(getbit())
               /* 0110111 */
               return(MAKEUP|256);
              else
               /* 0110110 */
               if(getbit())
                /* 01101101 */
                if(getbit())
                 /* 011011011 */
                 return(MAKEUP|1408);
                else
                 /* 011011010 */
                 return(MAKEUP|1344);
               else
                /* 01101100 */
                if(getbit())
                 /* 011011001 */
                 return(MAKEUP|1280);
                else
                 /* 011011000 */
                 return(MAKEUP|1216);
             else
              /* 011010 */
              if(getbit())
               /* 0110101 */
               if(getbit())
                /* 01101011 */
                if(getbit())
                 /* 011010111 */
                 return(MAKEUP|1152);
                else
                 /* 011010110 */
                 return(MAKEUP|1088);
               else
                /* 01101010 */
                if(getbit())
                 /* 011010101 */
                 return(MAKEUP|1024);
                else
                 /* 011010100 */
                 return(MAKEUP|960);
              else
               /* 0110100 */
               if(getbit())
                /* 01101001 */
                if(getbit())
                 /* 011010011 */
                 return(MAKEUP|896);
                else
                 /* 011010010 */
                 return(MAKEUP|832);
               else
                /* 01101000 */
                return(MAKEUP|576);
            else
             /* 01100 */
             if(getbit())
              /* 011001 */
              if(getbit())
               /* 0110011 */
               if(getbit())
                /* 01100111 */
                return(MAKEUP|640);
               else
                /* 01100110 */
                if(getbit())
                 /* 011001101 */
                 return(MAKEUP|768);
                else
                 /* 011001100 */
                 return(MAKEUP|704);
              else
               /* 0110010 */
               if(getbit())
                /* 01100101 */
                return(MAKEUP|512);
               else
                /* 01100100 */
                return(MAKEUP|448);
             else
              /* 011000 */
              return(MAKEUP|1664);
          else
           /* 010 */
           if(getbit())
            /* 0101 */
            if(getbit())
             /* 01011 */
             if(getbit())
              /* 010111 */
              return(MAKEUP|192);
             else
              /* 010110 */
              if(getbit())
               /* 0101101 */
               if(getbit())
                /* 01011011 */
                return(58);
               else
                /* 01011010 */
                return(57);
              else
               /* 0101100 */
               if(getbit())
                /* 01011001 */
                return(56);
               else
                /* 01011000 */
                return(55);
            else
             /* 01010 */
             if(getbit())
              /* 010101 */
              if(getbit())
               /* 0101011 */
               return(25);
              else
               /* 0101010 */
               if(getbit())
                /* 01010101 */
                return(52);
               else
                /* 01010100 */
                return(51);
             else
              /* 010100 */
              if(getbit())
               /* 0101001 */
               if(getbit())
                /* 01010011 */
                return(50);
               else
                /* 01010010 */
                return(49);
              else
               /* 0101000 */
               return(24);
           else
            /* 0100 */
            if(getbit())
             /* 01001 */
             if(getbit())
              /* 010011 */
              if(getbit())
               /* 0100111 */
               return(18);
              else
               /* 0100110 */
               if(getbit())
                /* 01001101 */
                if(getbit())
                 /* 010011011 */
                 return(MAKEUP|1728);
                else
                 /* 010011010 */
                 return(MAKEUP|1600);
               else
                /* 01001100 */
                if(getbit())
                 /* 010011001 */
                 return(MAKEUP|1536);
                else
                 /* 010011000 */
                 return(MAKEUP|1472);
             else
              /* 010010 */
              if(getbit())
               /* 0100101 */
               if(getbit())
                /* 01001011 */
                return(60);
               else
                /* 01001010 */
                return(59);
              else
               /* 0100100 */
               return(27);
            else
             /* 01000 */
             return(11);
         else
          /* 00 */
          if(getbit())
           /* 001 */
           if(getbit())
            /* 0011 */
            if(getbit())
             /* 00111 */
             return(10);
            else
             /* 00110 */
             if(getbit())
              /* 001101 */
              if(getbit())
               /* 0011011 */
               if(getbit())
                /* 00110111 */
                return(MAKEUP|384);
               else
                /* 00110110 */
                return(MAKEUP|320);
              else
               /* 0011010 */
               if(getbit())
                /* 00110101 */
                return(0);
               else
                /* 00110100 */
                return(63);
             else
              /* 001100 */
              if(getbit())
               /* 0011001 */
               if(getbit())
                /* 00110011 */
                return(62);
               else
                /* 00110010 */
                return(61);
              else
               /* 0011000 */
               return(28);
           else
            /* 0010 */
            if(getbit())
             /* 00101 */
             if(getbit())
              /* 001011 */
              if(getbit())
               /* 0010111 */
               return(21);
              else
               /* 0010110 */
               if(getbit())
                /* 00101101 */
                return(44);
               else
                /* 00101100 */
                return(43);
             else
              /* 001010 */
              if(getbit())
               /* 0010101 */
               if(getbit())
                /* 00101011 */
                return(42);
               else
                /* 00101010 */
                return(41);
              else
               /* 0010100 */
               if(getbit())
                /* 00101001 */
                return(40);
               else
                /* 00101000 */
                return(39);
            else
             /* 00100 */
             if(getbit())
              /* 001001 */
              if(getbit())
               /* 0010011 */
               return(26);
              else
               /* 0010010 */
               if(getbit())
                /* 00100101 */
                return(54);
               else
                /* 00100100 */
                return(53);
             else
              /* 001000 */
              return(12);
          else
           /* 000 */
           if(getbit())
            /* 0001 */
            if(getbit())
             /* 00011 */
             if(getbit())
              /* 000111 */
              return(1);
             else
              /* 000110 */
              if(getbit())
               /* 0001101 */
               if(getbit())
                /* 00011011 */
                return(32);
               else
                /* 00011010 */
                return(31);
              else
               /* 0001100 */
               return(19);
            else
             /* 00010 */
             if(getbit())
              /* 000101 */
              if(getbit())
               /* 0001011 */
               if(getbit())
                /* 00010111 */
                return(38);
               else
                /* 00010110 */
                return(37);
              else
               /* 0001010 */
               if(getbit())
                /* 00010101 */
                return(36);
               else
                /* 00010100 */
                return(35);
             else
              /* 000100 */
              if(getbit())
               /* 0001001 */
               if(getbit())
                /* 00010011 */
                return(34);
               else
                /* 00010010 */
                return(33);
              else
               /* 0001000 */
               return(20);
           else
            /* 0000 */
            if(getbit())
             /* 00001 */
             if(getbit())
              /* 000011 */
              return(13);
             else
              /* 000010 */
              if(getbit())
               /* 0000101 */
               if(getbit())
                /* 00001011 */
                return(48);
               else
                /* 00001010 */
                return(47);
              else
               /* 0000100 */
               return(23);
            else
             /* 00000 */
             if(getbit())
              /* 000001 */
              if(getbit())
               /* 0000011 */
               return(22);
              else
               /* 0000010 */
               if(getbit())
                /* 00000101 */
                return(46);
               else
                /* 00000100 */
                return(45);
             else
              /* 000000 */
              if(getbit())
               /* 0000001 */
               if(getbit())
                /* 00000011 */
                return(30);
               else
                /* 00000010 */
                return(29);
              else
               /* 0000000 */
               return(SEVENOHS);
        }

int getblack()
	{
	if(getbit())
         /* 1 */
         if(getbit())
          /* 11 */
          return(2);
         else
          /* 10 */
          return(3);
        else
         /* 0 */
         if(getbit())
          /* 01 */
          if(getbit())
           /* 011 */
           return(4);
          else
           /* 010 */
           return(1);
         else
          /* 00 */
          if(getbit())
           /* 001 */
           if(getbit())
            /* 0011 */
            return(5);
           else
            /* 0010 */
            return(6);
          else
           /* 000 */
           if(getbit())
            /* 0001 */
            if(getbit())
             /* 00011 */
             return(7);
            else
             /* 00010 */
             if(getbit())
              /* 000101 */
              return(8);
             else
              /* 000100 */
              return(9);
           else
            /* 0000 */
            if(getbit())
             /* 00001 */
             if(getbit())
              /* 000011 */
              if(getbit())
               /* 0000111 */
               return(12);
              else
               /* 0000110 */
               if(getbit())
                /* 00001101 */
                if(getbit())
                 /* 000011011 */
                 if(getbit())
                  /* 0000110111 */
                  return(0);
                 else
                  /* 0000110110 */
                  if(getbit())
                   /* 00001101101 */
                   if(getbit())
                    /* 000011011011 */
                    return(43);
                   else
                    /* 000011011010 */
                    return(42);
                  else
                   /* 00001101100 */
                   return(21);
                else
                 /* 000011010 */
                 if(getbit())
                  /* 0000110101 */
                  if(getbit())
                   /* 00001101011 */
                   if(getbit())
                    /* 000011010111 */
                    return(39);
                   else
                    /* 000011010110 */
                    return(38);
                  else
                   /* 00001101010 */
                   if(getbit())
                    /* 000011010101 */
                    return(37);
                   else
                    /* 000011010100 */
                    return(36);
                 else
                  /* 0000110100 */
                  if(getbit())
                   /* 00001101001 */
                   if(getbit())
                    /* 000011010011 */
                    return(35);
                   else
                    /* 000011010010 */
                    return(34);
                  else
                   /* 00001101000 */
                   return(20);
               else
                /* 00001100 */
                if(getbit())
                 /* 000011001 */
                 if(getbit())
                  /* 0000110011 */
                  if(getbit())
                   /* 00001100111 */
                   return(19);
                  else
                   /* 00001100110 */
                   if(getbit())
                    /* 000011001101 */
                    return(29);
                   else
                    /* 000011001100 */
                    return(28);
                 else
                  /* 0000110010 */
                  if(getbit())
                   /* 00001100101 */
                   if(getbit())
                    /* 000011001011 */
                    return(27);
                   else
                    /* 000011001010 */
                    return(26);
                  else
                   /* 00001100100 */
                   if(getbit())
                    /* 000011001001 */
                    return(MAKEUP|192);
                   else
                    /* 000011001000 */
                    return(MAKEUP|128);
                else
                 /* 000011000 */
                 return(15);
             else
              /* 000010 */
              if(getbit())
               /* 0000101 */
               return(11);
              else
               /* 0000100 */
               return(10);
            else
             /* 00000 */
             if(getbit())
              /* 000001 */
              if(getbit())
               /* 0000011 */
               if(getbit())
                /* 00000111 */
                return(14);
               else
                /* 00000110 */
                if(getbit())
                 /* 000001101 */
                 if(getbit())
                  /* 0000011011 */
                  if(getbit())
                   /* 00000110111 */
                   return(22);
                  else
                   /* 00000110110 */
                   if(getbit())
                    /* 000001101101 */
                    return(41);
                   else
                    /* 000001101100 */
                    return(40);
                 else
                  /* 0000011010 */
                  if(getbit())
                   /* 00000110101 */
                   if(getbit())
                    /* 000001101011 */
                    return(33);
                   else
                    /* 000001101010 */
                    return(32);
                  else
                   /* 00000110100 */
                   if(getbit())
                    /* 000001101001 */
                    return(31);
                   else
                    /* 000001101000 */
                    return(30);
                else
                 /* 000001100 */
                 if(getbit())
                  /* 0000011001 */
                  if(getbit())
                   /* 00000110011 */
                   if(getbit())
                    /* 000001100111 */
                    return(63);
                   else
                    /* 000001100110 */
                    return(62);
                  else
                   /* 00000110010 */
                   if(getbit())
                    /* 000001100101 */
                    return(49);
                   else
                    /* 000001100100 */
                    return(48);
                 else
                  /* 0000011000 */
                  return(17);
              else
               /* 0000010 */
               if(getbit())
                /* 00000101 */
                if(getbit())
                 /* 000001011 */
                 if(getbit())
                  /* 0000010111 */
                  return(16);
                 else
                  /* 0000010110 */
                  if(getbit())
                   /* 00000101101 */
                   if(getbit())
                    /* 000001011011 */
                    return(MAKEUP|256);
                   else
                    /* 000001011010 */
                    return(61);
                  else
                   /* 00000101100 */
                   if(getbit())
                    /* 000001011001 */
                    return(58);
                   else
                    /* 000001011000 */
                    return(57);
                else
                 /* 000001010 */
                 if(getbit())
                  /* 0000010101 */
                  if(getbit())
                   /* 00000101011 */
                   if(getbit())
                    /* 000001010111 */
                    return(47);
                   else
                    /* 000001010110 */
                    return(46);
                  else
                   /* 00000101010 */
                   if(getbit())
                    /* 000001010101 */
                    return(45);
                   else
                    /* 000001010100 */
                    return(44);
                 else
                  /* 0000010100 */
                  if(getbit())
                   /* 00000101001 */
                   if(getbit())
                    /* 000001010011 */
                    return(51);
                   else
                    /* 000001010010 */
                    return(50);
                  else
                   /* 00000101000 */
                   return(23);
               else
                /* 00000100 */
                return(13);
             else
              /* 000000 */
              if(getbit())
               /* 0000001 */
               if(getbit())
                /* 00000011 */
                if(getbit())
                 /* 000000111 */
                 if(getbit())
                  /* 0000001111 */
                  return(MAKEUP|64);
                 else
                  /* 0000001110 */
                  if(getbit())
                   /* 00000011101 */
                   if(getbit())
                    /* 000000111011 */
                    if(getbit())
                     /* 0000001110111 */
                     return(MAKEUP|1216);
                    else
                     /* 0000001110110 */
                     return(MAKEUP|1152);
                   else
                    /* 000000111010 */
                    if(getbit())
                     /* 0000001110101 */
                     return(MAKEUP|1088);
                    else
                     /* 0000001110100 */
                     return(MAKEUP|1024);
                  else
                   /* 00000011100 */
                   if(getbit())
                    /* 000000111001 */
                    if(getbit())
                     /* 0000001110011 */
                     return(MAKEUP|960);
                    else
                     /* 0000001110010 */
                     return(MAKEUP|896);
                   else
                    /* 000000111000 */
                    return(54);
                else
                 /* 000000110 */
                 if(getbit())
                  /* 0000001101 */
                  if(getbit())
                   /* 00000011011 */
                   if(getbit())
                    /* 000000110111 */
                    return(53);
                   else
                    /* 000000110110 */
                    if(getbit())
                     /* 0000001101101 */
                     return(MAKEUP|576);
                    else
                     /* 0000001101100 */
                     return(MAKEUP|512);
                  else
                   /* 00000011010 */
                   if(getbit())
                    /* 000000110101 */
                    return(MAKEUP|448);
                   else
                    /* 000000110100 */
                    return(MAKEUP|384);
                 else
                  /* 0000001100 */
                  if(getbit())
                   /* 00000011001 */
                   if(getbit())
                    /* 000000110011 */
                    return(MAKEUP|320);
                   else
                    /* 000000110010 */
                    if(getbit())
                     /* 0000001100101 */
                     return(MAKEUP|1728);
                    else
                     /* 0000001100100 */
                     return(MAKEUP|1664);
                  else
                   /* 00000011000 */
                   return(25);
               else
                /* 00000010 */
                if(getbit())
                 /* 000000101 */
                 if(getbit())
                  /* 0000001011 */
                  if(getbit())
                   /* 00000010111 */
                   return(24);
                  else
                   /* 00000010110 */
                   if(getbit())
                    /* 000000101101 */
                    if(getbit())
                     /* 0000001011011 */
                     return(MAKEUP|1600);
                    else
                     /* 0000001011010 */
                     return(MAKEUP|1536);
                   else
                    /* 000000101100 */
                    return(60);
                 else
                  /* 0000001010 */
                  if(getbit())
                   /* 00000010101 */
                   if(getbit())
                    /* 000000101011 */
                    return(59);
                   else
                    /* 000000101010 */
                    if(getbit())
                     /* 0000001010101 */
                     return(MAKEUP|1472);
                    else
                     /* 0000001010100 */
                     return(MAKEUP|1408);
                  else
                   /* 00000010100 */
                   if(getbit())
                    /* 000000101001 */
                    if(getbit())
                     /* 0000001010011 */
                     return(MAKEUP|1344);
                    else
                     /* 0000001010010 */
                     return(MAKEUP|1280);
                   else
                    /* 000000101000 */
                    return(56);
                else
                 /* 000000100 */
                 if(getbit())
                  /* 0000001001 */
                  if(getbit())
                   /* 00000010011 */
                   if(getbit())
                    /* 000000100111 */
                    return(55);
                   else
                    /* 000000100110 */
                    if(getbit())
                     /* 0000001001101 */
                     return(MAKEUP|832);
                    else
                     /* 0000001001100 */
                     return(MAKEUP|768);
                  else
                   /* 00000010010 */
                   if(getbit())
                    /* 000000100101 */
                    if(getbit())
                     /* 0000001001011 */
                     return(MAKEUP|704);
                    else
                     /* 0000001001010 */
                     return(MAKEUP|640);
                   else
                    /* 000000100100 */
                    return(52);
                 else
                  /* 0000001000 */
                  return(18);
              else
               /* 0000000 */
               return(SEVENOHS);
       }

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

int pcxfd, pagelines;
struct header_s header;

pcxwriteheader()
	{
	int i;
	header.mfgr=10;
	header.version=45;
	header.encoding=1;
	header.bppix=1;
	header.xmin=0;
	header.ymin=0;
	header.xmax=1727;
	header.ymax=pagelines-1;
	header.hdpi=200;
	header.vdpi=192;
	header.reserved=0;
	header.nplanes=1;
	header.bypl=216;
	header.paltinf=1;
	header.hscrnsz=0;
	header.vscrnsz=0;
	for(i=0;i<54;++i)
		header.filler[i]=0;
	lseek(pcxfd, (long)0, SEEK_SET);
	if(write(pcxfd, &header, 128)!=128)
		{
		printf("Error overwriting final pcx file header.\n");
		exit(9);
		}
	}

unsigned char fcfr[]="+FCFR\r\n\r\n";
unsigned char fhng[]="+FHNG";
unsigned char connect[]="CONNECT\r\n";

int scanfcfr()
	{
	int i, j, k;
	unsigned char c;
	i=j=k=0;
	while(read(rfxfd, &c, 1))
		{
		if(fcfr[i]==c)
			{
			i++;
			if(fcfr[i]=='\0')
				return(1);
			}
		else
			i=0;
		if(connect[k]==c)
			{
			k++;
			if(connect[k]=='\0')
				return(0);
			}
		else
			k=0;
		if(fhng[j]==c)
			{
			j++;
			if(fhng[j]=='\0')
				{
				printf("End of document. Exit code +FHNG");
				while(1)
					{
					if(!read(rfxfd, &c, 1))
						{
						printf("\nPremature end of file while seeking +FHNG code.\n");
						exit(6);
						}
					putchar(c);
					if(c=='\n')
						break;
					}
				exit(0);
				}
			}
		else
			j=0;
		}
	printf("Premature end of file while seeking +FCFR.\n");
	exit(5);
	}

int scanconnect()
	{
	int i;
	unsigned char c;
	i=0;
	while(read(rfxfd, &c, 1))
		{
		if(connect[i]==c)
			{
			i++;
			if(connect[i]=='\0')
				return(0);
			}
		else
			i=0;
		}
	printf("Premature end of file while seeking CONNECT.\n");
	exit(7);
	}

int rfxgets(str)
	unsigned char *str;
	{
	int i;
	i=0;
	while(read(rfxfd, &str[i], 1))
		if(str[i]=='\r')
			{
			str[i]='\0';
			return(i);
			}
		else
			i++;
	return(-1);
	}

unsigned char line[216];
int linenbits;

putwhite(n)
	int n;
	{
	int bytenum, i;
	if(n>(1728-linenbits))
		n=1728-linenbits;
	bytenum=linenbits/8; /* integer division */
	for(i=7-(linenbits%8);(i>=0)&&(n>0);i--,n--)
		{
		line[bytenum]|=1<<i;
		linenbits++;
		}
	bytenum=linenbits/8;
	i=n/8;
	if(n%8)
		i++;
	for(;i>0;--i)
		line[bytenum++]=0xff; /* We limited n above */
	linenbits+=n;
	}

putblack(n)
	int n;
	{
	int bytenum, i;
	if(n>(1728-linenbits))
		n=1728-linenbits;
	bytenum=linenbits/8; /* integer division */
	for(i=7-(linenbits%8);(i>=0)&&(n>0);i--,n--)
		{
		line[bytenum]&=~(1<<i);
		linenbits++;
		}
	bytenum=linenbits/8;
	i=n/8;
	if(n%8)
		i++;
	for(;i>0;--i)
		line[bytenum++]=0x00;
	linenbits+=n;
	}

pcxwriteline(times)
	int times;
	{
	unsigned char pcxline[432], hold;
	int pcxnbytes, i, nreps;
	if(!linenbits)
		return(0);
	if(linenbits<1728)
		putwhite(1728-linenbits);
	pcxnbytes=0;
	/* PCX Encode */
	hold=line[0];
	nreps=i=1;
	while(1)
		{
		if((i<216)&&(line[i]==hold)) /* Reading beyond item is OK*/
			nreps++;
		else
			{
			if((nreps==1)&&((hold&0xc0)!=0xc0))
				pcxline[pcxnbytes++]=hold;
			else
				{
				while(nreps)
					{
					if(nreps>63)
						{
						pcxline[pcxnbytes++]=63|0xc0;
						pcxline[pcxnbytes++]=hold;
						nreps-=63;
						}
					else
						{
						pcxline[pcxnbytes++]=nreps|0xc0;
						pcxline[pcxnbytes++]=hold;
						nreps=0;
						}
					}
				nreps=1; /* This is a little ahead */
				}
			}
		if(i<216)
			hold=line[i++];
		else
			break;
		}
	/* Write encoded line */
	for(i=0;i<times;i++)
		{
		if(write(pcxfd, pcxline, pcxnbytes)!=pcxnbytes)
			{
			printf("Error writing encoded line to file.\n");
			exit(8);
			}
		pagelines++;
		}
	}

abortpage()
	{
	unsigned char c;
	printf("Flushing page...\n");
	while(1)
		{
		if(!read(rfxfd, &c, 1))
			{
			printf("Premature end of file while flushing bad page.\n");
			exit(30);
			}
		if(c==0x10)
			{
			if(!read(rfxfd, &c, 1))
				{
				printf("Premature end of file while flushing bad page.\n");
				exit(30);
				}
			if(c==0x03)
				break;
			}
		}
	}


main(argc, argv)
	int argc;
	char **argv;
	{
	int dcsvr, dcswd, dcsdf, page, symbol, bitcount;
	int dopage, npelschk, gotfcfr;
	unsigned char c, str[128];
	printf("Copyright (C) 1992 Peter Edward Cann\n\n");
	if((argc!=2)&&(argc!=3))
		{
		printf("USAGE: rfx2pcx <rfx filename> [/debug]\n");
		exit(10);
		}
	if(argc==3)
		debug=1;
	else
		debug=0;
	if((rfxfd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening %s for read.\n", argv[1]);
		exit(11);
		}
	while(1)
		{
		if(!read(rfxfd, &c, 1))
			{
			printf("Premature end of file while seeking initial doublequote.\n");
			exit(12);
			}
		if(c=='"')
			break;
		}
	printf("Sender ID: ");
	while(1)
		{
		if(!read(rfxfd, &c, 1))
			{
			printf("Premature end of file while seeking final doublequote.\n");
			exit(13);
			}
		if(c=='"')
			break;
		putchar(c);
		}
	putchar('\n');
	page=0;
	gotfcfr=0;
	while(1)
		{
		page++;
		if(scanfcfr()) /* Normal exit is in this function */
			{
			if(rfxgets(str)==-1)
				{
				printf("Premature end of file while seeking +FDCS.\n");
				exit(15);
				}
			if(sscanf(str, " +FDCS: %d,%*d,%d,%*d,%d,%*d,%*d,%*d",
				&dcsvr, &dcswd, &dcsdf)!=3)
				{
				printf("Error scanning +FDCS params.\n");
				exit(14);
				}
			else
				gotfcfr=1;
			if(dcsvr)
				printf("High vertical resolution.\n");
			else
				printf("Standard vertical resolution.\n");
			if(dcswd)
				{
				printf("Non-supported width!\n");
				exit(13);
				}
			if(dcsdf)
				{
				printf("Non-supported coding scheme (must be 1-D)!\n");
				exit(14);
				}
			scanconnect();
			gotfcfr=1;
			}
		if(!gotfcfr)
			{
			printf("Never got initial +FCFR; aborting.\n");
			exit(60);
			}
		bitmask=0;
		while(1)
			{
			printf("Enter filename for Page %d (include .PCX):\n--> ", page);
			gets(str);
			if((pcxfd=open(str, O_CREAT|O_BINARY|O_TRUNC|O_WRONLY, S_IWRITE))!=-1)
				break;
			else
				printf("Error opening file.\n");
			}
		/* Save a dummy block for PCX file header */
		if(write(pcxfd, str, 128)!=128)
			{
			printf("Error writing dummy header to file.\n");
			exit(20);
			}
		/* Translate */
		pagelines=0;
		while(getbit()); /* flush Panafax 1 bits */
		while(!getbit()); /* flush initial EOL */
		if(debug)
			printf(" = EOL\n");
		dopage=1;
		if(!setjmp(where)) /* returns -1 magically on DLE ETX */
			while(1)
				{
				/* loop over lines */
				linenbits=npelschk=0;
				while(1)
					{
					/* loop over symbols */
					symbol=getwhite();
					if(debug)
						{
						printf(" = %d White", symbol&0x0fff);
						if(symbol&MAKEUP)
							printf(" Makeup\n");
						else
							printf("\n");
						}
					bitcount=symbol&0x0fff;
					if(symbol&MAKEUP)
						{
						if(symbol==SEVENOHS)
							break;
						symbol=getwhite();
						if(debug)
							{
							printf(" = %d White", symbol&0x0fff);
							if(symbol&MAKEUP)
								printf(" Makeup\n");
							else
								printf("\n");
							}
						if(symbol&MAKEUP)
							{
							printf("Error: sequential makeups.\n");
							abortpage();
							dopage=0;
							break;
							}
						bitcount+=symbol&0x0fff;
						}
					npelschk+=bitcount;
					putwhite(bitcount);
					symbol=getblack();
					if(debug)
						{
						printf(" = %d Black", symbol&0x0fff);
						if(symbol&MAKEUP)
							printf(" Makeup\n");
						else
							printf("\n");
						}
					bitcount=symbol&0x0fff;
					if(symbol&MAKEUP)
						{
						if(symbol==SEVENOHS)
							break;
						symbol=getblack();
						if(debug)
							{
							printf(" = %d Black", symbol&0x0fff);
							if(symbol&MAKEUP)
								printf(" Makeup\n");
							else
								printf("\n");
							}
						if(symbol&MAKEUP)
							{
							printf("Error: sequential makeups.\n");
							abortpage();
							dopage=0;
							break;
							}
						bitcount+=symbol&0x0fff;
						}
					npelschk+=bitcount;
					putblack(bitcount);
					}
				if(!dopage)
					break;
				if(npelschk&&(npelschk!=1728))
					printf("Line %d bad; %d pels.\n", pagelines/(2-dcsvr), npelschk);
				pcxwriteline(2-dcsvr);
				while(!getbit());
				if(debug)
					printf(" = EOL\n");
				}
		else
			pcxwriteline(2-dcsvr);
		pcxwriteheader();
		close(pcxfd);
		printf("Page translate completed.\n");
		}
	}
