/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 *	MicroSoft QuickC
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include"port.h"

#define NAK 21
#define ACK 6
#define SOH 1
#define STX 2
#define EOT 4
#define CAN 24

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)));
	outp(basereg, c);
	}

int follow;

int rcharto(ticks)
	int ticks;
	{
	long tstamp, tstamp1, dayofticksp;
	int c;
	_bios_timeofday(_TIME_GETCLOCK, &tstamp);
	dayofticksp=0;
	while(1)
		{
		if(kbhit())
			getch();
		if(_bios_timeofday(_TIME_GETCLOCK, &tstamp1))
			dayofticksp+=20*60*60*24;
		if(tstamp1+dayofticksp-tstamp>ticks)
			return(-1); /* NOTE: This is an INT!!! */
		if(follow!=index)
			{
			c=buf[follow++];
			follow=follow%TBUFSIZ;
			return(c);
			}
		}
	}

int calccrc(ptr, count)
	char *ptr;
	int count;
	{
	int crc, i;
	crc = 0;
	while(--count >= 0)
		{
		crc = crc ^ (int)*ptr++ << 8;
		for(i = 0; i < 8; ++i)
			if(crc & 0x8000)
				crc = crc << 1 ^ 0x1021;
			else
				crc = crc << 1;
		}
	return (crc & 0xFFFF);
	}

unsigned char block[1024];

sblock(blockn)
	int blockn;
	{
	unsigned char c;
	unsigned short crc, rcrc;
	int i;
	crc=calccrc(block, 1024);
	sendchar(STX);
	sendchar(blockn);
	sendchar((blockn^0xff)&0xff);
	for(i=0;i<1024;++i)
		sendchar(block[i]);
	sendchar((crc>>8)&0xff);
	sendchar(crc&0xff);
	}

unsigned char shortblock[128];

ssblock(blockn)
	int blockn;
	{
	unsigned char c;
	unsigned short crc, rcrc;
	int i;
	crc=calccrc(shortblock, 128);
	sendchar(SOH);
	sendchar(blockn);
	sendchar((blockn^0xff)&0xff);
	for(i=0;i<128;++i)
		sendchar(shortblock[i]);
	sendchar((crc>>8)&0xff);
	sendchar(crc&0xff);
	}

quit()
	{
	cleanup(0);
	exit(99);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, k, l, infd, ok, c;
	unsigned char *blkptr;
	unsigned char blocknum;
	long nbytes;
	index=follow=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	printf("xmodem crc 1k send of %s.\n", argv[4]);
	if(argc!=5)
		{
		printf("USAGE: xmodemr <comnum> <bps> <stopbits> <file pathname>\n");
		exit(1);
		}
	if((infd=open(argv[4], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening file %s.\n", argv[4]);
		exit(2);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits=argv[3][0];
	setport();
	signal(SIGINT, quit);
	readset();
	setup();
	nbytes=0;
	if(rcharto(2000)!='C')
		{
		printf("Spurrious char or no C in 100 seconds.\n");
		cleanup(0);
		exit(10);
		}
	blocknum=1;
	while(1)
		{
		if((j=read(infd, block, 1024))==0)
			{
			printf("\nEnd of file.\n");
			sendchar(EOT);
			do
				c=rcharto(300);
			while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
			if(c!=ACK)
				{
				printf("No ACK of EOT.\n");
				cleanup(0);
				exit(13);
				}
			else
				{
				printf("Successful.\n");
				cleanup(0);
				exit(0);
				}
			}
		for(c=j;c<1024;c++)
			block[c]=26;
		if(j>896)
			{
			i=0;
			do
				{
				printf("\nSending block %d. ", blocknum);
				sblock(blocknum);
				do
					c=rcharto(200);
				while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
				}
			while((c==NAK)&&(i++<10));
			if(c==ACK)
				{
				blocknum++;
				nbytes+=1024;
				printf("Successful. Bytes so far: %ld", nbytes);
				}
			}
		else
			{
			for(k=0;k<(j+128);k+=128)
				{
				i=0;
				do
					{
					for(l=0;l<128;++l)
						shortblock[l]=block[k+l];
					printf("\nSending block %d. ", blocknum);
					ssblock(blocknum);
					do
						c=rcharto(200);
					while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
					}
				while((c==NAK)&&(i++<10));
				if(c!=ACK)
					break;
				else
					{
					blocknum++;
					nbytes+=128;
					printf("Successful. Bytes so far: %ld", nbytes);
					}
				}
			}
		if(c!=ACK)
			if(c==NAK)
				{
				printf("\nRetry limit exceeded.\n");
				cleanup(0);
				exit(14);
				}
			else
				{
				printf("\nSpurrious character hex %02x; ACK or NAK expected.\n", c);
				cleanup(0);
				exit(11);
				}
		}
	printf("Programming error; fell through end; see code.\n");
	cleanup(0);
	exit(12);
	}
