/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 *	MicroSoft QuickC: >qcl term.c graphics.lib
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include"port.h"

#define NAK 21
#define ACK 6
#define SOH 1
#define EOT 4
#define CAN 24

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)));
	outp(basereg, c);
	}

int follow;

int rcharto(ticks)
	int ticks;
	{
	long tstamp, tstamp1, dayofticksp;
	int c;
	_bios_timeofday(_TIME_GETCLOCK, &tstamp);
	dayofticksp=0;
	while(1)
		{
		if(_bios_timeofday(_TIME_GETCLOCK, &tstamp1))
			dayofticksp+=20*60*60*24;
		if(tstamp1+dayofticksp-tstamp>ticks)
			return(-1); /* NOTE: This is an INT!!! */
		if(follow!=index)
			{
			c=buf[follow++];
			follow=follow%TBUFSIZ;
			return(c);
			}
		}
	}


unsigned char block[128];

rblock()
	{
	int i, blockn, invblockn, rchecksum, checksum;
	checksum=0;
	if((blockn=rcharto(20))==-1)
		return(-1);
	printf("Block %d: ", blockn);
	if((invblockn=rcharto(20))==-1)
		return(-1);
	for(i=0;i<128;++i)
		{
		if((block[i]=rcharto(20))==-1)
			return(-1);
		checksum+=block[i];
		checksum&=0xff;
		}
	if((rchecksum=rcharto(20))==-1)
		return(-1);
	if(((invblockn^0xff)&0xff)!=blockn)
		{
		printf("Bad complement block number.\n");
		return(-1);
		}
	if(checksum!=rchecksum)
		{
		printf("Checksum mismatch. Here=%02x There=%02x.\n", checksum, rchecksum);
		return(-1);
		}
	return(blockn);
	}

quit()
	{
	cleanup(0);
	exit(99);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, outfd, ok, c;
	long nbytes;
	unsigned char blocknum;
	index=follow=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	printf("xmodem checksum receive of %s.\n", argv[4]);
	if(argc!=5)
		{
		printf("USAGE: xmodemr <comnum> <bps> <stopbits> <file pathname>\n");
		exit(1);
		}
	if((outfd=open(argv[4], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("Error opening file %s.\n", argv[4]);
		exit(2);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits=argv[3][0];
	setport();
	signal(SIGINT, quit);
	readset();
	setup();
	ok=nbytes=0;
	for(i=0;i<10;++i)
		{
		sendchar(NAK);
		c=rcharto(200);
		if(c==SOH)
			{
			ok=1;
			break;
			}
		}
	if(!ok)
		{
		printf("No SOH after 10 10-second-spaced NAKs.\n");
		cleanup(0);
		exit(10);
		}
	blocknum=1;
	for(i=0;i<10;++i)
		{
		printf("\nSeeking block %d: ", blocknum);
		if((c=rblock())==blocknum)
			{
			i=0;
			if(write(outfd, block, 128)!=128)
				{
				printf("Write error.\n");
				cleanup(0);
				exit(13);
				}
			nbytes+=128;
			printf("Successful. Bytes so far: %ld", nbytes);
			blocknum=(blocknum+1)&0xff;
			sendchar(ACK);
			}
		else
			if(c==-1)
				{
				while(rcharto(20)!=-1);
				sendchar(NAK);
				}
			else if(c<blocknum)
				sendchar(ACK);
			else
				{
				printf("\nSender skipped a block; cancelling transfer.\n");
				for(j=0;j<10;++j)
					sendchar(CAN);
				cleanup(0);
				exit(14);
				}
		do
			c=rcharto(200);
		while((c!=EOT)&&(c!=SOH)&&(c!=CAN)&&(c!=-1));
		if(c==EOT)
			{
			sendchar(ACK);
			printf("\nTransfer successful.\n");
			close(outfd);
			cleanup(0);
			exit(0);
			}
		if(c!=SOH)
			{
			if(c==-1)
				printf("Timeout waiting for SOH or EOT.\n");
			else
				printf("Spurrious character hex %02x; SOH or EOT expected.\n", c);
			cleanup(0);
			exit(11);
			}
		}
	printf("Retry limit exceeded.\n");
	cleanup(0);
	exit(12);
	}
