/*
**   DOOR.C  (11/07/95)
**
**   EXAMPLE CODE: Gain control w/o resetting UART.
**
**   (1) Make sure that SPAWN.EXE and DOOR.EXE are both
**       in the current directory.
**   (2) Start the companion program SPAWN.
**   (3) Within SPAWN, type '$' to request that DOOR.EXE be
**       spawned. DOOR will "take over" the COM port without
**       resetting the UART or dropping the modem carrier.
**   (4) When done, exit this program, then type EXIT to
**       return to SPAWN.
**
**   For more information, see documentation.
**
**   This example program (not the PCL4C library) is donated to
**   the Public Domain by MarshallSoft Computing, Inc. It is
**   provided as an example of the use of the PCL4C.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "pcl4c.h"

#define FALSE 0
#define TRUE !FALSE
#define CTLZ    0x1a
#define BUFSIZE 64

/*** Global Variables ***/

static char RxBuffer[BUFSIZE+16];
static char TxBuffer[BUFSIZE+16];
static int Port;

/*** Main ***/

int main(int argc,char *argv[])
{char c;
 char *ptr;
 int  i, rc;
 int  Seg;
 char far *Ptr;
 /* get comm port */
 if(argc!=2)
   {printf("DOOR: Usage: 'DOOR <port>' \n");
    return 1;
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20)) return 1;
 printf("DOOR: COM%d\n",1+Port);
 /* setup 128 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioRxBuf(Port,Seg,Size128);
 /* setup 128 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioTxBuf(Port,Seg,Size128);
 /* take over the port */
 SioReset(Port,NORESET);
 /* DTR & RTS will be the same as before calling SioReset */
 printf("DOOR: COM%d [DTR=%d]\n",1+Port,SioDTR(Port,'R'));
 printf("DOOR: Type ^Z to return to invoking program !\n");
 /* enter terminal loop */
 while(TRUE)
     {/* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==CTLZ)
              {/* restore COM port status & exit */
               SioDone(Port);
               printf("DOOR: Exiting...\n");
               return 0;
              }
           else SioPutc(Port,(char)i);
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) putch((char)i);
     } /* end while */
} /* end main */

