/*** sioerror.c [32-bit version] ***/

#include <stdio.h>
#include "windows.h"
#include "sioerr32.h"

static char *ErrorText[24] = {
  /*  0 */    "No error.",
  /* -1 */    "Timeout waiting for I/O.",
  /* -2 */    "Port not enabled.",
  /* -3 */    "No buffer available.",
  /* -4 */    "No such port.",
  /* -5 */    "Expecting 'S', 'C', or 'R' as 2nd argument.",
  /* -6 */    "Expecting 'A', 'C', or 'D' as 2nd argument.",
  /* -7 */    "Bad parity code.",
  /* -8 */    "Bad stop bits code.",
  /* -9 */    "Bad wordlength code.",
 /* -10 */    "Bad buffer size code.",
 /* -11 */    "Bad baud rate code.",
 /* -12 */    "LOOP_BACK test fails.",
 /* -13 */    "UART undefined.",
 /* -14 */    "Bad or missing UART.",
 /* -15 */    "Port already enabled.",
 /* -16 */    "ISR already in use",
 /* -17 */    "No such IRQ",
 /* -18 */    "ISR limit exceeded",
 /* -19 */    "Illegal Modification!",
 /* -20 */    "DPMI Error",
 /* -21 */    "Shareware Version Expired",
 /* -22 */    "Cannot allocate memory",
 /* other */  "No such error code."};

void cdecl SioError(int Code)
{int Index;
 if(Code==0) Index = 0;
 else
   {if(Code<-22) Index = 23;
    else Index = 0 - Code;
   }
 printf("\n%s\n",ErrorText[Index]);
} /* end SioError */
