; see video.txt for what's what
.data

include vesa.inc

.code
;vga.asm
g_getmode proto,:word,:word,:byte
g_setmode proto

;text.asm
t_setmode proto,:byte,:byte
t_savestate proto
t_restorestate proto,:dword

;video sub-system
g_copy   proto                   ;copy temp area to actual screen
g_setbuf proto,o:dword           ;sets temp area used by grafic functions
g_setpal proto,pal:dword         ;768 byte array
g_setcol proto,n:byte,r:byte,g:byte,b:byte
g_get    proto,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_put    proto,src:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_put0   proto,src:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_waitvsync proto

mouse_init      proto
mouse_uninit    proto
mouse_setcursor proto,_cur:dword
mouse_loadcursor proto,:dword
mouse_setcursor_text proto,_color:byte
mouse_setspd    proto,xr:byte,yr:byte  ; (1-4 , 1-4)
mouse_setwin    proto,x1:dword,y1:dword,x2:dword,y2:dword
mouse_on        proto
mouse_off       proto
mouse_setuser   proto,func:dword,ustruct:dword
mouse_setpos    proto,x:dword,y:dword

mouse_user struct
  x dw ?
  y dw ?
  but dw ?
mouse_user ends

g_setfnt   proto,fbuf:dword
g_getfnt   proto
g_loadfnt  proto,nam:dword
g_setfntcolor proto,col:dword
g_putch    proto,x:dword,y:dword,char:byte
g_printxy  proto,x:dword,y:dword,s:dword
g_printf   proto,x:dword,y:dword,str1:dword,argv:vararg

g_hline proto,x:dword,y:dword,l:dword,col:dword
g_vline proto,x:dword,y:dword,l:dword,col:dword
g_box proto,x1:dword,y1:dword,x2:dword,y2:dword,col:dword
g_boxfill proto,x1:dword,y1:dword,x2:dword,y2:dword,col:dword
g_cls proto

;vesa
vesa_init proto
vesa_func6 proto
vesa_setstart proto,:dword,:dword
vesa_firstmode proto
vesa_nextmode proto

externdef vesa_info:vesa_infoblock
externdef vesa_modeinfo:vesa_modeinfoblock

.data
externdef _v_buffer:dword
externdef _v_linear:dword

;mouse ptr header (QLIB v2.06)
g_mousehead struct
  head db 'PTR',27
  x dw ?
  y dw ?
  hx dw ?
  hy dw ?
  bpp db ?   ;bits / pixel  (ignored)
  bypp db ?  ;bytes / pixel
  flg db ?   ;reserved
g_mousehead ends

;Font header     (QLIB v1.1)
g_fnthead struct
  head db 'FNT',27
  x dw ?
  y dw ?
  bpp db ?   ;bits / pixel  (ignored)
  bypp db ?  ;bytes / pixel
  flg db ?   ;(bit 1=mono-colored font - g_setfntcolor())
g_fnthead ends

G_TEXT equ 1
G_VGA equ 2
G_VESA equ 3
G_MODEX equ 4

