.code
align 4
;TEXT set mode
; Supports : (80x25) and (80x50)
t_setmode proc,x:byte,y:byte
  pushad
  call exitmode
  mov _copy,offset NULLPROC
  mov _v_linear,0b8000h
  mov curmode,G_TEXT
  mov _v_x,80
  mov _v_y,25
  mov ax,3
  int 10h
  .if x==80 && y==50
    mov _v_y,50
    ;setmode50
    mov ax,1112h
    xor bx,bx
    int 10h
    mov ax,1200h
    mov bx,20h
    int 10h
  .endif
  call clrscr   ;clear the screen incase ANSI.SYS is loaded to give the color back
  popad
  xor eax,eax
  ret
t_setmode endp

t_savestate proc
  ;uses INT 10h func 1ch
  local buf:dword
  local bufsiz:dword
  local vbufsiz:dword
  pushad
  mov ax,1c00h
  mov cx,7
  int 10h
  cmp al,1ch
  jz good
bad:
  popad
  mov eax,NULL
  ret
good:
  shl bx,5   ;bx * 64
  .if bx>8*1024
    jmp bad
  .endif
  xor ecx,ecx
  mov cx,bx
  mov bufsiz,ecx
  add ecx,8  ;add some room for bufsiz/vbufsiz
  mov eax,ds:[44ch]   ;video buffer size in bytes
  mov vbufsiz,eax
  add ecx,eax
  callp malloc,ecx
  cmp eax,NULL
  jz bad
  mov buf,eax
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov wptr[esp].callstruct._eax,1c01h  ;save state
  mov bptr[esp].callstruct._ecx,7      ;save all info
  mov ax,_8kbufferseg
  mov wptr[esp].callstruct._es,ax
  mov wptr[esp].callstruct._ebx,0
  mov ax,300h
  mov bx,10h
  xor cx,cx
  mov edi,esp
  int 31h  ;call real mode INT
  .if carry?
    add esp,sizeof callstruct
    jmp bad
  .endif
  add esp,sizeof callstruct
  mov esi,_8kbuffer
  mov edi,buf
  mov eax,bufsiz
  mov [edi],eax
  mov eax,vbufsiz
  mov [edi+4],eax
  add edi,8
  mov ecx,bufsiz
  shr ecx,2  ;will be a multi of 64 anyways
  rep movsd
  mov esi,0b8000h
  mov ecx,vbufsiz
  mov al,cl
  shr ecx,2
  rep movsd
  and al,3
  .if !zero?
    mov cl,al
    rep movsb
  .endif
  popad
  mov eax,buf
  ret
t_savestate endp

t_restorestate proc,a:dword
  pushad
  mov esi,a
  mov edi,_8kbuffer
  mov ecx,[esi]
  add esi,8
  rep movsd
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov wptr[esp].callstruct._eax,1c02h  ;restore state
  mov bptr[esp].callstruct._ecx,7      ;restore all info
  mov ax,_8kbufferseg
  mov wptr[esp].callstruct._es,ax
  mov wptr[esp].callstruct._ebx,0
  mov ax,300h
  mov bx,10h
  xor cx,cx
  mov edi,esp
  int 31h  ;call real mode INT
  add esp,sizeof callstruct

  mov esi,a
  mov edi,0b8000h
  mov eax,[esi]
  mov ecx,[esi+4]
  add esi,eax
  add esi,8
  mov al,cl
  shr ecx,2
  rep movsd
  and al,3
  .if !zero?
    mov cl,al
    rep movsb
  .endif

  popad
  xor eax,eax
  ret
t_restorestate endp

