;---------------------------------------------------------------------
;                          PRNG31.ASM
;         Demonstration of a PseudoRandom Number Generator
;             Uses a 31 stage software shift register
;---------------------------------------------------------------------
; The 31 bit shift register is represented by the data in [shift_reg].
; Seed these bits with a constant initial value to generate repeatable
; sequences.  Alternatively, you can use other sources such as the BIOS
; real time clock 'ticks' counter for the seed.  Any non-zero seed
; will work.
; (see the READ.ME file for more information).
;---------------------------------------------------------------------
;=====================================================================
; Implementation by: R.F. Genovese, Ph.D.
;                    TEKNOMETRIKA
;                    L-15, S-123
;                    11160 Veirs Mill Road
;                    Wheaton, MD 20902
;=====================================================================
        IDEAL
;(We used TASM /la /w /ml and TLINK /T /s)
        DOSSEG
        MODEL   TINY
        DATASEG
signon  db      0dh,0ah,'  Press any key to generate eight bit '
        db      'pseudorandom numbers  [CTRL-C to quit].'
        db      0dh,0ah,0ah,'$'
number  db      '000 $'                 ;display string
;The 31 bit shift register.
shift_reg       dd      5a5aa55ah       ;a nice seed
        CODESEG
        ORG     0100h
start:
        mov     ax,02h                  ;clear the screen
        int     10h
hello:
        mov     dx,offset signon        ;display message
        mov     ah,09h
        int     21h
;Wait for a keypress and leave if it's CTRL-C.
get_key:
        mov     ah,07h
        int     21h
        cmp     al,03h                  ;ctrl-c pressed?
        jz      exit                    ;then quit
        mov     di,1a4h                 ;21 lines of numbers
get_bits:
;Get eight pseudorandom bits into al.
        mov     cx,08h                  ;bit counter
        xor     ax,ax                   ;initial to 0
gen_num:
;Determine the result of (bit three xor bit six) of the high
; byte of the shift register and put the result in the carry.
        mov     bx,[WORD HIGH shift_reg]
        and     bh,048h                 ;08h or 40h is result=1 else 0
        cmp     bh,08h
        jz      xor1
        cmp     bh,40h
        jz      xor1
        clc                             ;xor result=0 so clear carry
        jmp     short shift_bits
xor1:
        stc                             ;xor result=1 so set carry
;Rotate the shift register with the cf becoming the lsb.
shift_bits:
        rcl     [WORD LOW shift_reg],1
        rcl     [WORD HIGH shift_reg],1
;The new cf gets rotated into our pseudorandom number.
        rcl     al,1
        loop    gen_num                 ;get all eight bits
;Convert al to a leading zero ascii string.
        mov     si,offset number+2      ;lsd of string
        mov     cx,03h                  ;3 digits to convert
        mov     dl,0ah                  ;divisor
bin2asc:
        xor     ah,ah                   ;clear remainder
        div     dl                      ;get a remainder
        add     ah,30h                  ;make it ascii
        mov     [si],ah                 ;store the digit
        dec     si                      ;bump the point
        loop    bin2asc
;Send ascii string to standard output device (display).
        mov     dx,offset number
        mov     ah,09h
        int     21h
        dec     di
        jnz     get_bits                ;do another number
        jmp     short hello             ;do another screen
;Webedone.
exit:
        mov     ah,04ch
        int     21h                     ;back2dos
        END start
