/*********************************************************************
			  TSTRND31.C
  Visual demonstration of the shift register pseudorandom number
  generator. TurboC 2.0, tiny model. Uses RANGEN.OBJ (see TESTGEN.PRJ).
  See the READ.ME file for further details.
 =====================================================================
  Implementation by: R.F. Genovese, Ph.D.
		     TEKNOMETRIKA
		     L-15, S-123
		     11160 Veirs Mill Road
		     Wheaton, MD 20902
**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>

/* defined in tstrndc.asm */
extern unsigned int get_ran();
extern void seed_ran();
extern unsigned long r_seed;

main(){
  union REGS regs;
  struct text_info initial;
  int frequency[80],max,cursor,last,spot=178;
  unsigned char curslow,curshigh,page=0,bitsize=7;

  /* check, get, and save, user's display characteristics */
  gettextinfo(&initial);
  if((initial.currmode!=7)&&(initial.currmode!=2)&&(initial.currmode!=3)){
    cprintf("\n\rSorry, I need an 80 column video mode (i.e. 2, 3, or 7).");
    exit(1);
    }
  if(initial.currmode==3)
    textattr(31);
  else
    textattr(7);
  regs.h.ah=15;
  page=regs.h.bh;
  int86(0x10,&regs,&regs);
  page=regs.h.bh;
  /* cursor off */
  regs.h.ah=3;
  regs.h.bh=page;
  int86(0x10,&regs,&regs);
  curslow=regs.h.cl;
  curshigh=regs.h.ch;
  regs.h.ah=1;
  regs.h.ch=curshigh|0x20;
  regs.h.cl=curslow;
  int86(0x10,&regs,&regs);
  /* print a welcome message */
  clrscr();
  gotoxy(1,1);
  cprintf("\n\r\n\r\n\r");
  cprintf("  TSTRND31 is a simple visual demonstration of a 31 bit shift ");
  cprintf("register style\n\r  pseudorandom number generator.  We plot ");
  cprintf("columns on the screen representing\n\r  the pseudorandom number ");
  cprintf("sequences.  The program will run continuously.\n\r\n\r\n\r\n\r");
  cprintf("\n\r                 Press a key to begin and another to end.");
  (void)getch();
  seed_ran();	/* seed the generate once */
  while(!kbhit()){
    clrscr();
    gotoxy(1,1);
    /* clear column counter array */
    for(last=0;last<80;last++)
      frequency[last]=0;
    max=0;
    /* generate and plot values until a column reaches the display top */
    while(max!=24){
      /*
      here we redraw the number (without a new seed) if it's over
      79 (it can be as large as 127 with bitsize=7)
      */
      while((last=get_ran(bitsize))>79);
      frequency[last]++;
      max=frequency[last];
      gotoxy(last+1,25-frequency[last]);
      putch(spot);
     }
    /* we finished a screen, wait a bit and do it again */
    delay(1800);
   }
   /* user has terminated the program, fix up some stuff and leave */
   textattr(initial.attribute);
   gotoxy(1,1);
   clrscr();
   /* cursor on */
   regs.h.ah=1;
   regs.h.ch=curshigh&0xdf;
   regs.h.cl=curslow;
   int86(0x10,&regs,&regs);
   /* webedone */
   (void)getch();
   exit(0);
}
